/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Binomial distribution excess kurtosis.
*
* @module @stdlib/stats/base/dists/binomial/kurtosis
*
* @example
* var kurtosis = require( '@stdlib/stats/base/dists/binomial/kurtosis' );
*
* var v = kurtosis( 100, 0.1 );
* // returns ~0.051
*
* v = kurtosis( 20, 0.5 );
* // returns ~-0.1
*/

// MODULES //

var kurtosis = require( './kurtosis.js' );


// EXPORTS //

module.exports = kurtosis;
