# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class ApplicationServerVirtualMachineType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the type of application server VM."""

    ACTIVE = "Active"
    """Active Application server vm type."""
    STANDBY = "Standby"
    """Standby Application server vm type."""
    UNKNOWN = "Unknown"
    """Unknown Application server vm type."""


class CentralServerVirtualMachineType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the type of central server VM."""

    PRIMARY = "Primary"
    """Primary central server vm."""
    SECONDARY = "Secondary"
    """Secondary central server vm."""
    UNKNOWN = "Unknown"
    """Central server vm type unknown."""
    ASCS = "ASCS"
    """ASCS Central server vm type."""
    ERS_INACTIVE = "ERSInactive"
    """ERSInactive Central server vm type."""
    ERS = "ERS"
    """ERS Central server vm type."""
    STANDBY = "Standby"
    """Standby Central server vm type."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DiskSkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the disk sku name."""

    STANDARD_LRS = "Standard_LRS"
    """Standard LRS Disk SKU."""
    PREMIUM_LRS = "Premium_LRS"
    """Premium_LRS Disk SKU."""
    STANDARD_SSD_LRS = "StandardSSD_LRS"
    """StandardSSD_LRS Disk SKU."""
    ULTRA_SSD_LRS = "UltraSSD_LRS"
    """UltraSSD_LRS Disk SKU."""
    PREMIUM_ZRS = "Premium_ZRS"
    """Premium_ZRS Disk SKU."""
    STANDARD_SSD_ZRS = "StandardSSD_ZRS"
    """StandardSSD_ZRS Disk SKU."""
    PREMIUM_V2_LRS = "PremiumV2_LRS"
    """PremiumV2_LRS Disk SKU."""


class EnqueueReplicationServerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the type of Enqueue Replication Server."""

    ENQUEUE_REPLICATOR1 = "EnqueueReplicator1"
    """Enqueue Replication server type 1."""
    ENQUEUE_REPLICATOR2 = "EnqueueReplicator2"
    """Enqueue Replication server type 2."""


class FileShareConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of file share config."""

    SKIP = "Skip"
    """Skip creating the file share."""
    CREATE_AND_MOUNT = "CreateAndMount"
    """Fileshare will be created and mounted by service."""
    MOUNT = "Mount"
    """Existing fileshare provided will be mounted by service."""


class ManagedResourcesNetworkAccessType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the network access type for managed resources."""

    PUBLIC = "Public"
    """Managed resources will be deployed with public network access enabled."""
    PRIVATE = "Private"
    """Managed resources will be deployed with public network access disabled."""


class NamingPatternType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The pattern type to be used for resource naming."""

    FULL_RESOURCE_NAME = "FullResourceName"
    """Full resource names that will be created by service."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class OSType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The OS Type."""

    LINUX = "Linux"
    """Linux OS Type."""
    WINDOWS = "Windows"
    """Windows OS Type."""


class SAPConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The configuration Type."""

    DEPLOYMENT = "Deployment"
    """SAP system will be deployed by service. No OS configurations will be done."""
    DISCOVERY = "Discovery"
    """Existing SAP system will be registered."""
    DEPLOYMENT_WITH_OS_CONFIG = "DeploymentWithOSConfig"
    """SAP system will be deployed by service. OS configurations will be done."""


class SAPDatabaseScaleMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The database scale method."""

    SCALE_UP = "ScaleUp"
    """ScaleUp Hana Database deployment type"""


class SAPDatabaseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the supported SAP Database types."""

    HANA = "HANA"
    """HANA Database type of SAP system."""
    DB2 = "DB2"
    """DB2 database type of the SAP system."""


class SAPDeploymentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of SAP deployment, single server or Three tier."""

    SINGLE_SERVER = "SingleServer"
    """SAP Single server deployment type."""
    THREE_TIER = "ThreeTier"
    """SAP Distributed deployment type."""


class SAPEnvironmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the environment type - Production/Non Production."""

    NON_PROD = "NonProd"
    """Non Production SAP system."""
    PROD = "Prod"
    """Production SAP system."""


class SAPHealthState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the health of SAP Instances."""

    UNKNOWN = "Unknown"
    """SAP System health is unknown."""
    HEALTHY = "Healthy"
    """SAP System health is healthy."""
    UNHEALTHY = "Unhealthy"
    """SAP System is unhealthy."""
    DEGRADED = "Degraded"
    """SAP System health is degraded."""


class SAPHighAvailabilityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The high availability type (AvailabilitySet or AvailabilityZone)."""

    AVAILABILITY_SET = "AvailabilitySet"
    """HA deployment with availability sets."""
    AVAILABILITY_ZONE = "AvailabilityZone"
    """HA deployment with availability zones."""


class SAPProductType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the SAP Product type."""

    ECC = "ECC"
    """SAP Product ECC."""
    S4HANA = "S4HANA"
    """SAP Product S4HANA."""
    OTHER = "Other"
    """SAP Products other than the ones listed."""


class SAPSoftwareInstallationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SAP software installation Type."""

    SERVICE_INITIATED = "ServiceInitiated"
    """SAP Install managed by service."""
    SAP_INSTALL_WITHOUT_OS_CONFIG = "SAPInstallWithoutOSConfig"
    """SAP Install without OS Config."""
    EXTERNAL = "External"
    """External software installation type."""


class SAPVirtualInstanceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where only None and UserAssigned types are allowed)."""

    NONE = "None"
    """No managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""


class SapVirtualInstanceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the provisioning states."""

    SUCCEEDED = "Succeeded"
    """ACSS succeeded provisioning state."""
    UPDATING = "Updating"
    """ACSS updating provisioning state."""
    CREATING = "Creating"
    """ACSS Creating provisioning state."""
    FAILED = "Failed"
    """ACSS Failed provisioning state."""
    DELETING = "Deleting"
    """ACSS Deleting provisioning state."""
    CANCELED = "Canceled"
    """ACSS Canceled provisioning state."""


class SAPVirtualInstanceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the Virtual Instance for SAP state."""

    INFRASTRUCTURE_DEPLOYMENT_PENDING = "InfrastructureDeploymentPending"
    """Infrastructure is not yet deployed."""
    INFRASTRUCTURE_DEPLOYMENT_IN_PROGRESS = "InfrastructureDeploymentInProgress"
    """Infrastructure deployment is in progress."""
    INFRASTRUCTURE_DEPLOYMENT_FAILED = "InfrastructureDeploymentFailed"
    """Infrastructure deployment has failed."""
    SOFTWARE_INSTALLATION_PENDING = "SoftwareInstallationPending"
    """Infrastructure deployment is successful. Software installation is pending."""
    SOFTWARE_INSTALLATION_IN_PROGRESS = "SoftwareInstallationInProgress"
    """Software installation is in progress."""
    SOFTWARE_INSTALLATION_FAILED = "SoftwareInstallationFailed"
    """Software installation failed."""
    SOFTWARE_DETECTION_IN_PROGRESS = "SoftwareDetectionInProgress"
    """Software detection is in progress."""
    SOFTWARE_DETECTION_FAILED = "SoftwareDetectionFailed"
    """Software detection failed."""
    DISCOVERY_PENDING = "DiscoveryPending"
    """Registration has not started."""
    DISCOVERY_IN_PROGRESS = "DiscoveryInProgress"
    """Registration is in progress."""
    DISCOVERY_FAILED = "DiscoveryFailed"
    """Registration has failed."""
    REGISTRATION_COMPLETE = "RegistrationComplete"
    """Registration is complete."""
    ACSS_INSTALLATION_BLOCKED = "ACSSInstallationBlocked"
    """ACSS installation cannot proceed."""


class SAPVirtualInstanceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the SAP Instance status."""

    STARTING = "Starting"
    """SAP system is getting started."""
    RUNNING = "Running"
    """SAP system is running."""
    STOPPING = "Stopping"
    """SAP system is being stopped."""
    OFFLINE = "Offline"
    """SAP system is offline."""
    PARTIALLY_RUNNING = "PartiallyRunning"
    """SAP system is partially running."""
    UNAVAILABLE = "Unavailable"
    """SAP system status is unavailable."""
    SOFT_SHUTDOWN = "SoftShutdown"
    """Soft shutdown of SAP system is initiated."""
