//! Cached exponents for basen values with 80-bit extended floats.
//!
//! Exact versions of base**n as an extended-precision float, with both
//! large and small powers. Use the large powers to minimize the amount
//! of compounded error. This is used in the Bellerophon algorithm.
//!
//! These values were calculated using Python, using the arbitrary-precision
//! integer to calculate exact extended-representation of each value.
//! These values are all normalized.
//!
//! These files takes ~30 KB of storage.
//!
//! Total array storage:
//!  With radix: ~20 KB:
//!     2534 u64
//!
//! DO NOT MODIFY: Generated by `etc/bellerophon_table.py`

#![cfg(feature = "radix")]
#![doc(hidden)]

use crate::bellerophon::BellerophonPowers;
#[cfg(feature = "compact")]
use crate::table_bellerophon_decimal::BASE10_POWERS;

/// Get Bellerophon powers from radix.
#[inline]
pub const fn bellerophon_powers(radix: u32) -> &'static BellerophonPowers {
    match radix {
        3 => &BASE3_POWERS,
        5 => &BASE5_POWERS,
        6 => &BASE6_POWERS,
        7 => &BASE7_POWERS,
        9 => &BASE9_POWERS,
        #[cfg(feature = "compact")]
        10 => &BASE10_POWERS,
        11 => &BASE11_POWERS,
        12 => &BASE12_POWERS,
        13 => &BASE13_POWERS,
        14 => &BASE14_POWERS,
        15 => &BASE15_POWERS,
        17 => &BASE17_POWERS,
        18 => &BASE18_POWERS,
        19 => &BASE19_POWERS,
        20 => &BASE20_POWERS,
        21 => &BASE21_POWERS,
        22 => &BASE22_POWERS,
        23 => &BASE23_POWERS,
        24 => &BASE24_POWERS,
        25 => &BASE25_POWERS,
        26 => &BASE26_POWERS,
        27 => &BASE27_POWERS,
        28 => &BASE28_POWERS,
        29 => &BASE29_POWERS,
        30 => &BASE30_POWERS,
        31 => &BASE31_POWERS,
        33 => &BASE33_POWERS,
        34 => &BASE34_POWERS,
        35 => &BASE35_POWERS,
        36 => &BASE36_POWERS,
        // Fallback if we have an invalid radix.
        _ => &INVALID_POWERS,
    }
}

// HIGH LEVEL
// ----------

pub const INVALID_POWERS: BellerophonPowers = BellerophonPowers {
    small: &[],
    large: &[],
    small_int: &[],
    step: 0,
    bias: 0,
    log2: 0,
    log2_shift: 0,
};

pub const BASE3_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE3_SMALL_MANTISSA,
    large: &BASE3_LARGE_MANTISSA,
    small_int: &BASE3_SMALL_INT_POWERS,
    step: BASE3_STEP,
    bias: BASE3_BIAS,
    log2: BASE3_LOG2_MULT,
    log2_shift: BASE3_LOG2_SHIFT,
};

pub const BASE5_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE5_SMALL_MANTISSA,
    large: &BASE5_LARGE_MANTISSA,
    small_int: &BASE5_SMALL_INT_POWERS,
    step: BASE5_STEP,
    bias: BASE5_BIAS,
    log2: BASE5_LOG2_MULT,
    log2_shift: BASE5_LOG2_SHIFT,
};

pub const BASE6_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE6_SMALL_MANTISSA,
    large: &BASE6_LARGE_MANTISSA,
    small_int: &BASE6_SMALL_INT_POWERS,
    step: BASE6_STEP,
    bias: BASE6_BIAS,
    log2: BASE6_LOG2_MULT,
    log2_shift: BASE6_LOG2_SHIFT,
};

pub const BASE7_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE7_SMALL_MANTISSA,
    large: &BASE7_LARGE_MANTISSA,
    small_int: &BASE7_SMALL_INT_POWERS,
    step: BASE7_STEP,
    bias: BASE7_BIAS,
    log2: BASE7_LOG2_MULT,
    log2_shift: BASE7_LOG2_SHIFT,
};

pub const BASE9_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE9_SMALL_MANTISSA,
    large: &BASE9_LARGE_MANTISSA,
    small_int: &BASE9_SMALL_INT_POWERS,
    step: BASE9_STEP,
    bias: BASE9_BIAS,
    log2: BASE9_LOG2_MULT,
    log2_shift: BASE9_LOG2_SHIFT,
};

pub const BASE11_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE11_SMALL_MANTISSA,
    large: &BASE11_LARGE_MANTISSA,
    small_int: &BASE11_SMALL_INT_POWERS,
    step: BASE11_STEP,
    bias: BASE11_BIAS,
    log2: BASE11_LOG2_MULT,
    log2_shift: BASE11_LOG2_SHIFT,
};

pub const BASE12_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE12_SMALL_MANTISSA,
    large: &BASE12_LARGE_MANTISSA,
    small_int: &BASE12_SMALL_INT_POWERS,
    step: BASE12_STEP,
    bias: BASE12_BIAS,
    log2: BASE12_LOG2_MULT,
    log2_shift: BASE12_LOG2_SHIFT,
};

pub const BASE13_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE13_SMALL_MANTISSA,
    large: &BASE13_LARGE_MANTISSA,
    small_int: &BASE13_SMALL_INT_POWERS,
    step: BASE13_STEP,
    bias: BASE13_BIAS,
    log2: BASE13_LOG2_MULT,
    log2_shift: BASE13_LOG2_SHIFT,
};

pub const BASE14_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE14_SMALL_MANTISSA,
    large: &BASE14_LARGE_MANTISSA,
    small_int: &BASE14_SMALL_INT_POWERS,
    step: BASE14_STEP,
    bias: BASE14_BIAS,
    log2: BASE14_LOG2_MULT,
    log2_shift: BASE14_LOG2_SHIFT,
};

pub const BASE15_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE15_SMALL_MANTISSA,
    large: &BASE15_LARGE_MANTISSA,
    small_int: &BASE15_SMALL_INT_POWERS,
    step: BASE15_STEP,
    bias: BASE15_BIAS,
    log2: BASE15_LOG2_MULT,
    log2_shift: BASE15_LOG2_SHIFT,
};

pub const BASE17_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE17_SMALL_MANTISSA,
    large: &BASE17_LARGE_MANTISSA,
    small_int: &BASE17_SMALL_INT_POWERS,
    step: BASE17_STEP,
    bias: BASE17_BIAS,
    log2: BASE17_LOG2_MULT,
    log2_shift: BASE17_LOG2_SHIFT,
};

pub const BASE18_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE18_SMALL_MANTISSA,
    large: &BASE18_LARGE_MANTISSA,
    small_int: &BASE18_SMALL_INT_POWERS,
    step: BASE18_STEP,
    bias: BASE18_BIAS,
    log2: BASE18_LOG2_MULT,
    log2_shift: BASE18_LOG2_SHIFT,
};

pub const BASE19_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE19_SMALL_MANTISSA,
    large: &BASE19_LARGE_MANTISSA,
    small_int: &BASE19_SMALL_INT_POWERS,
    step: BASE19_STEP,
    bias: BASE19_BIAS,
    log2: BASE19_LOG2_MULT,
    log2_shift: BASE19_LOG2_SHIFT,
};

pub const BASE20_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE20_SMALL_MANTISSA,
    large: &BASE20_LARGE_MANTISSA,
    small_int: &BASE20_SMALL_INT_POWERS,
    step: BASE20_STEP,
    bias: BASE20_BIAS,
    log2: BASE20_LOG2_MULT,
    log2_shift: BASE20_LOG2_SHIFT,
};

pub const BASE21_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE21_SMALL_MANTISSA,
    large: &BASE21_LARGE_MANTISSA,
    small_int: &BASE21_SMALL_INT_POWERS,
    step: BASE21_STEP,
    bias: BASE21_BIAS,
    log2: BASE21_LOG2_MULT,
    log2_shift: BASE21_LOG2_SHIFT,
};

pub const BASE22_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE22_SMALL_MANTISSA,
    large: &BASE22_LARGE_MANTISSA,
    small_int: &BASE22_SMALL_INT_POWERS,
    step: BASE22_STEP,
    bias: BASE22_BIAS,
    log2: BASE22_LOG2_MULT,
    log2_shift: BASE22_LOG2_SHIFT,
};

pub const BASE23_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE23_SMALL_MANTISSA,
    large: &BASE23_LARGE_MANTISSA,
    small_int: &BASE23_SMALL_INT_POWERS,
    step: BASE23_STEP,
    bias: BASE23_BIAS,
    log2: BASE23_LOG2_MULT,
    log2_shift: BASE23_LOG2_SHIFT,
};

pub const BASE24_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE24_SMALL_MANTISSA,
    large: &BASE24_LARGE_MANTISSA,
    small_int: &BASE24_SMALL_INT_POWERS,
    step: BASE24_STEP,
    bias: BASE24_BIAS,
    log2: BASE24_LOG2_MULT,
    log2_shift: BASE24_LOG2_SHIFT,
};

pub const BASE25_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE25_SMALL_MANTISSA,
    large: &BASE25_LARGE_MANTISSA,
    small_int: &BASE25_SMALL_INT_POWERS,
    step: BASE25_STEP,
    bias: BASE25_BIAS,
    log2: BASE25_LOG2_MULT,
    log2_shift: BASE25_LOG2_SHIFT,
};

pub const BASE26_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE26_SMALL_MANTISSA,
    large: &BASE26_LARGE_MANTISSA,
    small_int: &BASE26_SMALL_INT_POWERS,
    step: BASE26_STEP,
    bias: BASE26_BIAS,
    log2: BASE26_LOG2_MULT,
    log2_shift: BASE26_LOG2_SHIFT,
};

pub const BASE27_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE27_SMALL_MANTISSA,
    large: &BASE27_LARGE_MANTISSA,
    small_int: &BASE27_SMALL_INT_POWERS,
    step: BASE27_STEP,
    bias: BASE27_BIAS,
    log2: BASE27_LOG2_MULT,
    log2_shift: BASE27_LOG2_SHIFT,
};

pub const BASE28_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE28_SMALL_MANTISSA,
    large: &BASE28_LARGE_MANTISSA,
    small_int: &BASE28_SMALL_INT_POWERS,
    step: BASE28_STEP,
    bias: BASE28_BIAS,
    log2: BASE28_LOG2_MULT,
    log2_shift: BASE28_LOG2_SHIFT,
};

pub const BASE29_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE29_SMALL_MANTISSA,
    large: &BASE29_LARGE_MANTISSA,
    small_int: &BASE29_SMALL_INT_POWERS,
    step: BASE29_STEP,
    bias: BASE29_BIAS,
    log2: BASE29_LOG2_MULT,
    log2_shift: BASE29_LOG2_SHIFT,
};

pub const BASE30_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE30_SMALL_MANTISSA,
    large: &BASE30_LARGE_MANTISSA,
    small_int: &BASE30_SMALL_INT_POWERS,
    step: BASE30_STEP,
    bias: BASE30_BIAS,
    log2: BASE30_LOG2_MULT,
    log2_shift: BASE30_LOG2_SHIFT,
};

pub const BASE31_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE31_SMALL_MANTISSA,
    large: &BASE31_LARGE_MANTISSA,
    small_int: &BASE31_SMALL_INT_POWERS,
    step: BASE31_STEP,
    bias: BASE31_BIAS,
    log2: BASE31_LOG2_MULT,
    log2_shift: BASE31_LOG2_SHIFT,
};

pub const BASE33_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE33_SMALL_MANTISSA,
    large: &BASE33_LARGE_MANTISSA,
    small_int: &BASE33_SMALL_INT_POWERS,
    step: BASE33_STEP,
    bias: BASE33_BIAS,
    log2: BASE33_LOG2_MULT,
    log2_shift: BASE33_LOG2_SHIFT,
};

pub const BASE34_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE34_SMALL_MANTISSA,
    large: &BASE34_LARGE_MANTISSA,
    small_int: &BASE34_SMALL_INT_POWERS,
    step: BASE34_STEP,
    bias: BASE34_BIAS,
    log2: BASE34_LOG2_MULT,
    log2_shift: BASE34_LOG2_SHIFT,
};

pub const BASE35_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE35_SMALL_MANTISSA,
    large: &BASE35_LARGE_MANTISSA,
    small_int: &BASE35_SMALL_INT_POWERS,
    step: BASE35_STEP,
    bias: BASE35_BIAS,
    log2: BASE35_LOG2_MULT,
    log2_shift: BASE35_LOG2_SHIFT,
};

pub const BASE36_POWERS: BellerophonPowers = BellerophonPowers {
    small: &BASE36_SMALL_MANTISSA,
    large: &BASE36_LARGE_MANTISSA,
    small_int: &BASE36_SMALL_INT_POWERS,
    step: BASE36_STEP,
    bias: BASE36_BIAS,
    log2: BASE36_LOG2_MULT,
    log2_shift: BASE36_LOG2_SHIFT,
};

// LOW-LEVEL
// ---------

// BASE3

const BASE3_SMALL_MANTISSA: [u64; 20] = [
    9223372036854775808,  // 3^0
    13835058055282163712, // 3^1
    10376293541461622784, // 3^2
    15564440312192434176, // 3^3
    11673330234144325632, // 3^4
    17509995351216488448, // 3^5
    13132496513412366336, // 3^6
    9849372385059274752,  // 3^7
    14774058577588912128, // 3^8
    11080543933191684096, // 3^9
    16620815899787526144, // 3^10
    12465611924840644608, // 3^11
    9349208943630483456,  // 3^12
    14023813415445725184, // 3^13
    10517860061584293888, // 3^14
    15776790092376440832, // 3^15
    11832592569282330624, // 3^16
    17748888853923495936, // 3^17
    13311666640442621952, // 3^18
    9983749980331966464,  // 3^19
];
const BASE3_LARGE_MANTISSA: [u64; 69] = [
    16362187946641408838, // 3^-720
    13283319235448605538, // 3^-700
    10783800460320302292, // 3^-680
    17509230984627012859, // 3^-660
    14214523479040558273, // 3^-640
    11539780240125690827, // 3^-620
    9368342750761260524,  // 3^-600
    15211008194170796346, // 3^-580
    12348756681875770872, // 3^-560
    10025094302862174179, // 3^-540
    16277349755993950451, // 3^-520
    13214445025385558299, // 3^-500
    10727886292707736997, // 3^-480
    17418445358572088840, // 3^-460
    14140820960965941427, // 3^-440
    11479946305982273645, // 3^-420
    9319767752666157840,  // 3^-400
    15132138887857638912, // 3^-380
    12284728192712064755, // 3^-360
    9973114038089604413,  // 3^-340
    16192951452641260116, // 3^-320
    13145927929137795237, // 3^-300
    10672262040895386089, // 3^-280
    17328130457353990660, // 3^-260
    14067500591556283265, // 3^-240
    11420422611687500217, // 3^-220
    9271444616666914905,  // 3^-200
    15053678520084183432, // 3^-180
    12221031692227883264, // 3^-160
    9921403291771844100,  // 3^-140
    16108990755761097026, // 3^-120
    13077766095064811873, // 3^-100
    10616926201665464118, // 3^-80
    17238283840257358043, // 3^-60
    13994560389365007134, // 3^-40
    11361207548643088241, // 3^-20
    9223372036854775808,  // 3^0
    14975624970497949696, // 3^20
    12157665459056928801, // 3^40
    9869960666451650558,  // 3^60
    16025465396357318008, // 3^80
    13009957681126887596, // 3^100
    10561877279594392463, // 3^120
    17148903079221976570, // 3^140
    13921998383219366688, // 3^160
    11302299516591361707, // 3^180
    18351097428184282358, // 3^200
    14897976129740516999, // 3^220
    12094627780758213915, // 3^240
    9818784771917617934,  // 3^260
    15942373117198559022, // 3^280
    12942500854835305460, // 3^300
    10507113787012386253, // 3^320
    17059985758777160561, // 3^340
    13849812612167175924, // 3^360
    11243696923572004730, // 3^380
    18255946711954919292, // 3^400
    14820729899390519784, // 3^420
    12031916953769783440, // 3^440
    9767874225166607426,  // 3^460
    15859711672757234610, // 3^480
    12875393793202830082, // 3^500
    10452634243963250834, // 3^520
    16971529475976476179, // 3^540
    13778001125423815423, // 3^560
    11185398185879039609, // 3^580
    18161289353620602647, // 3^600
    14743884191906938838, // 3^620
    11969531283362676572, // 3^640
];
const BASE3_SMALL_INT_POWERS: [u64; 20] = [
    1, 3, 9, 27, 81, 243, 729, 2187, 6561, 19683, 59049, 177147, 531441, 1594323, 4782969,
    14348907, 43046721, 129140163, 387420489, 1162261467,
];
const BASE3_STEP: i32 = 20;
const BASE3_BIAS: i32 = 720;
const BASE3_LOG2_MULT: i64 = 6807362106;
const BASE3_LOG2_SHIFT: i32 = 32;

// BASE5

const BASE5_SMALL_MANTISSA: [u64; 14] = [
    9223372036854775808,  // 5^0
    11529215046068469760, // 5^1
    14411518807585587200, // 5^2
    18014398509481984000, // 5^3
    11258999068426240000, // 5^4
    14073748835532800000, // 5^5
    17592186044416000000, // 5^6
    10995116277760000000, // 5^7
    13743895347200000000, // 5^8
    17179869184000000000, // 5^9
    10737418240000000000, // 5^10
    13421772800000000000, // 5^11
    16777216000000000000, // 5^12
    10485760000000000000, // 5^13
];
const BASE5_LARGE_MANTISSA: [u64; 68] = [
    15492890949478498119, // 5^-504
    11008361120075348168, // 5^-490
    15643822052986917253, // 5^-476
    11115604119273511155, // 5^-462
    15796223521069679172, // 5^-448
    11223891875338892399, // 5^-434
    15950109677957715915, // 5^-420
    11333234566249726012, // 5^-406
    16105494987428025427, // 5^-392
    11443642469137689536, // 5^-378
    16262394054163123565, // 5^-364
    11555125961253852697, // 5^-350
    16420821625123739831, // 5^-336
    11667695520944036383, // 5^-322
    16580792590934885855, // 5^-308
    11781361728633673532, // 5^-294
    16742321987285426889, // 5^-280
    11896135267822264502, // 5^-266
    16905424996341287883, // 5^-252
    12012026926087520367, // 5^-238
    17070116948172426941, // 5^-224
    12129047596099288555, // 5^-210
    17236413322193710308, // 5^-196
    12247208276643356092, // 5^-182
    17404329748619824289, // 5^-168
    12366520073655226703, // 5^-154
    17573882009934360870, // 5^-140
    12486994201263968925, // 5^-126
    17745086042373215101, // 5^-112
    12608641982846233347, // 5^-98
    17917957937422433684, // 5^-84
    12731474852090538039, // 5^-70
    18092513943330655534, // 5^-56
    12855504354071922204, // 5^-42
    18268770466636286477, // 5^-28
    12980742146337069071, // 5^-14
    9223372036854775808,  // 5^0
    13107200000000000000, // 5^14
    9313225746154785156,  // 5^28
    13234889800848442797, // 5^42
    9403954806578300063,  // 5^56
    13363823550460978230, // 5^70
    9495567745759798747,  // 5^84
    13494013367335069727, // 5^98
    9588073174409622174,  // 5^112
    13625471488026082303, // 5^126
    9681479787123295682,  // 5^140
    13758210268297397763, // 5^154
    9775796363198734982,  // 5^168
    13892242184281734271, // 5^182
    9871031767461413346,  // 5^196
    14027579833653779454, // 5^210
    9967194951097567535,  // 5^224
    14164235936814247246, // 5^238
    10064294952495520794, // 5^252
    14302223338085469768, // 5^266
    10162340898095201970, // 5^280
    14441555006918636608, // 5^294
    10261342003245940623, // 5^308
    14582244039112794984, // 5^322
    10361307573072618726, // 5^336
    14724303658045725350, // 5^350
    10462247003350260393, // 5^364
    14867747215916808149, // 5^378
    10564169781387141817, // 5^392
    15012588195001998509, // 5^406
    10667085486916504429, // 5^420
    15158840208921026870, // 5^434
];
const BASE5_SMALL_INT_POWERS: [u64; 14] = [
    1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625,
    1220703125,
];
const BASE5_STEP: i32 = 14;
const BASE5_BIAS: i32 = 504;
const BASE5_LOG2_MULT: i64 = 152170;
const BASE5_LOG2_SHIFT: i32 = 16;

// BASE6

const BASE6_SMALL_MANTISSA: [u64; 12] = [
    9223372036854775808,  // 6^0
    13835058055282163712, // 6^1
    10376293541461622784, // 6^2
    15564440312192434176, // 6^3
    11673330234144325632, // 6^4
    17509995351216488448, // 6^5
    13132496513412366336, // 6^6
    9849372385059274752,  // 6^7
    14774058577588912128, // 6^8
    11080543933191684096, // 6^9
    16620815899787526144, // 6^10
    12465611924840644608, // 6^11
];
const BASE6_LARGE_MANTISSA: [u64; 71] = [
    11172994339528645078, // 6^-444
    11325430459582219446, // 6^-432
    11479946305982273645, // 6^-420
    11636570252986002899, // 6^-408
    11795331061968106016, // 6^-396
    11956257886702331980, // 6^-384
    12119380278715084095, // 6^-372
    12284728192712064755, // 6^-360
    12452331992078957377, // 6^-348
    12622222454457155586, // 6^-336
    12794430777395563548, // 6^-324
    12968988584079505325, // 6^-312
    13145927929137795237, // 6^-300
    13325281304529035642, // 6^-288
    13507081645508223020, // 6^-276
    13691362336674758052, // 6^-264
    13878157218102970303, // 6^-252
    14067500591556283265, // 6^-240
    14259427226786160917, // 6^-228
    14453972367916992462, // 6^-216
    14651171739918087751, // 6^-204
    14851061555163971849, // 6^-192
    15053678520084183432, // 6^-180
    15259059841903798156, // 6^-168
    15467243235475914756, // 6^-156
    15678266930207358578, // 6^-144
    15892169677078874302, // 6^-132
    16108990755761097026, // 6^-120
    16328769981827608423, // 6^-108
    16551547714066402526, // 6^-96
    16777364861891103792, // 6^-84
    17006262892853298360, // 6^-72
    17238283840257358043, // 6^-60
    17473470310879155380, // 6^-48
    17711865492790087155, // 6^-36
    17953513163287843146, // 6^-24
    18198457696935376453, // 6^-12
    9223372036854775808,  // 6^0
    9349208943630483456,  // 6^12
    9476762676643233792,  // 6^24
    9606056659007943744,  // 6^36
    9737114633407288801,  // 6^48
    9869960666451650558,  // 6^60
    10004619153098548172, // 6^72
    10141114821132365302, // 6^84
    10279472735705195138, // 6^96
    10419718303939637392, // 6^108
    10561877279594392463, // 6^120
    10705975767793509530, // 6^132
    10852040229820157048, // 6^144
    11000097487975795902, // 6^156
    11150174730505647564, // 6^168
    11302299516591361707, // 6^180
    11456499781411800112, // 6^192
    11612803841272866179, // 6^204
    11771240398807322073, // 6^216
    11931838548245548344, // 6^228
    12094627780758213915, // 6^240
    12259637989871837542, // 6^252
    12426899476958235198, // 6^264
    12596442956798861450, // 6^276
    12768299563225066619, // 6^288
    12942500854835305460, // 6^300
    13119078820790347231, // 6^312
    13298065886687551351, // 6^324
    13479494920515287357, // 6^336
    13663399238688592583, // 6^348
    13849812612167175924, // 6^360
    14038769272656891137, // 6^372
    14230303918895818486, // 6^384
    14424451723026109070, // 6^396
];
const BASE6_SMALL_INT_POWERS: [u64; 12] =
    [1, 6, 36, 216, 1296, 7776, 46656, 279936, 1679616, 10077696, 60466176, 362797056];
const BASE6_STEP: i32 = 12;
const BASE6_BIAS: i32 = 444;
const BASE6_LOG2_MULT: i64 = 11102329402;
const BASE6_LOG2_SHIFT: i32 = 32;

// BASE7

const BASE7_SMALL_MANTISSA: [u64; 11] = [
    9223372036854775808,  // 7^0
    16140901064495857664, // 7^1
    14123288431433875456, // 7^2
    12357877377504641024, // 7^3
    10813142705316560896, // 7^4
    9461499867151990784,  // 7^5
    16557624767515983872, // 7^6
    14487921671576485888, // 7^7
    12676931462629425152, // 7^8
    11092315029800747008, // 7^9
    9705775651075653632,  // 7^10
];
const BASE7_LARGE_MANTISSA: [u64; 71] = [
    12225664820028455743, // 7^-407
    11256958357801915874, // 7^-396
    10365007820408367996, // 7^-385
    9543731415037814164,  // 7^-374
    17575058485347314089, // 7^-363
    16182490230010039076, // 7^-352
    14900262793588950961, // 7^-341
    13719633267955538670, // 7^-330
    12632551493533408059, // 7^-319
    11631605169031861852, // 7^-308
    10709969310436274791, // 7^-297
    9861359714639799269,  // 7^-286
    18159980220813419398, // 7^-275
    16721065408999761282, // 7^-264
    15396163707909854531, // 7^-253
    14176241233598532153, // 7^-242
    13052979906282242272, // 7^-231
    12018720733250263776, // 7^-220
    11066411585781870352, // 7^-209
    10189559113984709052, // 7^-198
    9382184471684205580,  // 7^-187
    17277565098945522629, // 7^-176
    15908568875896010079, // 7^-165
    14648045730389016129, // 7^-154
    13487400745686688174, // 7^-143
    12418720027433908743, // 7^-132
    11434716742520575143, // 7^-121
    10528681433580712628, // 7^-110
    9694436270346269630,  // 7^-99
    17852585851834022264, // 7^-88
    16438027581449061548, // 7^-77
    15135552519453149331, // 7^-66
    13936279698645574929, // 7^-55
    12832031839555071753, // 7^-44
    11815279593402393441, // 7^-33
    10879090202998704701, // 7^-22
    10017080231522506848, // 7^-11
    9223372036854775808,  // 7^0
    16985107389382393856, // 7^11
    15639284194331952196, // 7^22
    14400097950748064600, // 7^33
    13259099228230139701, // 7^44
    12208508091080056405, // 7^55
    11241161050565762112, // 7^66
    10350462220447909415, // 7^77
    9530338342721952463,  // 7^88
    17550394753834620135, // 7^99
    16159780741186857313, // 7^110
    14879352702091044991, // 7^121
    13700379997665963732, // 7^132
    12614823765422770599, // 7^143
    11615282106028126090, // 7^154
    10694939613220642893, // 7^165
    9847520902748803399,  // 7^176
    18134495646931893353, // 7^187
    16697600117649658875, // 7^198
    15374557700263623520, // 7^209
    14156347188413069088, // 7^220
    13034662175384360011, // 7^231
    12001854416615353596, // 7^242
    11050881679899153397, // 7^253
    10175259727702178785, // 7^264
    9369018104186475301,  // 7^275
    17253318850937371954, // 7^286
    15886243791070066478, // 7^297
    14627489584451796037, // 7^308
    13468473375910191470, // 7^319
    12401292376951646786, // 7^330
    11418669980349265042, // 7^341
    10513906144367477972, // 7^352
    9680831708316613461,  // 7^363
];
const BASE7_SMALL_INT_POWERS: [u64; 11] =
    [1, 7, 49, 343, 2401, 16807, 117649, 823543, 5764801, 40353607, 282475249];
const BASE7_STEP: i32 = 11;
const BASE7_BIAS: i32 = 407;
const BASE7_LOG2_MULT: i64 = 183983;
const BASE7_LOG2_SHIFT: i32 = 16;

// BASE9

const BASE9_SMALL_MANTISSA: [u64; 10] = [
    9223372036854775808,  // 9^0
    10376293541461622784, // 9^1
    11673330234144325632, // 9^2
    13132496513412366336, // 9^3
    14774058577588912128, // 9^4
    16620815899787526144, // 9^5
    9349208943630483456,  // 9^6
    10517860061584293888, // 9^7
    11832592569282330624, // 9^8
    13311666640442621952, // 9^9
];
const BASE9_LARGE_MANTISSA: [u64; 69] = [
    16362187946641408838, // 9^-360
    13283319235448605538, // 9^-350
    10783800460320302292, // 9^-340
    17509230984627012859, // 9^-330
    14214523479040558273, // 9^-320
    11539780240125690827, // 9^-310
    9368342750761260524,  // 9^-300
    15211008194170796346, // 9^-290
    12348756681875770872, // 9^-280
    10025094302862174179, // 9^-270
    16277349755993950451, // 9^-260
    13214445025385558299, // 9^-250
    10727886292707736997, // 9^-240
    17418445358572088840, // 9^-230
    14140820960965941427, // 9^-220
    11479946305982273645, // 9^-210
    9319767752666157840,  // 9^-200
    15132138887857638912, // 9^-190
    12284728192712064755, // 9^-180
    9973114038089604413,  // 9^-170
    16192951452641260116, // 9^-160
    13145927929137795237, // 9^-150
    10672262040895386089, // 9^-140
    17328130457353990660, // 9^-130
    14067500591556283265, // 9^-120
    11420422611687500217, // 9^-110
    9271444616666914905,  // 9^-100
    15053678520084183432, // 9^-90
    12221031692227883264, // 9^-80
    9921403291771844100,  // 9^-70
    16108990755761097026, // 9^-60
    13077766095064811873, // 9^-50
    10616926201665464118, // 9^-40
    17238283840257358043, // 9^-30
    13994560389365007134, // 9^-20
    11361207548643088241, // 9^-10
    9223372036854775808,  // 9^0
    14975624970497949696, // 9^10
    12157665459056928801, // 9^20
    9869960666451650558,  // 9^30
    16025465396357318008, // 9^40
    13009957681126887596, // 9^50
    10561877279594392463, // 9^60
    17148903079221976570, // 9^70
    13921998383219366688, // 9^80
    11302299516591361707, // 9^90
    18351097428184282358, // 9^100
    14897976129740516999, // 9^110
    12094627780758213915, // 9^120
    9818784771917617934,  // 9^130
    15942373117198559022, // 9^140
    12942500854835305460, // 9^150
    10507113787012386253, // 9^160
    17059985758777160561, // 9^170
    13849812612167175924, // 9^180
    11243696923572004730, // 9^190
    18255946711954919292, // 9^200
    14820729899390519784, // 9^210
    12031916953769783440, // 9^220
    9767874225166607426,  // 9^230
    15859711672757234610, // 9^240
    12875393793202830082, // 9^250
    10452634243963250834, // 9^260
    16971529475976476179, // 9^270
    13778001125423815423, // 9^280
    11185398185879039609, // 9^290
    18161289353620602647, // 9^300
    14743884191906938838, // 9^310
    11969531283362676572, // 9^320
];
const BASE9_SMALL_INT_POWERS: [u64; 10] =
    [1, 9, 81, 729, 6561, 59049, 531441, 4782969, 43046721, 387420489];
const BASE9_STEP: i32 = 10;
const BASE9_BIAS: i32 = 360;
const BASE9_LOG2_MULT: i64 = 13614724212;
const BASE9_LOG2_SHIFT: i32 = 32;

// BASE11

const BASE11_SMALL_MANTISSA: [u64; 9] = [
    9223372036854775808,  // 11^0
    12682136550675316736, // 11^1
    17437937757178560512, // 11^2
    11988582208060260352, // 11^3
    16484300536082857984, // 11^4
    11332956618556964864, // 11^5
    15582815350515826688, // 11^6
    10713185553479630848, // 11^7
    14730630136034492416, // 11^8
];
const BASE11_LARGE_MANTISSA: [u64; 70] = [
    9282833781626869722,  // 11^-333
    10192597509046958613, // 11^-324
    11191522591630754840, // 11^-315
    12288347284174558846, // 11^-306
    13492666233761944748, // 11^-297
    14815014410453217040, // 11^-288
    16266959263598494876, // 11^-279
    17861201909926315464, // 11^-270
    9805844119283264859,  // 11^-261
    10766865452458105492, // 11^-252
    11822071640254585128, // 11^-243
    12980693265318349774, // 11^-234
    14252865553152120313, // 11^-225
    15649717031600177225, // 11^-216
    17183466879401827195, // 11^-207
    9433765907692842627,  // 11^-198
    10358321731667433590, // 11^-189
    11373488609595385666, // 11^-180
    12488146873940825498, // 11^-171
    13712047173770907127, // 11^-162
    15055895770097238115, // 11^-153
    16531448190583591098, // 11^-144
    18151612062879235750, // 11^-135
    9965280013064351107,  // 11^-126
    10941926854184612877, // 11^-117
    12014289927163860584, // 11^-108
    13191749897208336388, // 11^-99
    14484606781216284322, // 11^-90
    15904170048801172427, // 11^-81
    17462857553661839031, // 11^-72
    9587152080358667750,  // 11^-63
    10526740509619734750, // 11^-54
    11558413262671798860, // 11^-45
    12691195059726361470, // 11^-36
    13934995088312952370, // 11^-27
    15300693685460773821, // 11^-18
    16800237515163846269, // 11^-9
    9223372036854775808,  // 11^0
    10127308218523713536, // 11^9
    11119834626984462962, // 11^18
    12209633543621683835, // 11^27
    13406238156435497652, // 11^36
    14720115953107913248, // 11^45
    16162760287003157808, // 11^54
    17746790917089950882, // 11^63
    9743032200637278641,  // 11^72
    10697897654413860244, // 11^81
    11746344656115154606, // 11^90
    12897544661339799796, // 11^99
    14161567973799797658, // 11^108
    15549471836891389165, // 11^117
    17073397158676562691, // 11^126
    9373337358196117359,  // 11^135
    10291970884763903381, // 11^144
    11300635050781198339, // 11^153
    12408153305213523269, // 11^162
    13624213838764580644, // 11^171
    14959454332853289890, // 11^180
    16425555014410689631, // 11^189
    18035340830508227153, // 11^198
    9901446818303059920,  // 11^207
    10871837689903097542, // 11^216
    11937331677337075986, // 11^225
    13107249357401447067, // 11^234
    14391824769622635037, // 11^243
    15802294940132787091, // 11^252
    17350998179329134782, // 11^261
    9525741006595626773,  // 11^270
    10459310846201225147, // 11^279
    11484375157976259923, // 11^288
];
const BASE11_SMALL_INT_POWERS: [u64; 9] =
    [1, 11, 121, 1331, 14641, 161051, 1771561, 19487171, 214358881];
const BASE11_STEP: i32 = 9;
const BASE11_BIAS: i32 = 333;
const BASE11_LOG2_MULT: i64 = 226718;
const BASE11_LOG2_SHIFT: i32 = 16;

// BASE12

const BASE12_SMALL_MANTISSA: [u64; 9] = [
    9223372036854775808,  // 12^0
    13835058055282163712, // 12^1
    10376293541461622784, // 12^2
    15564440312192434176, // 12^3
    11673330234144325632, // 12^4
    17509995351216488448, // 12^5
    13132496513412366336, // 12^6
    9849372385059274752,  // 12^7
    14774058577588912128, // 12^8
];
const BASE12_LARGE_MANTISSA: [u64; 68] = [
    12794430777395563548, // 12^-324
    15370653136686821126, // 12^-315
    9232805349408163458,  // 12^-306
    11091876690210014731, // 12^-297
    13325281304529035642, // 12^-288
    16008393061343079134, // 12^-279
    9615881366772943927,  // 12^-270
    11552086971569327107, // 12^-261
    13878157218102970303, // 12^-252
    16672593293696335722, // 12^-243
    10014851495355986817, // 12^-234
    12031391722600823274, // 12^-225
    14453972367916992462, // 12^-216
    17364351691754770668, // 12^-207
    10430375193750279268, // 12^-198
    12530583187169601247, // 12^-189
    15053678520084183432, // 12^-180
    18084811664478575592, // 12^-171
    10863139281980340679, // 12^-162
    13050486479932803075, // 12^-153
    15678266930207358578, // 12^-144
    9417582030861555141,  // 12^-135
    11313859076748534537, // 12^-126
    13591960950173425616, // 12^-117
    16328769981827608423, // 12^-108
    9808324571298608904,  // 12^-99
    11783279573783601017, // 12^-90
    14155901602220618825, // 12^-81
    17006262892853298360, // 12^-72
    10215279312745101062, // 12^-63
    12272176679245716810, // 12^-54
    14743240574804287352, // 12^-45
    17711865492790087155, // 12^-36
    10639118911577981124, // 12^-27
    12781358492223474271, // 12^-18
    15354948681789223882, // 12^-9
    9223372036854775808,  // 12^0
    11080543933191684096, // 12^9
    13311666640442621952, // 12^18
    15992037016835457024, // 12^27
    9606056659007943744,  // 12^36
    11540284009964194135, // 12^45
    13863977671394362375, // 12^54
    16655558624637160317, // 12^63
    10004619153098548172, // 12^72
    12019099047267988506, // 12^81
    14439204501182606065, // 12^90
    17346610241502516795, // 12^99
    10419718303939637392, // 12^108
    12517780479519279956, // 12^117
    15038297923484984581, // 12^126
    18066334108151547333, // 12^135
    10852040229820157048, // 12^144
    13037152578341684032, // 12^153
    15662248181121787524, // 12^162
    9407959928864140132,  // 12^171
    11302299516591361707, // 12^180
    13578073815006577911, // 12^189
    16312086602830473207, // 12^198
    9798303241073980839,  // 12^207
    11771240398807322073, // 12^216
    14141438279402131370, // 12^225
    16988887307951181138, // 12^234
    10204842190014742991, // 12^243
    12259637989871837542, // 12^252
    14728177157876426901, // 12^261
    17693768981840924725, // 12^270
    10628248744799039348, // 12^279
];
const BASE12_SMALL_INT_POWERS: [u64; 9] =
    [1, 12, 144, 1728, 20736, 248832, 2985984, 35831808, 429981696];
const BASE12_STEP: i32 = 9;
const BASE12_BIAS: i32 = 324;
const BASE12_LOG2_MULT: i64 = 15397296698;
const BASE12_LOG2_SHIFT: i32 = 32;

// BASE13

const BASE13_SMALL_MANTISSA: [u64; 8] = [
    9223372036854775808,  // 13^0
    14987979559889010688, // 13^1
    12177733392409821184, // 13^2
    9894408381332979712,  // 13^3
    16078413619666092032, // 13^4
    13063711065978699776, // 13^5
    10614265241107693568, // 13^6
    17248181016800002048, // 13^7
];
const BASE13_LARGE_MANTISSA: [u64; 74] = [
    12711851154623003921, // 13^-312
    9657300550123029827,  // 13^-304
    14673465379822171777, // 13^-296
    11147555423761605318, // 13^-288
    16937783776246970219, // 13^-280
    12867777209673117558, // 13^-272
    9775758889423702247,  // 13^-264
    14853452979012869128, // 13^-256
    11284293521111612769, // 13^-248
    17145545948207386966, // 13^-240
    13025615884242430727, // 13^-232
    9895670261906581517,  // 13^-224
    15035648341334079534, // 13^-216
    11422708874734959378, // 13^-208
    17355856571645749915, // 13^-200
    13185390638896427802, // 13^-192
    10017052490761162429, // 13^-184
    15220078547640608376, // 13^-176
    11562822058185475244, // 13^-168
    17568746906366835671, // 13^-160
    13347125221972482607, // 13^-152
    10139923617799671626, // 13^-144
    15406771010966328102, // 13^-136
    11704653897376229735, // 13^-128
    17784248595614306423, // 13^-120
    13510843673109724761, // 13^-112
    10264301906138736839, // 13^-104
    15595753480598751694, // 13^-96
    11848225473675019323, // 13^-88
    18002393670774046392, // 13^-80
    13676570326822204041, // 13^-72
    10390205842913949994, // 13^-64
    15787054046203585657, // 13^-56
    11993558127037825287, // 13^-48
    18223214556135190308, // 13^-40
    13844329816115883890, // 13^-32
    10517654142027727687, // 13^-24
    15980701141999875583, // 13^-16
    12140673459180707010, // 13^-8
    9223372036854775808,  // 13^0
    14014147076150001664, // 13^8
    10646665746930877456, // 13^16
    16176723550986364864, // 13^24
    12289593336790602348, // 13^32
    9336507724055083356,  // 13^40
    14186047347943339851, // 13^48
    10777259833438283283, // 13^56
    16375150409219694755, // 13^64
    12440339894775512302, // 13^72
    9451031155744840189,  // 13^80
    14360056182125959135, // 13^88
    10909455812579128852, // 13^96
    16576011210145081669, // 13^104
    12592935539554553092, // 13^112
    9566959354269653198,  // 13^120
    14536199442736950948, // 13^128
    11043273333482082198, // 13^136
    16779335808980115413, // 13^144
    12747402952388364654, // 13^152
    9684309550774553205,  // 13^160
    14714503311068774005, // 13^168
    11178732286295870598, // 13^176
    16985154427152329948, // 13^184
    12903765092750370582, // 13^192
    9803099187765169579,  // 13^200
    14894994289558746218, // 13^208
    11315852805145679810, // 13^216
    17193497656791206265, // 13^224
    13062045201739390598, // 13^232
    9923345921700320715,  // 13^240
    15077699205728270417, // 13^248
    11454655271125817073, // 13^256
    17404396465275275042, // 13^264
    13222266805534112801, // 13^272
];
const BASE13_SMALL_INT_POWERS: [u64; 8] = [1, 13, 169, 2197, 28561, 371293, 4826809, 62748517];
const BASE13_STEP: i32 = 8;
const BASE13_BIAS: i32 = 312;
const BASE13_LOG2_MULT: i64 = 15893267571;
const BASE13_LOG2_SHIFT: i32 = 32;

// BASE14

const BASE14_SMALL_MANTISSA: [u64; 8] = [
    9223372036854775808,  // 14^0
    16140901064495857664, // 14^1
    14123288431433875456, // 14^2
    12357877377504641024, // 14^3
    10813142705316560896, // 14^4
    9461499867151990784,  // 14^5
    16557624767515983872, // 14^6
    14487921671576485888, // 14^7
];
const BASE14_LARGE_MANTISSA: [u64; 72] = [
    13636466802170654447, // 14^-304
    9371223146631740442,  // 14^-296
    12880143300754023535, // 14^-288
    17702928299982570560, // 14^-280
    12165767999490239948, // 14^-272
    16721065408999761282, // 14^-264
    11491014312609104256, // 14^-256
    15793659877858943182, // 14^-248
    10853684694473876180, // 14^-240
    14917691321465419740, // 14^-232
    10251703482589146278, // 14^-224
    14090306875260685218, // 14^-216
    9683110137559136558,  // 14^-208
    13308811903980028150, // 14^-200
    18292105715960495534, // 14^-192
    12570661225733134820, // 14^-184
    17277565098945522629, // 14^-176
    11873450822826176619, // 14^-168
    16319294256419936609, // 14^-160
    11214910012329090474, // 14^-152
    15414172280784786485, // 14^-144
    10592894050889065017, // 14^-136
    14559251360287507272, // 14^-128
    10005377149705503250, // 14^-120
    13751747178554400168, // 14^-112
    9450445876917551117,  // 14^-104
    12989029846596759700, // 14^-96
    17852585851834022264, // 14^-88
    12268615337757900164, // 14^-80
    16862422458582420498, // 14^-72
    11588157397706317457, // 14^-64
    15927176798452085633, // 14^-56
    10945439903127358164, // 14^-48
    15043802952525257461, // 14^-40
    10338369644227094261, // 14^-32
    14209423938610553080, // 14^-24
    9764969507542378307,  // 14^-16
    13421322341453983785, // 14^-8
    9223372036854775808,  // 14^0
    12676931462629425152, // 14^8
    17423626702474969088, // 14^16
    11973826961285400900, // 14^24
    16457254800854930971, // 14^32
    11309718958523667683, // 14^40
    15544481077627229210, // 14^48
    10682444579695049354, // 14^56
    14682332800738954595, // 14^64
    10089960910324183248, // 14^72
    13868002115678253630, // 14^80
    9530338342721952463,  // 14^88
    13098836900821174211, // 14^96
    18003508583233548621, // 14^104
    12372332129971187630, // 14^112
    17004974516675479989, // 14^120
    11686121713960805382, // 14^128
    16061822448435536582, // 14^136
    11037970794744924274, // 14^144
    15170980709914287138, // 14^152
    10425768466889213611, // 14^160
    14329547997401095751, // 14^168
    9847520902748803399,  // 14^176
    13534783923074532648, // 14^184
    9301344858947275744,  // 14^192
    12784100090075520076, // 14^200
    17570923086015569737, // 14^208
    12075051662586407952, // 14^216
    16596381640322157656, // 14^224
    11405329403461315009, // 14^232
    15675891482926176126, // 14^240
    10772752153475797540, // 14^248
    14806454750802381310, // 14^256
    10175259727702178785, // 14^264
];
const BASE14_SMALL_INT_POWERS: [u64; 8] = [1, 14, 196, 2744, 38416, 537824, 7529536, 105413504];
const BASE14_STEP: i32 = 8;
const BASE14_BIAS: i32 = 304;
const BASE14_LOG2_MULT: i64 = 249519;
const BASE14_LOG2_SHIFT: i32 = 16;

// BASE15

const BASE15_SMALL_MANTISSA: [u64; 8] = [
    9223372036854775808,  // 15^0
    17293822569102704640, // 15^1
    16212958658533785600, // 15^2
    15199648742375424000, // 15^3
    14249670695976960000, // 15^4
    13359066277478400000, // 15^5
    12524124635136000000, // 15^6
    11741366845440000000, // 15^7
];
const BASE15_LARGE_MANTISSA: [u64; 70] = [
    13601350414362439244, // 15^-296
    16232381325359158633, // 15^-288
    9686178043528474499,  // 15^-280
    11559862131178364723, // 15^-272
    13795989697002596758, // 15^-264
    16464671426007778306, // 15^-256
    9824790070164184132,  // 15^-248
    11725287122380398084, // 15^-240
    13993414324420480958, // 15^-232
    16700285665596816319, // 15^-224
    9965385675239368708,  // 15^-216
    11893079393347852255, // 15^-208
    14193664155710441018, // 15^-200
    16939271613521887687, // 15^-192
    10107993244338750184, // 15^-184
    12063272820543086702, // 15^-176
    14396779620362065880, // 15^-168
    17181677519910502131, // 15^-160
    10252641569253028545, // 15^-152
    12235901765210495847, // 15^-144
    14602801726422706134, // 15^-136
    17427552325363535592, // 15^-128
    10399359853791807565, // 15^-120
    12411001080313881072, // 15^-112
    14811772068776803956, // 15^-104
    17676945670836105047, // 15^-96
    10548177719679705225, // 15^-88
    12588606117573098524, // 15^-80
    15023732837543702665, // 15^-72
    17929907907659841510, // 15^-64
    10699125212536839185, // 15^-56
    12768752734601403407, // 15^-48
    15238726826595631383, // 15^-40
    18186490107708584674, // 15^-32
    10852232807944894743, // 15^-24
    12951477302144931748, // 15^-16
    15456797442197584532, // 15^-8
    9223372036854775808,  // 15^0
    11007531417600000000, // 15^8
    13136816711425781250, // 15^16
    15677988711770840524, // 15^24
    9355361174851030653,  // 15^32
    11165052395553650442, // 15^40
    13324808381590173768, // 15^48
    15902345292781888946, // 15^56
    9489239115822963265,  // 15^64
    11324827544542942993, // 15^72
    13515490267263203164, // 15^80
    16129912481758560891, // 15^88
    9625032889090827484,  // 15^96
    11486889122411397534, // 15^104
    13708900866211693796, // 15^112
    16360736223435182728, // 15^120
    9762769910772315950,  // 15^128
    11651269848621662268, // 15^136
    13905079227116716745, // 15^144
    16594863120028599690, // 15^152
    9902477989317744010,  // 15^160
    11818002910861417777, // 15^168
    14104064957457333009, // 15^176
    16832340440646942057, // 15^184
    10044185331124443731, // 15^192
    11987121971743813505, // 15^200
    14305898231507155361, // 15^208
    17073216130833033517, // 15^216
    10187920546231501512, // 15^224
    12158661175603789420, // 15^232
    14510619798445343328, // 15^240
    17317538822244368489, // 15^248
    10333712654095989060, // 15^256
];
const BASE15_SMALL_INT_POWERS: [u64; 8] = [1, 15, 225, 3375, 50625, 759375, 11390625, 170859375];
const BASE15_STEP: i32 = 8;
const BASE15_BIAS: i32 = 296;
const BASE15_LOG2_MULT: i64 = 256042;
const BASE15_LOG2_SHIFT: i32 = 16;

// BASE17

const BASE17_SMALL_MANTISSA: [u64; 8] = [
    9223372036854775808,  // 17^0
    9799832789158199296,  // 17^1
    10412322338480586752, // 17^2
    11063092484635623424, // 17^3
    11754535764925349888, // 17^4
    12489194250233184256, // 17^5
    13269768890872758272, // 17^6
    14099129446552305664, // 17^7
];
const BASE17_LARGE_MANTISSA: [u64; 67] = [
    13138227451101932889, // 17^-280
    10669358063439695630, // 17^-272
    17328852299072967575, // 17^-264
    14072501842077846052, // 17^-256
    11428068326595325663, // 17^-248
    9280563409615280245,  // 17^-240
    15073213554289220394, // 17^-232
    12240731344920942400, // 17^-224
    9940514895438007254,  // 17^-216
    16145087021687770276, // 17^-208
    13111183760586542995, // 17^-200
    10647396286743453217, // 17^-192
    17293182638130712658, // 17^-184
    14043535043777936273, // 17^-176
    11404544822822581011, // 17^-168
    9261460323937079649,  // 17^-160
    15042186893809203473, // 17^-152
    12215535057871861844, // 17^-144
    9920053367473418578,  // 17^-136
    16111854019870470980, // 17^-128
    13084195736727816960, // 17^-120
    10625479716106730764, // 17^-112
    17257586399518441101, // 17^-104
    14014627870654357169, // 17^-96
    11381069739763987898, // 17^-88
    9242396559996829853,  // 17^-80
    15011224098520048145, // 17^-72
    12190390634789334486, // 17^-64
    9899633957460570790,  // 17^-56
    16078689424770850259, // 17^-48
    13057263264941664926, // 17^-40
    10603608258477502216, // 17^-32
    17222063432103834911, // 17^-24
    13985780199974813110, // 17^-16
    11357642977750484199, // 17^-8
    9223372036854775808,  // 17^0
    14980325036961824768, // 17^8
    12165297968916717120, // 17^16
    9879256578703990224,  // 17^24
    16045593095580712414, // 17^32
    13030386230879856604, // 17^40
    10581781820995279550, // 17^48
    17186613585065666435, // 17^56
    13956991909259640275, // 17^64
    11334264437318166304, // 17^72
    18408773347475537258, // 17^80
    14949489577945200446, // 17^88
    12140256953717114113, // 17^96
    9858921144686656932,  // 17^104
    16012564891781700940, // 17^112
    13003564520429535778, // 17^120
    10560000310990718510, // 17^128
    17151236707893158013, // 17^136
    13928262876281286641, // 17^144
    11310934019207866827, // 17^152
    18370880780077845311, // 17^160
    14918717590550882042, // 17^168
    12115267482872925081, // 17^176
    9838627569069637357,  // 17^184
    15979604673144701925, // 17^192
    12976798019712735820, // 17^200
    10538263635985225157, // 17^208
    17115932650385342947, // 17^216
    13899592979063793037, // 17^224
    11287651624364733171, // 17^232
    18333066210634546428, // 17^240
    14888008944129060322, // 17^248
];
const BASE17_SMALL_INT_POWERS: [u64; 8] = [1, 17, 289, 4913, 83521, 1419857, 24137569, 410338673];
const BASE17_STEP: i32 = 8;
const BASE17_BIAS: i32 = 280;
const BASE17_LOG2_MULT: i64 = 267876;
const BASE17_LOG2_SHIFT: i32 = 16;

// BASE18

const BASE18_SMALL_MANTISSA: [u64; 7] = [
    9223372036854775808,  // 18^0
    10376293541461622784, // 18^1
    11673330234144325632, // 18^2
    13132496513412366336, // 18^3
    14774058577588912128, // 18^4
    16620815899787526144, // 18^5
    9349208943630483456,  // 18^6
];
const BASE18_LARGE_MANTISSA: [u64; 75] = [
    14081888293732326968, // 18^-273
    16058262627216485544, // 18^-266
    18312018475493194258, // 18^-259
    10441042983020688038, // 18^-252
    11906429509033078491, // 18^-245
    13577481089208229636, // 18^-238
    15483062540952967857, // 18^-231
    17656089820489710741, // 18^-224
    10067049297406417285, // 18^-217
    11479946305982273645, // 18^-210
    13091141534609253262, // 18^-203
    14928465875303384176, // 18^-196
    17023656248839843776, // 18^-189
    9706451905352742522,  // 18^-182
    11068739548514628780, // 18^-175
    12622222454457155586, // 18^-168
    14393734624570008992, // 18^-161
    16413876176725623927, // 18^-154
    9358770957364699929,  // 18^-147
    10672262040895386089, // 18^-140
    12170099854822007158, // 18^-133
    13878157218102970303, // 18^-126
    15825938165500818674, // 18^-119
    18047087583901234911, // 18^-112
    10289986187706530766, // 18^-105
    11734172092969064177, // 18^-98
    13381047573408163051, // 18^-91
    15259059841903798156, // 18^-84
    17400648639910404101, // 18^-77
    9921403291771844100,  // 18^-70
    11313859076748534537, // 18^-63
    12901744183172431346, // 18^-56
    14712486856947913357, // 18^-49
    16777364861891103792, // 18^-42
    9566022877229980327,  // 18^-35
    10908601492662859386, // 18^-28
    12439609234991117453, // 18^-21
    14185491882103974832, // 18^-14
    16176406841720334625, // 18^-7
    9223372036854775808,  // 18^0
    10517860061584293888, // 18^7
    11994027762626592768, // 18^14
    13677373641439044901, // 18^21
    15596974880318657672, // 18^28
    17785989605508530085, // 18^35
    10141114821132365302, // 18^42
    11564406827668344530, // 18^49
    13187455978423603575, // 18^56
    15038297923484984581, // 18^63
    17148903079221976570, // 18^70
    9777864433756263024,  // 18^77
    11150174730505647564, // 18^84
    12715086956165281921, // 18^91
    14499632535849309517, // 18^98
    16534636719312342666, // 18^105
    9427625519601420913,  // 18^112
    10750780249562856814, // 18^119
    12259637989871837542, // 18^126
    13980261911578014597, // 18^133
    15942373117198559022, // 18^140
    18179864026545065558, // 18^147
    10365691907784965713, // 18^154
    11820503010388934534, // 18^161
    13479494920515287357, // 18^168
    15371324143524666656, // 18^175
    17528669087274082029, // 18^182
    9994397265397337538,  // 18^189
    11397097657699641734, // 18^196
    12996665188491343910, // 18^203
    14820729899390519784, // 18^210
    16900799671687597041, // 18^217
    9636402237998480121,  // 18^224
    10988858503312433354, // 18^231
    12531130210573617469, // 18^238
    14289857705148955482, // 18^245
];
const BASE18_SMALL_INT_POWERS: [u64; 7] = [1, 18, 324, 5832, 104976, 1889568, 34012224];
const BASE18_STEP: i32 = 7;
const BASE18_BIAS: i32 = 273;
const BASE18_LOG2_MULT: i64 = 17909691508;
const BASE18_LOG2_SHIFT: i32 = 32;

// BASE19

const BASE19_SMALL_MANTISSA: [u64; 7] = [
    9223372036854775808,  // 19^0
    10952754293765046272, // 19^1
    13006395723845992448, // 19^2
    15445094922067116032, // 19^3
    18341050219954700288, // 19^4
    10889998568098103296, // 19^5
    12931873299616497664, // 19^6
];
const BASE19_LARGE_MANTISSA: [u64; 74] = [
    11480257701232751935, // 19^-273
    9557118560717499270,  // 19^-266
    15912276110980153383, // 19^-259
    13246698229359450470, // 19^-252
    11027650146079950824, // 19^-245
    18360660994723606251, // 19^-238
    15284936849533635885, // 19^-231
    12724449003299523561, // 19^-224
    10592886580523254223, // 19^-217
    17636794501472422448, // 19^-210
    14682330350779734844, // 19^-203
    12222789379976654044, // 19^-196
    10175263507767080823, // 19^-189
    16941466343535111364, // 19^-182
    14103481529006456400, // 19^-175
    11740907617180962231, // 19^-168
    9774105166278679843,  // 19^-161
    16273551401031031665, // 19^-154
    13547453741119703900, // 19^-147
    11278023975525727060, // 19^-140
    9388762436329270793,  // 19^-133
    15631968911773566269, // 19^-126
    13013347271048440836, // 19^-119
    10833389456740556437, // 19^-112
    18037223579289291900, // 19^-105
    15015680722474235794, // 19^-98
    12500297873901968386, // 19^-91
    10406284591707172986, // 19^-84
    17326108560931302042, // 19^-77
    14423689608892845377, // 19^-70
    12007475377523598784, // 19^-63
    9996018276276719532,  // 19^-56
    16643029152771930644, // 19^-49
    13855037662215477149, // 19^-42
    11534082339177879647, // 19^-35
    9601926652984804576,  // 19^-28
    15986880054797934009, // 19^-21
    13308804739049304804, // 19^-14
    11079352755197736707, // 19^-7
    9223372036854775808,  // 19^0
    15356599543294590976, // 19^7
    12784106972526145936, // 19^14
    10642550821503597582, // 19^21
    17719483767102098773, // 19^28
    14751167752856224795, // 19^35
    12280095342105548712, // 19^42
    10222969742988875833, // 19^49
    17020895596425699999, // 19^56
    14169605026128220038, // 19^63
    11795954299763191941, // 19^70
    9819930589845265884,  // 19^77
    16349849166729084322, // 19^84
    13610970328610229813, // 19^91
    11330900450341615431, // 19^98
    9432781198977253334,  // 19^105
    15705258648723927251, // 19^112
    13074359725955544955, // 19^119
    10884181283927938347, // 19^126
    18121790237456409263, // 19^133
    15086081021789818522, // 19^140
    12558904921302722743, // 19^147
    10455073958207408827, // 19^154
    17407341190420966318, // 19^161
    14491314386248513408, // 19^168
    12063771850272711708, // 19^175
    10042884128822494706, // 19^182
    16721059197198717605, // 19^189
    13919996342176535757, // 19^196
    11588159331358018389, // 19^203
    9646944825844903597,  // 19^210
    16061833775630288054, // 19^217
    13371202432132867541, // 19^224
    11131297769520092558, // 19^231
    9266615374542536521,  // 19^238
];
const BASE19_SMALL_INT_POWERS: [u64; 7] = [1, 19, 361, 6859, 130321, 2476099, 47045881];
const BASE19_STEP: i32 = 7;
const BASE19_BIAS: i32 = 273;
const BASE19_LOG2_MULT: i64 = 18244709747;
const BASE19_LOG2_SHIFT: i32 = 32;

// BASE20

const BASE20_SMALL_MANTISSA: [u64; 7] = [
    9223372036854775808,  // 20^0
    11529215046068469760, // 20^1
    14411518807585587200, // 20^2
    18014398509481984000, // 20^3
    11258999068426240000, // 20^4
    14073748835532800000, // 20^5
    17592186044416000000, // 20^6
];
const BASE20_LARGE_MANTISSA: [u64; 72] = [
    11896135267822264502, // 20^-266
    14181298336770849826, // 20^-259
    16905424996341287883, // 20^-252
    10076418516839318205, // 20^-245
    12012026926087520367, // 20^-238
    14319451959237480602, // 20^-231
    17070116948172426941, // 20^-224
    10174582569701926077, // 20^-217
    12129047596099288555, // 20^-210
    14458951468586073584, // 20^-203
    17236413322193710308, // 20^-196
    10273702932711667006, // 20^-189
    12247208276643356092, // 20^-182
    14599809976391024699, // 20^-175
    17404329748619824289, // 20^-168
    10373788922202482396, // 20^-161
    12366520073655226703, // 20^-154
    14742040721959145907, // 20^-147
    17573882009934360870, // 20^-140
    10474849945267653984, // 20^-133
    12486994201263968925, // 20^-126
    14885657073574029118, // 20^-119
    17745086042373215101, // 20^-112
    10576895500643977583, // 20^-105
    12608641982846233347, // 20^-98
    15030672529752532658, // 20^-91
    17917957937422433684, // 20^-84
    10679935179604550411, // 20^-77
    12731474852090538039, // 20^-70
    15177100720513508366, // 20^-63
    18092513943330655534, // 20^-56
    10783978666860255917, // 20^-49
    12855504354071922204, // 20^-42
    15324955408658888583, // 20^-35
    18268770466636286477, // 20^-28
    10889035741470030830, // 20^-21
    12980742146337069071, // 20^-14
    15474250491067253436, // 20^-7
    9223372036854775808,  // 20^0
    10995116277760000000, // 20^7
    13107200000000000000, // 20^14
    15625000000000000000, // 20^21
    9313225746154785156,  // 20^28
    11102230246251565404, // 20^35
    13234889800848442797, // 20^42
    15777218104420236108, // 20^49
    9403954806578300063,  // 20^56
    11210387714598536567, // 20^63
    13363823550460978230, // 20^70
    15930919111324522770, // 20^77
    9495567745759798747,  // 20^84
    11319598848533390459, // 20^91
    13494013367335069727, // 20^98
    16086117467087590369, // 20^105
    9588073174409622174,  // 20^112
    11429873912822749822, // 20^119
    13625471488026082303, // 20^126
    16242827758820155028, // 20^133
    9681479787123295682,  // 20^140
    11541223272232169725, // 20^147
    13758210268297397763, // 20^154
    16401064715739962772, // 20^161
    9775796363198734982,  // 20^168
    11653657392500323036, // 20^175
    13892242184281734271, // 20^182
    16560843210556190337, // 20^189
    9871031767461413346,  // 20^196
    11767186841322676356, // 20^203
    14027579833653779454, // 20^210
    16722178260867332761, // 20^217
    9967194951097567535,  // 20^224
    11881822289344748896, // 20^231
];
const BASE20_SMALL_INT_POWERS: [u64; 7] = [1, 20, 400, 8000, 160000, 3200000, 64000000];
const BASE20_STEP: i32 = 7;
const BASE20_BIAS: i32 = 266;
const BASE20_LOG2_MULT: i64 = 283242;
const BASE20_LOG2_SHIFT: i32 = 16;

// BASE21

const BASE21_SMALL_MANTISSA: [u64; 7] = [
    9223372036854775808,  // 21^0
    12105675798371893248, // 21^1
    15888699485363109888, // 21^2
    10426959037269540864, // 21^3
    13685383736416272384, // 21^4
    17962066154046357504, // 21^5
    11787605913592922112, // 21^6
];
const BASE21_LARGE_MANTISSA: [u64; 72] = [
    14408615719666154271, // 21^-266
    12084465783258517647, // 21^-259
    10135207719324857823, // 21^-252
    17000740844691866712, // 21^-245
    14258473889848767691, // 21^-238
    11958542249702993646, // 21^-231
    10029596003240171126, // 21^-224
    16823588341749525709, // 21^-217
    14109896580142091329, // 21^-210
    11833930874797054029, // 21^-203
    9925084790952075138,  // 21^-196
    16648281817731599335, // 21^-189
    13962867487806377083, // 21^-182
    11710617985478380225, // 21^-175
    9821662614901370847,  // 21^-168
    16474802037018309233, // 21^-161
    13817370479981011975, // 21^-154
    11588590051161810088, // 21^-147
    9719318127024052612,  // 21^-140
    16303129964430447286, // 21^-133
    13673389591914329770, // 21^-126
    11467833682254685835, // 21^-119
    9618040097506134632,  // 21^-112
    16133246763140728476, // 21^-105
    13530909025211868449, // 21^-98
    11348335628687672485, // 21^-91
    9517817413551452467,  // 21^-84
    15965133792606908039, // 21^-77
    13389913146102881332, // 21^-70
    11230082778460885572, // 21^-63
    9418639078162304415,  // 21^-56
    15798772606526436117, // 21^-49
    13250386483724911652, // 21^-42
    11113062156205168633, // 21^-35
    9320494208932798947,  // 21^-28
    15634144950812425486, // 21^-21
    13112313728426242332, // 21^-14
    10997260921758362571, // 21^-7
    9223372036854775808,  // 21^0
    15471232761590710272, // 21^7
    12975679730086034724, // 21^14
    10882666368756410705, // 21^21
    18254523810272339491, // 21^28
    15310018163217775871, // 21^35
    12840469496451971963, // 21^42
    10769265923239144897, // 21^49
    18064306536063374465, // 21^56
    15150483466319342608, // 21^63
    12706668191495224563, // 21^70
    10657047142270599779, // 21^77
    17876071379371335714, // 21^84
    14992611165849387896, // 21^91
    12574261133782557711, // 21^98
    10545997712573703694, // 21^105
    17689797685974006860, // 21^112
    14836383939169393936, // 21^119
    12443233794865401683, // 21^126
    10436105449179196548, // 21^133
    17505465016871978304, // 21^140
    14681784644147610193, // 21^147
    12313571797685708585, // 21^154
    10327358294088626305, // 21^161
    17323053146045965028, // 21^168
    14528796317278122096, // 21^175
    12185260914998420522, // 21^182
    10219744314951277448, // 21^189
    17142542058237493769, // 21^196
    14377402171819519570, // 21^203
    12058287067810376090, // 21^210
    10113251703754886210, // 21^217
    16963911946752716066, // 21^224
    14227585595952961160, // 21^231
];
const BASE21_SMALL_INT_POWERS: [u64; 7] = [1, 21, 441, 9261, 194481, 4084101, 85766121];
const BASE21_STEP: i32 = 7;
const BASE21_BIAS: i32 = 266;
const BASE21_LOG2_MULT: i64 = 287855;
const BASE21_LOG2_SHIFT: i32 = 16;

// BASE22

const BASE22_SMALL_MANTISSA: [u64; 7] = [
    9223372036854775808,  // 22^0
    12682136550675316736, // 22^1
    17437937757178560512, // 22^2
    11988582208060260352, // 22^3
    16484300536082857984, // 22^4
    11332956618556964864, // 22^5
    15582815350515826688, // 22^6
];
const BASE22_LARGE_MANTISSA: [u64; 70] = [
    9269587019009961312,  // 22^-259
    10766865452458105492, // 22^-252
    12505993140104023937, // 22^-245
    14526035001637582317, // 22^-238
    16872365953260472216, // 22^-231
    9798845067792082715,  // 22^-224
    11381612386618310709, // 22^-217
    13220037629231758864, // 22^-210
    15355416173176400877, // 22^-203
    17835713669231780592, // 22^-196
    10358321731667433590, // 22^-189
    12031459025026523680, // 22^-182
    13974851334106036811, // 22^-175
    16232151844936756579, // 22^-168
    9427032431967498649,  // 22^-161
    10949742378252536811, // 22^-154
    12718409426865212084, // 22^-147
    14772762021382712235, // 22^-140
    17158945778190527545, // 22^-133
    9965280013064351107,  // 22^-126
    11574930887071326019, // 22^-119
    13444582075449265201, // 22^-112
    15616230364311619568, // 22^-105
    18138656108661462534, // 22^-98
    10534259477248206780, // 22^-91
    12235815274209166465, // 22^-84
    14212216411407346527, // 22^-77
    16507857531195957209, // 22^-70
    9587152080358667750,  // 22^-63
    11135725497779554116, // 22^-56
    12934433638113158426, // 22^-49
    15023679738882972932, // 22^-42
    17450393207123747022, // 22^-35
    10134541882409419905, // 22^-28
    11771532933066741091, // 22^-21
    13672940444874950532, // 22^-14
    15881474526053323426, // 22^-7
    9223372036854775808,  // 22^0
    10713185553479630848, // 22^7
    12443642546855641088, // 22^14
    14453613172379218947, // 22^21
    16788246122479815273, // 22^28
    9749991386498543747,  // 22^35
    11324867570234788254, // 22^42
    13154127055020322136, // 22^49
    15278859333807672616, // 22^56
    17746790917089950882, // 22^63
    10306678691583236909, // 22^70
    11971474296148943805, // 22^77
    13905177517602390611, // 22^84
    16151223902158337584, // 22^91
    9380032480974399852,  // 22^98
    10895150717634104284, // 22^105
    12654999798852712250, // 22^112
    14699110095811391320, // 22^119
    17073397158676562691, // 22^126
    9915596544207462992,  // 22^133
    11517222250937216925, // 22^140
    13377551999629643946, // 22^147
    15538373194824147716, // 22^154
    18048222989401488392, // 22^161
    10481739271897017716, // 22^168
    12174811695150892652, // 22^175
    14141359174025375600, // 22^182
    16425555014410689631, // 22^189
    9539353827706830891,  // 22^196
    11080206589104387250, // 22^203
    12869946987462278079, // 22^210
    14948776823616759120, // 22^217
    17363391530672110525, // 22^224
];
const BASE22_SMALL_INT_POWERS: [u64; 7] = [1, 22, 484, 10648, 234256, 5153632, 113379904];
const BASE22_STEP: i32 = 7;
const BASE22_BIAS: i32 = 259;
const BASE22_LOG2_MULT: i64 = 292254;
const BASE22_LOG2_SHIFT: i32 = 16;

// BASE23

const BASE23_SMALL_MANTISSA: [u64; 7] = [
    9223372036854775808,  // 23^0
    13258597302978740224, // 23^1
    9529616811515969536,  // 23^2
    13698824166554206208, // 23^3
    9846029869710835712,  // 23^4
    14153667937709326336, // 23^5
    10172948830228578304, // 23^6
];
const BASE23_LARGE_MANTISSA: [u64; 69] = [
    9630971713765025029,  // 23^-252
    15269861356524917016, // 23^-245
    12105147475110827234, // 23^-238
    9596327823341159083,  // 23^-231
    15214933627595239789, // 23^-224
    12061603644316153100, // 23^-217
    9561808551614073801,  // 23^-210
    15160203481036150549, // 23^-203
    12018216446491393101, // 23^-196
    9527413450313687580,  // 23^-189
    15105670206117496642, // 23^-182
    11974985318206853149, // 23^-175
    9493142072782406120,  // 23^-168
    15051333094665716613, // 23^-161
    11931909698059570948, // 23^-154
    9458993973969322090,  // 23^-147
    14997191441054643808, // 23^-140
    11888989026666025574, // 23^-133
    9424968710424435661,  // 23^-126
    14943244542196343052, // 23^-119
    11846222746654873270, // 23^-112
    9391065840292895827,  // 23^-105
    14889491697531980297, // 23^-98
    11803610302659709381, // 23^-91
    9357284923309262442,  // 23^-84
    14835932209022725101, // 23^-77
    11761151141311856318, // 23^-70
    9323625520791788901,  // 23^-63
    14782565381140685845, // 23^-56
    11718844711233177467, // 23^-49
    9290087195636725377,  // 23^-42
    14729390520859877547, // 23^-35
    11676690463028916948, // 23^-28
    9256669512312642559,  // 23^-21
    14676406937647222172, // 23^-14
    11634687849280565129, // 23^-7
    9223372036854775808,  // 23^0
    14623613943453581312, // 23^7
    11592836324538749809, // 23^14
    18380388673718779295, // 23^21
    14571010852704821123, // 23^28
    11551135345316152959, // 23^35
    18314271962956325083, // 23^42
    14518596982292909406, // 23^49
    11509584370080452960, // 23^56
    18248393082825183718, // 23^63
    14466371651567044709, // 23^70
    11468182859247292218, // 23^77
    18182751177816837937, // 23^84
    14414334182324817337, // 23^91
    11426930275173270071, // 23^98
    18117345395500148774, // 23^105
    14362483898803402166, // 23^112
    11385826082148960918, // 23^119
    18052174886510285819, // 23^126
    14310820127670783127, // 23^133
    11344869746391957446, // 23^140
    17987238804537697299, // 23^147
    14259342198017009262, // 23^154
    11304060736039938888, // 23^161
    17922536306317119829, // 23^168
    14208049441345482237, // 23^175
    11263398521143764220, // 23^182
    17858066551616627705, // 23^189
    14156941191564275184, // 23^196
    11222882573660590193, // 23^203
    17793828703226721580, // 23^210
    14106016784977482782, // 23^217
    11182512367447014130, // 23^224
];
const BASE23_SMALL_INT_POWERS: [u64; 7] = [1, 23, 529, 12167, 279841, 6436343, 148035889];
const BASE23_STEP: i32 = 7;
const BASE23_BIAS: i32 = 252;
const BASE23_LOG2_MULT: i64 = 296457;
const BASE23_LOG2_SHIFT: i32 = 16;

// BASE24

const BASE24_SMALL_MANTISSA: [u64; 7] = [
    9223372036854775808,  // 24^0
    13835058055282163712, // 24^1
    10376293541461622784, // 24^2
    15564440312192434176, // 24^3
    11673330234144325632, // 24^4
    17509995351216488448, // 24^5
    13132496513412366336, // 24^6
];
const BASE24_LARGE_MANTISSA: [u64; 68] = [
    13878157218102970303, // 24^-252
    14820082927730076197, // 24^-245
    15825938165500818674, // 24^-238
    16900061898413227754, // 24^-231
    18047087583901234911, // 24^-224
    9635981578611328308,  // 24^-217
    10289986187706530766, // 24^-210
    10988378804938565813, // 24^-203
    11734172092969064177, // 24^-196
    12530583187169601247, // 24^-189
    13381047573408163051, // 24^-182
    14289233907736158492, // 24^-175
    15259059841903798156, // 24^-168
    16294708922970511019, // 24^-161
    17400648639910404101, // 24^-154
    9290824847530286564,  // 24^-147
    9921403291771844100,  // 24^-140
    10594779784719249534, // 24^-133
    11313859076748534537, // 24^-126
    12081743066820822770, // 24^-119
    12901744183172431346, // 24^-112
    13777399672167044607, // 24^-105
    14712486856947913357, // 24^-98
    15711039431711468023, // 24^-91
    16777364861891103792, // 24^-84
    17916062965310470700, // 24^-77
    9566022877229980327,  // 24^-70
    10215279312745101062, // 24^-63
    10908601492662859386, // 24^-56
    11648980207252770253, // 24^-49
    12439609234991117453, // 24^-42
    13283899119592565366, // 24^-35
    14185491882103974832, // 24^-28
    15148276731524117655, // 24^-21
    16176406841720334625, // 24^-14
    17274317267012876867, // 24^-7
    9223372036854775808,  // 24^0
    9849372385059274752,  // 24^7
    10517860061584293888, // 24^14
    11231718727873462272, // 24^21
    11994027762626592768, // 24^28
    12808075545343924992, // 24^35
    13677373641439044901, // 24^42
    14605671950110933202, // 24^49
    15596974880318657672, // 24^56
    16655558624637160317, // 24^63
    17785989605508530085, // 24^70
    9496572086730262523,  // 24^77
    10141114821132365302, // 24^84
    10829403375886954548, // 24^91
    11564406827668344530, // 24^98
    12349295767632162835, // 24^105
    13187455978423603575, // 24^112
    14082503039459189950, // 24^119
    15038297923484984581, // 24^126
    16058963651690264296, // 24^133
    17148903079221976570, // 24^140
    18312817887821515019, // 24^147
    9777864433756263024,  // 24^154
    10441498787414525016, // 24^161
    11150174730505647564, // 24^168
    11906949284968677354, // 24^175
    12715086956165281921, // 24^182
    13578073815006577911, // 24^189
    14499632535849309517, // 24^196
    15483738455030488239, // 24^203
    16534636719312342666, // 24^210
    17656860598210983110, // 24^217
];
const BASE24_SMALL_INT_POWERS: [u64; 7] = [1, 24, 576, 13824, 331776, 7962624, 191102976];
const BASE24_STEP: i32 = 7;
const BASE24_BIAS: i32 = 252;
const BASE24_LOG2_MULT: i64 = 300481;
const BASE24_LOG2_SHIFT: i32 = 16;

// BASE25

const BASE25_SMALL_MANTISSA: [u64; 7] = [
    9223372036854775808,  // 25^0
    14411518807585587200, // 25^1
    11258999068426240000, // 25^2
    17592186044416000000, // 25^3
    13743895347200000000, // 25^4
    10737418240000000000, // 25^5
    16777216000000000000, // 25^6
];
const BASE25_LARGE_MANTISSA: [u64; 68] = [
    15492890949478498119, // 25^-252
    11008361120075348168, // 25^-245
    15643822052986917253, // 25^-238
    11115604119273511155, // 25^-231
    15796223521069679172, // 25^-224
    11223891875338892399, // 25^-217
    15950109677957715915, // 25^-210
    11333234566249726012, // 25^-203
    16105494987428025427, // 25^-196
    11443642469137689536, // 25^-189
    16262394054163123565, // 25^-182
    11555125961253852697, // 25^-175
    16420821625123739831, // 25^-168
    11667695520944036383, // 25^-161
    16580792590934885855, // 25^-154
    11781361728633673532, // 25^-147
    16742321987285426889, // 25^-140
    11896135267822264502, // 25^-133
    16905424996341287883, // 25^-126
    12012026926087520367, // 25^-119
    17070116948172426941, // 25^-112
    12129047596099288555, // 25^-105
    17236413322193710308, // 25^-98
    12247208276643356092, // 25^-91
    17404329748619824289, // 25^-84
    12366520073655226703, // 25^-77
    17573882009934360870, // 25^-70
    12486994201263968925, // 25^-63
    17745086042373215101, // 25^-56
    12608641982846233347, // 25^-49
    17917957937422433684, // 25^-42
    12731474852090538039, // 25^-35
    18092513943330655534, // 25^-28
    12855504354071922204, // 25^-21
    18268770466636286477, // 25^-14
    12980742146337069071, // 25^-7
    9223372036854775808,  // 25^0
    13107200000000000000, // 25^7
    9313225746154785156,  // 25^14
    13234889800848442797, // 25^21
    9403954806578300063,  // 25^28
    13363823550460978230, // 25^35
    9495567745759798747,  // 25^42
    13494013367335069727, // 25^49
    9588073174409622174,  // 25^56
    13625471488026082303, // 25^63
    9681479787123295682,  // 25^70
    13758210268297397763, // 25^77
    9775796363198734982,  // 25^84
    13892242184281734271, // 25^91
    9871031767461413346,  // 25^98
    14027579833653779454, // 25^105
    9967194951097567535,  // 25^112
    14164235936814247246, // 25^119
    10064294952495520794, // 25^126
    14302223338085469768, // 25^133
    10162340898095201970, // 25^140
    14441555006918636608, // 25^147
    10261342003245940623, // 25^154
    14582244039112794984, // 25^161
    10361307573072618726, // 25^168
    14724303658045725350, // 25^175
    10462247003350260393, // 25^182
    14867747215916808149, // 25^189
    10564169781387141817, // 25^196
    15012588195001998509, // 25^203
    10667085486916504429, // 25^210
    15158840208921026870, // 25^217
];
const BASE25_SMALL_INT_POWERS: [u64; 7] = [1, 25, 625, 15625, 390625, 9765625, 244140625];
const BASE25_STEP: i32 = 7;
const BASE25_BIAS: i32 = 252;
const BASE25_LOG2_MULT: i64 = 304340;
const BASE25_LOG2_SHIFT: i32 = 16;

// BASE26

const BASE26_SMALL_MANTISSA: [u64; 7] = [
    9223372036854775808,  // 26^0
    14987979559889010688, // 26^1
    12177733392409821184, // 26^2
    9894408381332979712,  // 26^3
    16078413619666092032, // 26^4
    13063711065978699776, // 26^5
    10614265241107693568, // 26^6
];
const BASE26_LARGE_MANTISSA: [u64; 67] = [
    12105269954044049440, // 26^-245
    11318739317371282802, // 26^-238
    10583312905946974966, // 26^-231
    9895670261906581517,  // 26^-224
    9252706671590202790,  // 26^-217
    17303038295456506514, // 26^-210
    16178786644847745028, // 26^-203
    15127582383507515360, // 26^-196
    14144679313308326113, // 26^-189
    13225639616708097270, // 26^-182
    12366313819957994305, // 26^-175
    11562822058185475244, // 26^-168
    10811536557764206566, // 26^-161
    10109065256878566708, // 26^-154
    9452236490329416245,  // 26^-147
    17676169338865748372, // 26^-140
    16527673784713390059, // 26^-133
    15453800848879553322, // 26^-126
    14449701983936623969, // 26^-119
    13510843673109724761, // 26^-112
    12632986961401522264, // 26^-105
    11812168316666510159, // 26^-98
    11044681734222321153, // 26^-91
    10327062004200202236, // 26^-84
    9656069066086567364,  // 26^-77
    18057346759632441273, // 26^-70
    16884084494735168740, // 26^-63
    15787054046203585657, // 26^-56
    14761302310200400353, // 26^-49
    13802198007013635263, // 26^-42
    12905410770780760221, // 26^-35
    12066891597841972649, // 26^-28
    11282854565446737172, // 26^-21
    10549759738273355365, // 26^-14
    9864297185584324446,  // 26^-7
    9223372036854775808,  // 26^0
    17248181016800002048, // 26^7
    16127493675824287744, // 26^14
    15079622135830712445, // 26^21
    14099835245963182583, // 26^28
    13183709258266090507, // 26^35
    12327107854416477244, // 26^42
    11526163470203963629, // 26^49
    10777259833438283283, // 26^56
    10077015636442889080, // 26^63
    9422269269415772631,  // 26^70
    17620129091456925542, // 26^77
    16475274709425560342, // 26^84
    15404806363345084091, // 26^91
    14403890877545881062, // 26^98
    13468009108242878856, // 26^105
    12592935539554553092, // 26^112
    11774719205254957782, // 26^119
    11009665850120294209, // 26^126
    10294321250328313309, // 26^133
    9625455617601982106,  // 26^140
    18000098033363922638, // 26^147
    16830555460575262708, // 26^154
    15737003020008648959, // 26^161
    14714503311068774005, // 26^168
    13758439736979533044, // 26^175
    12864495660801764695, // 26^182
    12028634915772762381, // 26^189
    11247083581971537298, // 26^196
    10516312947031287874, // 26^203
    9833023573966516058,  // 26^210
    18388260808361729691, // 26^217
];
const BASE26_SMALL_INT_POWERS: [u64; 7] = [1, 26, 676, 17576, 456976, 11881376, 308915776];
const BASE26_STEP: i32 = 7;
const BASE26_BIAS: i32 = 245;
const BASE26_LOG2_MULT: i64 = 20188234867;
const BASE26_LOG2_SHIFT: i32 = 32;

// BASE27

const BASE27_SMALL_MANTISSA: [u64; 6] = [
    9223372036854775808,  // 27^0
    15564440312192434176, // 27^1
    13132496513412366336, // 27^2
    11080543933191684096, // 27^3
    9349208943630483456,  // 27^4
    15776790092376440832, // 27^5
];
const BASE27_LARGE_MANTISSA: [u64; 76] = [
    16362187946641408838, // 27^-240
    11807394875954316034, // 27^-234
    17041067394086403622, // 27^-228
    12297292543386873229, // 27^-222
    17748114058878258402, // 27^-216
    12807516432401518638, // 27^-210
    9242248309993244326,  // 27^-204
    13338909893173747895, // 27^-198
    9625716122873707062,  // 27^-192
    13892351267110242231, // 27^-186
    10025094302862174179, // 27^-180
    14468755338661289290, // 27^-174
    10441042983020688038, // 27^-168
    15069074847369989965, // 27^-162
    10874249685827050127, // 27^-156
    15694302062657520659, // 27^-150
    11325430459582219446, // 27^-144
    16345470423947416967, // 27^-138
    11795331061968106016, // 27^-132
    17023656248839843776, // 27^-126
    12284728192712064755, // 27^-120
    17729980512159296735, // 27^-114
    12794430777395563548, // 27^-108
    9232805349408163458,  // 27^-102
    13325281304529035642, // 27^-96
    9615881366772943927,  // 27^-90
    13878157218102970303, // 27^-84
    10014851495355986817, // 27^-78
    14453972367916992462, // 27^-72
    10430375193750279268, // 27^-66
    15053678520084183432, // 27^-60
    10863139281980340679, // 27^-54
    15678266930207358578, // 27^-48
    11313859076748534537, // 27^-42
    16328769981827608423, // 27^-36
    11783279573783601017, // 27^-30
    17006262892853298360, // 27^-24
    12272176679245716810, // 27^-18
    17711865492790087155, // 27^-12
    12781358492223474271, // 27^-6
    9223372036854775808,  // 27^0
    13311666640442621952, // 27^6
    9606056659007943744,  // 27^12
    13863977671394362375, // 27^18
    10004619153098548172, // 27^24
    14439204501182606065, // 27^30
    10419718303939637392, // 27^36
    15038297923484984581, // 27^42
    10852040229820157048, // 27^48
    15662248181121787524, // 27^54
    11302299516591361707, // 27^60
    16312086602830473207, // 27^66
    11771240398807322073, // 27^72
    16988887307951181138, // 27^78
    12259637989871837542, // 27^84
    17693768981840924725, // 27^90
    12768299563225066619, // 27^96
    18427896724951050158, // 27^102
    13298065886687551351, // 27^108
    9596241989312152815,  // 27^114
    13849812612167175924, // 27^120
    9994397265397337538,  // 27^126
    14424451723026109070, // 27^132
    10409072302452601000, // 27^138
    15022933041500086259, // 27^144
    10840952517748290136, // 27^150
    15646245798661648271, // 27^156
    11290751767031273467, // 27^162
    16295420269522331823, // 27^168
    11759213524458657188, // 27^174
    16971529475976476179, // 27^180
    12247112111487835932, // 27^186
    17675690960401445308, // 27^192
    12755253976754113245, // 27^198
    18409068632845853217, // 27^204
    13284479029051404288, // 27^210
];
const BASE27_SMALL_INT_POWERS: [u64; 6] = [1, 27, 729, 19683, 531441, 14348907];
const BASE27_STEP: i32 = 6;
const BASE27_BIAS: i32 = 240;
const BASE27_LOG2_MULT: i64 = 311617;
const BASE27_LOG2_SHIFT: i32 = 16;

// BASE28

const BASE28_SMALL_MANTISSA: [u64; 6] = [
    9223372036854775808,  // 28^0
    16140901064495857664, // 28^1
    14123288431433875456, // 28^2
    12357877377504641024, // 28^3
    10813142705316560896, // 28^4
    9461499867151990784,  // 28^5
];
const BASE28_LARGE_MANTISSA: [u64; 76] = [
    10853684694473876180, // 28^-240
    9742165760957008810,  // 28^-234
    17488953546307848045, // 28^-228
    15697920957714630238, // 28^-222
    14090306875260685218, // 28^-216
    12647327526607851831, // 28^-210
    11352122773573968201, // 28^-204
    10189559113984709052, // 28^-198
    18292105715960495534, // 28^-192
    16418822825447359765, // 28^-186
    14737381642082644874, // 28^-180
    13228135778880165762, // 28^-174
    11873450822826176619, // 28^-168
    10657498289906897377, // 28^-162
    9566070681070377880,  // 28^-156
    17172830956378919788, // 28^-150
    15414172280784786485, // 28^-144
    13835616719528574716, // 28^-138
    12418720027433908743, // 28^-132
    11146926822720122755, // 28^-126
    10005377149705503250, // 28^-120
    17961465702601665525, // 28^-114
    16122043445170466212, // 28^-108
    14470995249030000148, // 28^-102
    12989029846596759700, // 28^-96
    11658831576707932907, // 28^-90
    10464858064026730335, // 28^-84
    9393158617970892313,  // 28^-78
    16862422458582420498, // 28^-72
    15135552519453149331, // 28^-66
    13585530230416439557, // 28^-60
    12194244736314878063, // 28^-54
    10945439903127358164, // 28^-48
    9824524377159351811,  // 28^-42
    17636802191900948811, // 28^-36
    15830628517722738088, // 28^-30
    14209423938610553080, // 28^-24
    12754245887402290033, // 28^-18
    11448091693168579255, // 28^-12
    10275699917675706335, // 28^-6
    9223372036854775808,  // 28^0
    16557624767515983872, // 28^6
    14861968965709594624, // 28^12
    13339964194082398208, // 28^18
    11973826961285400900, // 28^24
    10747594971986893695, // 28^30
    9646940619348801089,  // 28^36
    17318007155239366140, // 28^42
    15544481077627229210, // 28^48
    13952580675520064463, // 28^54
    12523705779222565186, // 28^60
    11241161050565762112, // 28^66
    10089960910324183248, // 28^72
    18113308885783841476, // 28^78
    16258336464718499495, // 28^84
    14593330587292989709, // 28^90
    13098836900821174211, // 28^96
    11757393360479052160, // 28^102
    10553326198326110898, // 28^108
    9472566787009190529,  // 28^114
    17004974516675479989, // 28^120
    15263505912112072336, // 28^126
    13700379997665963732, // 28^132
    12297332812083457696, // 28^138
    11037970794744924274, // 28^144
    9907579239127697723,  // 28^150
    17785900724855568076, // 28^156
    15964457964924108341, // 28^162
    14329547997401095751, // 28^168
    12862068117875988113, // 28^174
    11544871917724549298, // 28^180
    10362568941103939059, // 28^186
    9301344858947275744,  // 28^192
    16697600117649658875, // 28^198
    14987609529429357277, // 28^204
    13452737987730670580, // 28^210
];
const BASE28_SMALL_INT_POWERS: [u64; 6] = [1, 28, 784, 21952, 614656, 17210368];
const BASE28_STEP: i32 = 6;
const BASE28_BIAS: i32 = 240;
const BASE28_LOG2_MULT: i64 = 315055;
const BASE28_LOG2_SHIFT: i32 = 16;

// BASE29

const BASE29_SMALL_MANTISSA: [u64; 6] = [
    9223372036854775808,  // 29^0
    16717361816799281152, // 29^1
    15150109146474348544, // 29^2
    13729786413992378368, // 29^3
    12442618937680592896, // 29^4
    11276123412273037312, // 29^5
];
const BASE29_LARGE_MANTISSA: [u64; 76] = [
    9780142334064946636,  // 29^-240
    10835857583212112985, // 29^-234
    12005531775819627369, // 29^-228
    13301466184228767173, // 29^-222
    14737289938837575007, // 29^-216
    16328103363438049788, // 29^-210
    18090636782853846909, // 29^-204
    10021713236516230810, // 29^-198
    11103504802015131117, // 29^-192
    12302070113036945059, // 29^-186
    13630014285094069421, // 29^-180
    15101303090037955289, // 29^-174
    16731409831799452344, // 29^-168
    9268739038298839376,  // 29^-162
    10269250974512215384, // 29^-156
    11377762945074294339, // 29^-150
    12605932989231929836, // 29^-144
    13966677570638048918, // 29^-138
    15474307417689145256, // 29^-132
    17144678027117236568, // 29^-126
    9497678206828984163,  // 29^-120
    10522902929736936910, // 29^-114
    11658795303156142066, // 29^-108
    12917301321555931503, // 29^-102
    14311656487072982013, // 29^-96
    15856525005124406387, // 29^-90
    17568154005459773215, // 29^-84
    9732272205284828726,  // 29^-78
    10782820124222926001, // 29^-72
    11946769200332301461, // 29^-66
    13236360495839591806, // 29^-60
    14665156431661011058, // 29^-54
    16248183421166822582, // 29^-48
    18002089900515211938, // 29^-42
    9972660708767378680,  // 29^-36
    11049157310268331325, // 29^-30
    12241856093602695018, // 29^-24
    13563300476969856592, // 29^-18
    15027387875005778139, // 29^-12
    16649515855621676607, // 29^-6
    9223372036854775808,  // 29^0
    10218986842372440064, // 29^6
    11322073062575009312, // 29^12
    12544231674979455490, // 29^18
    13898315921993315819, // 29^24
    15398566486364679514, // 29^30
    17060761258115507449, // 29^36
    9451190634016324153,  // 29^42
    10471397266405980105, // 29^48
    11601729872662437745, // 29^54
    12854075976092328003, // 29^60
    14241606296013212103, // 29^66
    15778913262056350490, // 29^72
    17482164480364512070, // 29^78
    9684636382831873707,  // 29^84
    10730042263704319491, // 29^90
    11888294245613666403, // 29^96
    13171573475377840424, // 29^102
    14593375990949121808, // 29^108
    16168654657039833397, // 29^114
    17913976421956996862, // 29^120
    9923848274745194421,  // 29^126
    10995075829111145761, // 29^132
    12181936799210906401, // 29^138
    13496913207916061440, // 29^144
    14953834447230017102, // 29^150
    16568022719743769659, // 29^156
    18356454179736676324, // 29^162
    10168968734308426004, // 29^168
    11266655761164621625, // 29^174
    12482832365519782645, // 29^180
    13830288877980342143, // 29^186
    15323196278493163895, // 29^192
    16977255230225892037, // 29^198
    9404930600437880197,  // 29^204
    10420143703980341466, // 29^210
];
const BASE29_SMALL_INT_POWERS: [u64; 6] = [1, 29, 841, 24389, 707281, 20511149];
const BASE29_STEP: i32 = 6;
const BASE29_BIAS: i32 = 240;
const BASE29_LOG2_MULT: i64 = 318373;
const BASE29_LOG2_SHIFT: i32 = 16;

// BASE30

const BASE30_SMALL_MANTISSA: [u64; 6] = [
    9223372036854775808,  // 30^0
    17293822569102704640, // 30^1
    16212958658533785600, // 30^2
    15199648742375424000, // 30^3
    14249670695976960000, // 30^4
    13359066277478400000, // 30^5
];
const BASE30_LARGE_MANTISSA: [u64; 74] = [
    15921395853562858335, // 30^-234
    10809579470425214363, // 30^-228
    14677985448278451843, // 30^-222
    9965385675239368708,  // 30^-216
    13531681443098000788, // 30^-210
    18374241463874359754, // 30^-204
    12474900136854879801, // 30^-198
    16939271613521887687, // 30^-192
    11500650091336533543, // 30^-186
    15616368347004676150, // 30^-180
    10602485877430447296, // 30^-174
    14396779620362065880, // 30^-168
    9774465433549085656,  // 30^-162
    13272436896445757604, // 30^-156
    18022221508452589239, // 30^-150
    12235901765210495847, // 30^-144
    16614743297618723424, // 30^-138
    11280316732790367097, // 30^-132
    15317184660964044954, // 30^-126
    10399359853791807565, // 30^-120
    14120961229157126909, // 30^-114
    9587202906660312336,  // 30^-108
    13018159044823362852, // 30^-102
    17676945670836105047, // 30^-96
    12001482205502242389, // 30^-90
    16296432405358431306, // 30^-84
    11064204595523231124, // 30^-78
    15023732837543702665, // 30^-72
    10200125387468709836, // 30^-66
    13850427060322257636, // 30^-60
    9403528018831206315,  // 30^-54
    12768752734601403407, // 30^-48
    17338284744926585040, // 30^-42
    11771553735296689434, // 30^-36
    15984219821228248249, // 30^-30
    10852232807944894743, // 30^-24
    14735903063773789011, // 30^-18
    10004707922685045925, // 30^-12
    13585075876931470780, // 30^-6
    9223372036854775808,  // 30^0
    12524124635136000000, // 30^6
    17006112000000000000, // 30^12
    11546030312776565551, // 30^18
    15677988711770840524, // 30^24
    10644322047830505987, // 30^30
    14453587630518598230, // 30^36
    9813034332029575584,  // 30^42
    13324808381590173768, // 30^48
    18093335088676282534, // 30^54
    12284183203843431517, // 30^60
    16680303133282552614, // 30^66
    11324827544542942993, // 30^72
    15377624481863911156, // 30^78
    10440394512637323916, // 30^84
    14176680892170610158, // 30^90
    9625032889090827484,  // 30^96
    13069527179276967861, // 30^102
    17746696832949127203, // 30^108
    12048838651943871501, // 30^114
    16360736223435182728, // 30^120
    11107862654034279481, // 30^126
    15083014731837417449, // 30^132
    10240373890390132852, // 30^138
    13905079227116716745, // 30^144
    9440633241616270046,  // 30^150
    12819136740897336720, // 30^156
    17406699590597596894, // 30^162
    11818002910861417777, // 30^168
    16047291684929232224, // 30^174
    10895054450550498712, // 30^180
    14794049215412351417, // 30^186
    10044185331124443731, // 30^192
    13638680998961850032, // 30^198
    9259766385185707988,  // 30^204
];
const BASE30_SMALL_INT_POWERS: [u64; 6] = [1, 30, 900, 27000, 810000, 24300000];
const BASE30_STEP: i32 = 6;
const BASE30_BIAS: i32 = 234;
const BASE30_LOG2_MULT: i64 = 321578;
const BASE30_LOG2_SHIFT: i32 = 16;

// BASE31

const BASE31_SMALL_MANTISSA: [u64; 6] = [
    9223372036854775808,  // 31^0
    17870283321406128128, // 31^1
    17311836967612186624, // 31^2
    16770842062374305792, // 31^3
    16246753247925108736, // 31^4
    15739042208927449088, // 31^5
];
const BASE31_LARGE_MANTISSA: [u64; 74] = [
    15172192345302428421, // 31^-234
    12540609161645107233, // 31^-228
    10365468257053156090, // 31^-222
    17135201456813756829, // 31^-216
    14163138687236953263, // 31^-210
    11706573627364173290, // 31^-204
    9676094340331131706,  // 31^-198
    15995594383677739926, // 31^-192
    13221193938792609146, // 31^-186
    10928007110853986174, // 31^-180
    18065136926019727780, // 31^-174
    14931778907414090897, // 31^-168
    12341894902482781431, // 31^-162
    10201220546354171409, // 31^-156
    16863682839241173595, // 31^-150
    13938714372965575021, // 31^-144
    11521075213714088050, // 31^-138
    9522770215989197442,  // 31^-132
    15742133595063495983, // 31^-126
    13011695363011784957, // 31^-120
    10754845599386459585, // 31^-114
    17778882864941161542, // 31^-108
    14695174979700806287, // 31^-102
    12146329402386737855, // 31^-96
    10039575449430160254, // 31^-90
    16596466614020050649, // 31^-84
    13717846210614220387, // 31^-78
    11338516145303865769, // 31^-72
    9371875613960541536,  // 31^-66
    15492689060539222513, // 31^-60
    12805516430937677459, // 31^-54
    10584427946771654325, // 31^-48
    17497164689077279120, // 31^-42
    14462320197950402007, // 31^-36
    11953862767183809017, // 31^-30
    9880491726141866768,  // 31^-24
    16333484606893641287, // 31^-18
    13500477850600094178, // 31^-12
    11158849846261135900, // 31^-6
    9223372036854775808,  // 31^0
    15247197139898466304, // 31^6
    12602604540616796176, // 31^12
    10416710674748495795, // 31^18
    17219910524322248562, // 31^24
    14233155154461633068, // 31^30
    11764445893307051548, // 31^36
    9723928789827359386,  // 31^42
    16074669723871456105, // 31^48
    13286553836236866995, // 31^54
    10982030478739077827, // 31^60
    18154443194596327488, // 31^66
    15005595201356001156, // 31^72
    12402907923608447627, // 31^78
    10251650993997756459, // 31^84
    16947049635463054782, // 31^90
    14007621382887632827, // 31^96
    11578030455268066882, // 31^102
    9569846696947249770,  // 31^108
    15819955934111728582, // 31^114
    13076019589586139267, // 31^120
    10808012931221917147, // 31^126
    17866774016535005152, // 31^132
    14767821605568725557, // 31^138
    12206375631777172937, // 31^144
    10089206793225315915, // 31^150
    16678512408132988469, // 31^156
    13785661343319529298, // 31^162
    11394568893327831301, // 31^168
    9418206136893990095,  // 31^174
    15569278253075119325, // 31^180
    12868821397533098208, // 31^186
    10636752807015729117, // 31^192
    17583663147154342787, // 31^198
    14533815689909759814, // 31^204
];
const BASE31_SMALL_INT_POWERS: [u64; 6] = [1, 31, 961, 29791, 923521, 28629151];
const BASE31_STEP: i32 = 6;
const BASE31_BIAS: i32 = 234;
const BASE31_LOG2_MULT: i64 = 21278111132;
const BASE31_LOG2_SHIFT: i32 = 32;

// BASE33

const BASE33_SMALL_MANTISSA: [u64; 6] = [
    9223372036854775808,  // 33^0
    9511602413006487552,  // 33^1
    9808839988412940288,  // 33^2
    10115366238050844672, // 33^3
    10431471432989933568, // 33^4
    10757454915270868992, // 33^5
];
const BASE33_LARGE_MANTISSA: [u64; 72] = [
    16952605037124200569, // 33^-228
    10195070131008495069, // 33^-222
    12262357879342609130, // 33^-216
    14748836332546310936, // 33^-210
    17739506162243888511, // 33^-204
    10668301952265249182, // 33^-198
    12831548466319904021, // 33^-192
    15433443558330863109, // 33^-186
    9281466718275888268,  // 33^-180
    11163500111543439891, // 33^-174
    13427159577595330562, // 33^-168
    16149828684624228128, // 33^-162
    9712291160146516482,  // 33^-156
    11681684235978010467, // 33^-150
    14050417593436164695, // 33^-144
    16899466768835551431, // 33^-138
    10163113486548439647, // 33^-132
    12223921281461810852, // 33^-126
    14702605819874780450, // 33^-120
    17683901337162836029, // 33^-114
    10634861953510936381, // 33^-108
    12791327729538214791, // 33^-102
    15385067131072375518, // 33^-96
    9252373781378705800,  // 33^-90
    11128507904583594948, // 33^-84
    13385071886268464065, // 33^-78
    16099206734335173177, // 33^-72
    9681847795705762071,  // 33^-66
    11645067770860388376, // 33^-60
    14006376287807173243, // 33^-54
    16846495063476347823, // 33^-48
    10131257010808365886, // 33^-42
    12185605163840289543, // 33^-36
    14656520217639143557, // 33^-30
    17628470806481188820, // 33^-24
    10601526773079323099, // 33^-18
    12751233065433685927, // 33^-12
    15336842340660548274, // 33^-6
    9223372036854775808,  // 33^0
    11093625381373083648, // 33^6
    13343116119623879688, // 33^12
    16048743459528137878, // 33^18
    9651499856579507665,  // 33^24
    11608566080760702539, // 33^30
    13962473030502269494, // 33^36
    16793689398951866695, // 33^42
    10099500389807484117, // 33^48
    12147409148830342864, // 33^54
    14610579071614836924, // 33^60
    17573214023869781748, // 33^66
    10568296082415350040, // 33^72
    12711264078829073096, // 33^78
    15288768711786753433, // 33^84
    18388922397719682024, // 33^90
    11058852198106072831, // 33^96
    13301291864141109889, // 33^102
    15998438362831755651, // 33^108
    9621247043655259795,  // 33^114
    11572178805914439916, // 33^120
    13918707388806312258, // 33^126
    16741049254803901004, // 33^132
    10067843310549183526, // 33^138
    12109332859968012500, // 33^144
    14564781929001072895, // 33^150
    17518130444711929011, // 33^156
    10535169553993820096, // 33^162
    12671420375785822681, // 33^168
    15240845770632227134, // 33^174
    18331281964891256972, // 33^180
    11024188012054395372, // 33^186
    13259598707595875029, // 33^192
    15948290948433680084, // 33^198
];
const BASE33_SMALL_INT_POWERS: [u64; 6] = [1, 33, 1089, 35937, 1185921, 39135393];
const BASE33_STEP: i32 = 6;
const BASE33_BIAS: i32 = 228;
const BASE33_LOG2_MULT: i64 = 330590;
const BASE33_LOG2_SHIFT: i32 = 16;

// BASE34

const BASE34_SMALL_MANTISSA: [u64; 6] = [
    9223372036854775808,  // 34^0
    9799832789158199296,  // 34^1
    10412322338480586752, // 34^2
    11063092484635623424, // 34^3
    11754535764925349888, // 34^4
    12489194250233184256, // 34^5
];
const BASE34_LARGE_MANTISSA: [u64; 72] = [
    9604872659818954289,  // 34^-228
    13818638119852157632, // 34^-222
    9940514895438007254,  // 34^-216
    14301530372152488549, // 34^-210
    10287886147601198282, // 34^-204
    14801297292224652053, // 34^-198
    10647396286743453217, // 34^-192
    15318528565264575918, // 34^-186
    11019469506220361724, // 34^-180
    15853834483014935870, // 34^-174
    11404544822822581011, // 34^-168
    16407846663860846991, // 34^-162
    11803076594780713339, // 34^-156
    16981218798089296108, // 34^-150
    12215535057871861844, // 34^-144
    17574627419191661979, // 34^-138
    12642406880260427750, // 34^-132
    18188772702119398880, // 34^-126
    13084195736727816960, // 34^-120
    9412189644717380884,  // 34^-114
    13541422902968601381, // 34^-108
    9741098573165682574,  // 34^-102
    14014627870654357169, // 34^-96
    10081501222766715924, // 34^-90
    14504368983990906269, // 34^-84
    10433799241558921201, // 34^-78
    15011224098520048145, // 34^-72
    10798408313169791102, // 34^-66
    15535791262943115320, // 34^-60
    11175758647289472494, // 34^-54
    16078689424770850259, // 34^-48
    11566295487283966163, // 34^-42
    16640559160632214299, // 34^-36
    11970479635546867736, // 34^-30
    17222063432103834911, // 34^-24
    12388787997209523031, // 34^-18
    17823888367951909878, // 34^-12
    12821714142851132552, // 34^-6
    9223372036854775808,  // 34^0
    13269768890872758272, // 34^6
    9545682734772404224,  // 34^12
    13733480910222387686, // 34^18
    9879256578703990224,  // 34^24
    14213397344182222761, // 34^30
    10224487159240697338, // 34^36
    14710084455954213119, // 34^42
    10581781820995279550, // 34^48
    15224128296805573036, // 34^54
    10951562143236309252, // 34^60
    15756135397562640779, // 34^66
    11334264437318166304, // 34^72
    16306733484268988021, // 34^78
    11730340261493716029, // 34^84
    16876572218852198941, // 34^90
    12140256953717114113, // 34^96
    17466323965673246884, // 34^102
    12564498183065403345, // 34^108
    18076684584862935827, // 34^114
    13003564520429535778, // 34^120
    9354187126690740272,  // 34^126
    13457974029148190318, // 34^132
    9681069157385005207,  // 34^138
    13928262876281286641, // 34^144
    10019374079298318020, // 34^150
    14414985965244449544, // 34^156
    10369501065317377529, // 34^162
    14918717590550882042, // 34^168
    10731863237423767546, // 34^174
    15440052115433190547, // 34^180
    11106888154145020298, // 34^186
    15979604673144701925, // 34^192
    11495018315039655259, // 34^198
];
const BASE34_SMALL_INT_POWERS: [u64; 6] = [1, 34, 1156, 39304, 1336336, 45435424];
const BASE34_STEP: i32 = 6;
const BASE34_BIAS: i32 = 228;
const BASE34_LOG2_MULT: i64 = 333412;
const BASE34_LOG2_SHIFT: i32 = 16;

// BASE35

const BASE35_SMALL_MANTISSA: [u64; 6] = [
    9223372036854775808,  // 35^0
    10088063165309911040, // 35^1
    11033819087057715200, // 35^2
    12068239626469376000, // 35^3
    13199637091450880000, // 35^4
    14437103068774400000, // 35^5
];
const BASE35_LARGE_MANTISSA: [u64; 71] = [
    11348773864264802781, // 35^-222
    9714654125541636184,  // 35^-216
    16631665395337738380, // 35^-210
    14236857547774631404, // 35^-204
    12186880148060573338, // 35^-198
    10432080762542161338, // 35^-192
    17859912908640730010, // 35^-186
    15288248642090717076, // 35^-180
    13086880531724678972, // 35^-174
    11202489314578100722, // 35^-168
    9589433214356533221,  // 35^-162
    16417284907013989533, // 35^-156
    14053345890899718904, // 35^-150
    12029792492965214691, // 35^-144
    10297612294415481616, // 35^-138
    17629700433836653197, // 35^-132
    15091184660126225295, // 35^-126
    12918191962520288360, // 35^-120
    11058090357972464737, // 35^-114
    9465826388078148767,  // 35^-108
    16205667761547463659, // 35^-102
    13872199680760223069, // 35^-96
    11874729681889289960, // 35^-90
    10164877111271147984, // 35^-84
    17402455374597619654, // 35^-78
    14896660812999728329, // 35^-72
    12751677771947325078, // 35^-66
    10915552689343391453, // 35^-60
    9343812841314943660,  // 35^-54
    15996778339727633381, // 35^-48
    13693388426986467236, // 35^-42
    11721665614797754707, // 35^-36
    10033852871240677221, // 35^-30
    17178139481236495112, // 35^-24
    14704644358629538426, // 35^-18
    12587309932484688516, // 35^-12
    10774852316876721446, // 35^-6
    9223372036854775808,  // 35^0
    15790581481472000000, // 35^6
    13516882032226562500, // 35^12
    11570574528082381959, // 35^18
    9904517520440015906,  // 35^24
    16956714997100751955, // 35^30
    14515102976976096155, // 35^36
    12425060777883196253, // 35^42
    10635965558010358334, // 35^48
    18208967404416189641, // 35^54
    15587042479907979542, // 35^60
    13342650787080448100, // 35^66
    11421430990225254489, // 35^72
    9776849289257450184,  // 35^78
    16738144652217302890, // 35^84
    14328004764601889967, // 35^90
    12264902998508825496, // 35^96
    10498869035448040891, // 35^102
    17974255652391389054, // 35^108
    15386127075531072702, // 35^114
    13170665365099231511, // 35^120
    11274209897518154234, // 35^126
    9650826688689364000,  // 35^132
    16522391657019252092, // 35^138
    14143318229301497845, // 35^144
    12106809636745979660, // 35^150
    10363539673224497244, // 35^156
    17742569311160898016, // 35^162
    15187801450438335382, // 35^168
    13000896817848986534, // 35^174
    11128886469837128365, // 35^180
    9526428506723229038,  // 35^186
    16309419696153507876, // 35^192
    13961012284800847178, // 35^198
];
const BASE35_SMALL_INT_POWERS: [u64; 6] = [1, 35, 1225, 42875, 1500625, 52521875];
const BASE35_STEP: i32 = 6;
const BASE35_BIAS: i32 = 222;
const BASE35_LOG2_MULT: i64 = 336153;
const BASE35_LOG2_SHIFT: i32 = 16;

// BASE36

const BASE36_SMALL_MANTISSA: [u64; 6] = [
    9223372036854775808,  // 36^0
    10376293541461622784, // 36^1
    11673330234144325632, // 36^2
    13132496513412366336, // 36^3
    14774058577588912128, // 36^4
    16620815899787526144, // 36^5
];
const BASE36_LARGE_MANTISSA: [u64; 71] = [
    11172994339528645078, // 36^-222
    11325430459582219446, // 36^-216
    11479946305982273645, // 36^-210
    11636570252986002899, // 36^-204
    11795331061968106016, // 36^-198
    11956257886702331980, // 36^-192
    12119380278715084095, // 36^-186
    12284728192712064755, // 36^-180
    12452331992078957377, // 36^-174
    12622222454457155586, // 36^-168
    12794430777395563548, // 36^-162
    12968988584079505325, // 36^-156
    13145927929137795237, // 36^-150
    13325281304529035642, // 36^-144
    13507081645508223020, // 36^-138
    13691362336674758052, // 36^-132
    13878157218102970303, // 36^-126
    14067500591556283265, // 36^-120
    14259427226786160917, // 36^-114
    14453972367916992462, // 36^-108
    14651171739918087751, // 36^-102
    14851061555163971849, // 36^-96
    15053678520084183432, // 36^-90
    15259059841903798156, // 36^-84
    15467243235475914756, // 36^-78
    15678266930207358578, // 36^-72
    15892169677078874302, // 36^-66
    16108990755761097026, // 36^-60
    16328769981827608423, // 36^-54
    16551547714066402526, // 36^-48
    16777364861891103792, // 36^-42
    17006262892853298360, // 36^-36
    17238283840257358043, // 36^-30
    17473470310879155380, // 36^-24
    17711865492790087155, // 36^-18
    17953513163287843146, // 36^-12
    18198457696935376453, // 36^-6
    9223372036854775808,  // 36^0
    9349208943630483456,  // 36^6
    9476762676643233792,  // 36^12
    9606056659007943744,  // 36^18
    9737114633407288801,  // 36^24
    9869960666451650558,  // 36^30
    10004619153098548172, // 36^36
    10141114821132365302, // 36^42
    10279472735705195138, // 36^48
    10419718303939637392, // 36^54
    10561877279594392463, // 36^60
    10705975767793509530, // 36^66
    10852040229820157048, // 36^72
    11000097487975795902, // 36^78
    11150174730505647564, // 36^84
    11302299516591361707, // 36^90
    11456499781411800112, // 36^96
    11612803841272866179, // 36^102
    11771240398807322073, // 36^108
    11931838548245548344, // 36^114
    12094627780758213915, // 36^120
    12259637989871837542, // 36^126
    12426899476958235198, // 36^132
    12596442956798861450, // 36^138
    12768299563225066619, // 36^144
    12942500854835305460, // 36^150
    13119078820790347231, // 36^156
    13298065886687551351, // 36^162
    13479494920515287357, // 36^168
    13663399238688592583, // 36^174
    13849812612167175924, // 36^180
    14038769272656891137, // 36^186
    14230303918895818486, // 36^192
    14424451723026109070, // 36^198
];
const BASE36_SMALL_INT_POWERS: [u64; 6] = [1, 36, 1296, 46656, 1679616, 60466176];
const BASE36_STEP: i32 = 6;
const BASE36_BIAS: i32 = 222;
const BASE36_LOG2_MULT: i64 = 22204658804;
const BASE36_LOG2_SHIFT: i32 = 32;
