/****/
/*
program:	src/bbs_script.c
version:	[$Id: bbs_script.c,v 5.47 1994/10/05 00:59:22 hitman Exp $]
purpose:	This is the main bbs program that reads and interpretes the menus for the users.
updates:	All updates are handled by RCS
Author:	The Hitman 1994
*/
/****/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#ifndef __MSDOS__
#	include <strings.h>
#	include <time.h>
#	include <unistd.h>
#endif /* not_MSDOS */

#ifndef __MSDOS__
#	include "bbs_director.h"
#	include "menu_info.h"
#else /* not_MSDOS */
#	include "..\src\bbs_dire.h"
#	include "..\src\menu_inf.h"
#endif /* MSDOS */
#include "version.h"

int
main (int argc, char **argv)
{

  char *option = NULL,		/* I am a option */
#ifndef ULTRIX
    command[10] =
  {0},				/* I am the command that the user chooses */
    menu_to_use[50] =
  {0};
#else /* ULTRIX */
    command[10],		/* I am the command that the user chooses */
    menu_to_use[50];
#endif /* not_ULTRIX */

  /* later this variable can be expanded into the users information and passwd around as users data, in
	a structure or something. */
  char *UserName = NULL;

  struct menu_struct menu[MAXLINES];	/* I am the menu option from the program */


  /* Work on a portable method of recording the size of the menu_structure without messing anything up.  This size should be the same for every system, and always allow the read of the datafiles.  So far you have to recompile you menus for a 16bit, 32bit, and 64bit machines.  All 16bit machine menus match, and 32bits the same.  */
  int size = sizeof (struct menu_struct);

  int cnt = 0;

  int skipmenu = FALSE;		/* a flag for skipping the menu in the case of a header
  containing the menu I want to see.  By default show the menu. */

  int count = 0;

  FILE *data_file = NULL;

#ifdef ULTRIX
  char filename[MAXLENGTH];
#else /*  ULTRIX */
  char filename[MAXLENGTH] =
  {0};
#endif /* not_ULTRIX */

  /* Declarations of programs included from outside of this set of code */
  extern int display_bbs_version (void);

  extern int check_speed (void);

  extern int set_up_env (void);

  extern int is_bbs_running (void);

  extern int display_screen (void);

  extern int pause (void);

  extern int my_random (void);

  extern char *menu_data_filename (const char *);

  extern char *header_filename (const char *);

  extern char *header_rnd_filename (const char *);

  extern char *help_filename (const char *);

  extern int display_file (char *);


#if DEBUG
  fprintf (stderr, "** %s: next step check_speed **\n", __FILE__);

#endif /* DEBUG */
  check_speed ();

#if DEBUG
  fprintf (stderr, "** %s: next step set_up_env **\n", __FILE__);

#endif /* DEBUG */
  set_up_env ();

#if DEBUG
  fprintf (stderr, "** %s: next step is_bbs_running **\n", __FILE__);

#endif /* DEBUG */
  is_bbs_running ();

#if DEBUG
  fprintf (stderr, "** %s: next step display_bbs_version **\n", __FILE__);

#endif /* DEBUG */
  display_bbs_version ();

#if DEBUG
  fprintf (stderr, "** %s: next step display_screen **\n", __FILE__);

#endif /* DEBUG */
  display_screen ();


  /* Create the first menu as the main.menu.  This is the first menu. */
#if DEBUG
  fprintf (stderr, "** %s: Lets read the first menu **\n", __FILE__);

#endif /* DEBUG */
#if OSF1
  strcpy ((char *) menu_to_use, (const char *) FIRST_MENU);

#else /* OSF1 */
  strcpy ((char *) menu_to_use, FIRST_MENU);

#endif /* OSF1 */

  /* figure out who the user is and
  at this point you can check the user name and if this is the annonous account
	you can get a login from the user.  A function will be needed to check all this. */
  UserName = getlogin ();

  /* SUPER LOOP FOR MENUS */
  for (;;)

    {


      /* Get the argument and give it to a variable, point to it then add the rest of the items needed. */
      strcpy (filename, menu_data_filename ((char *) menu_to_use));	/* Set down the filename */


      /*
		 * This is a binary file that will be READ_ONLY.  No writes
		 * will come to this file under this program.
			 */
#if DEBUG
      fprintf (stderr, "** %s: filename = %s, menu_to_use = %s **\n", __FILE__, filename, menu_to_use);

#endif /* DEBUG  */
      if ((data_file = fopen (filename, "rb")) == NULL)

	{

	  /* one day put in some error handleing. */
	  fprintf (stderr, "%s: %s(%d): %s: Need read permission\n", argv[0], __FILE__, __LINE__, filename);

	  exit (EXIT_FAILURE);

	}			/* if */

      /* Make sure the file is at the beginning */
      fseek (data_file, 0, SEEK_SET);


      /*
		 * Pad the entire block of variables with end of string
		 * characters to initialize everything
			 */
#if DEBUG
      fprintf (stderr, "** %s: Initializing the variables with end of string **\n", __FILE__);

#endif /* DEBUG */
      for (cnt = 0; cnt < MAXLINES; cnt++)

	{

	  menu[cnt].index = (int) '\0';

	  menu[cnt].keyword[0] = '\0';

	  menu[cnt].description[0] = '\0';

	  menu[cnt].information[0] = '\0';

	  menu[cnt].other[0] = '\0';

	}			/* for */


#if DEBUG
      /* header for the below menu showing */
      fprintf (stderr, "** %s: The menu as follows: **\n", __FILE__);
#endif /* DEBUG */
      /* REad the menu into memory. */
      /* set the count to zero to prevent reading where I left off */
      count = 0;

      while (count < MAXLINES && fread (&menu[count], size, 1, data_file) == 1)

	{

	  /* I could put something really fancy in here but it would go so fast that you wouldn't get a chance to see it. */
	  /* Increment that thing. */
	  count++;

#if DEBUG
	  fprintf (stderr, "** %s: menu[%d].index = %c, menu[%d].description = %s **\n", __FILE__, count, menu[count].index, count, menu[count].description);

#endif /* DEBUG */
	}			/* while */

      rewind (data_file);	/* rewind the data file when done */


#if DEBUG
      /*
		 * yes the menu[].index is a integer, but it is being used as
		 * a character.
			 */
      count = 0;		/* start back at the begining */

      while (count < MAXLINES && fread (&menu[count], size, 1, data_file) == 1)

	{

	  fprintf (stderr, "** %s: menu[%d].index = %c,\n", __FILE__, count, menu[count].index);

	  fprintf (stderr, "\tmenu[%d].keyword = %s, menu[%d].description = %s  **\n", count, menu[count].keyword, count, menu[count].description);

	  count++;		/* increment to the next position. */

	}			/* while_debugging */


      /* mention of the files closing */
      fprintf (stderr, "** %s: closing data file next **\n", __FILE__);

#endif /* DEBUG */
      fclose (data_file);

      /* end of reading menu ----------------------- */

      /* according to the header option on the menu, what do we do */
#if DEBUG
      fprintf (stderr, "** %s: Header: menu[0].index = %c **\n", __FILE__, menu[0].index);

#endif /* DEBUG */
      switch (menu[0].index)

	{

	case (int) 'H':	/* Always the same header. */

#if DEBUG
	  fprintf (stderr, "** %s: Getting ready to display the constant header **\n", __FILE__);

#endif /* DEBUG */
	  strcpy (filename, header_filename (menu[0].information));

	  display_file (filename);

	  break;


	case (int) 'R':	/* Random header for menu. */

#if DEBUG
	  fprintf (stderr, "** %s: Getting ready to display the random header **\n", __FILE__);

#endif /* DEBUG */
	  strcpy (filename, header_rnd_filename (menu[0].information));

	  display_file (filename);

	  break;


	case (int) 'B':	/* blank header, no menu is displyed */

#if DEBUG
	  fprintf (stderr, "** %s: Getting ready to display a header with menu in it. **\n", __FILE__);

#endif /* DEBUG */
	  strcpy (filename, header_filename (menu[0].information));

	  display_file (filename);

	  /* set the value of skip menu to TRUE.  I don't want to print out the menu because I have included its information in the header. */
	  skipmenu = TRUE;

	  break;


	default:		/* Any other menu header. */

	  fprintf (stdout, "--[\n");

	  fprintf (stdout, "--[ %s ]--\n", menu[0].description);

	  fprintf (stdout, "--[\n");

	  break;

	}			/* switch */


      /*
		 * Handle Menu: Make sure we leave the main title out of the
		 * menu.
			 */
      /* if the menu hasn't been assigned to be skiped take care in printing it
			 out for the user to see */
      if (skipmenu != TRUE)
	{
	  for (cnt = 0; cnt < count; cnt++)

	    {

	      if (cnt == 0)

		{

		  fprintf (stdout, "\t\t%s\n\n", menu[cnt].description);

		}

	      /* if */
	      else
		{

		  fprintf (stdout, "\t(%s)\t%s\n", menu[cnt].keyword, menu[cnt].description);

		}		/* else */

	    }			/* for */

	}			/* if_skipmenu */

      skipmenu = FALSE;		/* automatically reset the menu setting to display all
the menus */


      fprintf (stdout, "\n");

      /* end of the menu display */

      /* set up the users prompt */
#ifndef __MSDOS__
      fprintf (stdout, "%s's Choice: ", UserName);
#else /* not_MSDOS */
      /* Maybe if this program runs under novell I can get the novell user name and userid from the system itself.
	  After the anonomous user login gets coded, I can use the users name from the login prompt and write my own
	  get login function for the msdos platform.
		  */
      fprintf (stdout, "%s's Choice: ", "User");
#endif /* MSDOS */

      /* get the users input --this works pretty nice, but I need to make sure I can get what I need with multiple arguments. */
      gets (command);

      /* Set up the pointer to the users input. */
      option = command;

#if DEBUG
      fprintf (stderr, "** %s: The user picked the following... **\n", __FILE__);

      fprintf (stderr, "** %s: option = %s **\n", __FILE__, option);

#endif /* DEBUG */

      /* Look for special things. */
      switch ((int) option[0])

	{

	case (int) 'X':	/* Logout screen. */

	  display_screen ();

	  exit (EXIT_SUCCESS);

	  break;		/* exit_program_with_screen */


	case (int) 'h':	/* help Display */

#if DEBUG
	  fprintf (stderr, "** %s: help_file = %s **\n", __FILE__, HELP_FILE);

#endif /* DEBUG */
	  strcpy (filename, help_filename (HELP_FILE));

	  display_file (filename);

	  pause ();

	  break;


	  /*
			 * well if all else fails check out these command
			 * line things
	    			 */
	default:

	  /*
			 * add those extra functions here: This is where you
			 * would list out the commands like ''go menu_name''
			 * and list users, fancy things like that.  These
			 * will come with new versions, I want to get this
			 * all working pretty clean and fast first.
	    			 */
	  break;

	}			/* switch */



      /*
		 * Interpret menu and input.  need to figure out some way to
		 * get a command into the variable structure.  I do not need
		 * to look at option zero because it is just a reference to
		 * the header for this screen
			 */
      for (cnt = 1; cnt < count; cnt++)

	{

#if DEBUG
	  fprintf (stderr, "** %s: option = %s, menu[%d].keyword = %s **\n", __FILE__, option, cnt, menu[cnt].keyword);

#endif /* DEBUG */
	  /* compare the option with the menu find option and quit */
	  if (strncmp (option, menu[cnt].keyword, sizeof (option)) == 0)

	    {

#if DEBUG
	      fprintf (stderr, "** %s: We got a match! **\n", __FILE__);

#endif /* DEBUG */
	      break;

	    }			/* if */

	}			/* for */


      /*
		 * use the leftover cnt variable to look at the index for the
		 * menu option
			 */
#if DEBUG
      fprintf (stderr, "** %s: Index choosen: menu[%d].index = %c **\n", __FILE__, cnt, menu[cnt].index);

#endif /* DEBUG */
      switch (menu[cnt].index)

	{

	  /* Menu. */
	case 'M':

#if DEBUG
	  fprintf (stderr, "** %s: The next choice calls a menu **\n", __FILE__);

#endif /* DEBUG */
	  /* Declare the next menu to use */
	  strcpy ((char *) menu_to_use, menu[cnt].information);

	  break;


	  /* Program. */
	case 'P':

#if DEBUG
	  fprintf (stderr, "** %s: The user has requested to run a program **\n", __FILE__);

#endif /* DEBUG */
	  system (menu[cnt].information);

	  pause ();		/* stop and take a breather */

	  break;


	  /* Inquiry. */
	case 'I':

	  /*
			 * print out the  prompt and get the information from
			 * the user
	    			 */
#ifdef DEBUG
	  fprintf (stderr, "** %s: menu[%d].other = %s **\n", __FILE__, cnt, menu[cnt].other);

#endif /* DEBUG */
	  printf ("%s", menu[cnt].other);

	  gets (command);
#ifdef DEBUG
	  fprintf (stderr, "** %s: menu[%d].other = %s **\n", __FILE__, cnt, menu[cnt].other);

#endif /* DEBUG */
	  /*
			 * add the command from the menu file and the options
			 * from the user, this will make a full command that
			 * will then get sent to the execution.  this method
			 * I have chosen may cause the option to move past
			 * the end of the alloted space for this array
	    			 */
	  strcat (menu[cnt].information, " ");

	  strcat (menu[cnt].information, command);

#ifdef DEBUG
	  fprintf (stderr, "** %s: menu[%d].information = %s **\n", __FILE__, cnt, menu[cnt].information);

#endif /* DEBUG */
	  /*
			 * execute the function with the arguments the user
			 * provided, there will be no error checking and this
			 * will only work in the cases where the user enters
			 * something that will go right after the action.
			 * This could lead into security problems for those
			 * users that really know what they are doing, but I
			 * will deal with that later.  There are not any sid
			 * programs around here so it should not affect much.
	    			 */
#ifdef DEBUG
	  fprintf (stderr, "** %s: About to run the command: %s **\n", __FILE__, menu[cnt].information);

#endif /* DEBUG */
	  system (menu[cnt].information);

	  pause ();		/* stop the screen */

	  break;		/* option_inquiry */


	  /* Display. */
	case 'D':

	  fprintf (stderr, "This option is not currently supported,\nbut will be in future releases. --hitman\n");

	  /* system("more $ACTION");  */
	  break;


	  /* Send Mail */
	case 'S':

	  /* Some users just can't figure these things out. */
	  fprintf (stdout, "\n");

	  fprintf (stdout, "Just Start typing, when done just type '.' on a blank line.\n");

	  fprintf (stdout, "\tto abort a message just type '.' on a blank line.\n");

	  fprintf (stdout, "\n");

	  fprintf (stdout, "\tType:\n");

	  fprintf (stdout, "\t\t~e - for vi editor\n");

	  fprintf (stdout, "\n");

	  fprintf (stdout, "\n");

	  fprintf (stdout, "|========|========|========|========|========|========|========|========|\n");

	  fprintf (stdout, "\n");


	  /*
			 * system ("mail $ACTION"); need to get this to do
			 * something, build the command and go from there
	    			 */
#if DEBUG
	  fprintf (stderr, "** %s: Getting ready to start the mailer **\n", __FILE__);

#endif /* DEBUG */
	  strcpy (filename, MAILER);

	  strcat (filename, " ");	/* add a space before the argument */

	  strcat (filename, menu[cnt].information);	/* add the argument */

#if DEBUG
	  fprintf (stderr, "** %s: Starting filename = %s **\n", __FILE__, filename);

#endif /* DEBUG */
	  system (filename);	/* execute the program */

	  break;


	  /* groff text display. */
	case 'G':

	  fprintf (stderr, "This option is not currently supported,\nbut will be in future releases. --hitman\n");

	  /* system("groff $ACTION | more"); */
	  break;


	  /*
			 * This allows those programs that run from the
			 * format: program something:something
			 * something:something.  This is for lauching jobs
			 * that will take forever...
	     */
	case 'F':

	  fprintf (stderr, "This option is not currently supported,\nbut will be in future releases. --hitman\n");

	  /*
			 * system("ACTION=`grep \":$CHOICE:\" $MENU | awk -F:
			 * '{print $4\":\"$5\":\"$6}'`"); system("$ACTION |
			 * mail $LOGNAME & 2> /tmp/error"); fprintf(stdout,
			 * "Your job has been sent...look for mail later!");
	    			 */
	  break;


	  /*
			 * If this option is picked you will be logged out of
			 * the system and returned to where ever you started.
	    			 */
	case 'X':		/* Logout screen. */

	  display_screen ();

	  exit (EXIT_SUCCESS);

	  break;		/* exit_program_with_screen */


	default:

	  fprintf (stdout, "Type 'h' for help.\n");

	  break;

	}			/* switch */


      /** END THE SUPER LOOP **/
    }				/* for */

}				/* main */
