/* $Header: /home/vph/develop/lore/RCS/lore.h,v 1.94 1996/10/25 19:47:07 vph Exp vph $ */
 
/*****************************************************************************
*                           Linux OMEN Reader 1.xx                           *
*                  Copyrights (c) 1995 by Ville Hallivuori.                  *
*                                                                            *
*    This program is free software; you can redistribute it and/or modify    *
*    it under the terms of the GNU General Public License version 2 as       *
*    published by the Free Software Foundation.                              *
*                                                                            *
*    This program is distributed in the hope that it will be useful,         *
*    but WITHOUT ANY WARRANTY; without even the implied warranty of          *
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
*    GNU General Public License for more details.                            *
*                                                                            *
*    You should have received a copy of the GNU General Public License       *
*    along with this program; if not, write to the Free Software             *
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               *
*                                                                            *
*****************************************************************************/
   
#ifndef _LORE_H_
#define _LORE_H_
#include <fstream.h>
#include "widgets.h"
 
/*****************************************************************************
* Some constants. Note that more space you reserve for skipping, more memory *
* will go. 999 should be enought for everyone. Feel free to change SkipSpace.*
*****************************************************************************/

#define MaxNameSkip 1000
#define MaxSubjSkip 1000
#define MaxBoardA 10000
#define MaxMessages 1000
#define QUOTE_PREF "-> "

/*****************************************************************************
* Screen handling routines (ANSI/VT-100 required)                            *
*****************************************************************************/

void TextColor(int tfgcolor);                 //Changes text's foreground-color
void TextBackColor(int tbgcolor);             //Changes text's background-color
void BoldText(void);                          //Bolds text
void ClrAttrib(void);                         //Clears all attributes (eg bold)
void EraseDisplay(void);                      //Clears screen
void GotoXY(int, int);                        //Moves cursor position X,Y


/*****************************************************************************
* Functions which are called from menubar (most of these make own instance   *
* from some class)                                                           *
*****************************************************************************/

void ExitMnu(void);                           //"Exit"
void ReturnMListBox(void);                    //"Close session"
void RmSessionL(void);                        //"Remove session"
void RP(void);                                //"Reply-packet"
void FindFirst(void);                         //"Find"
void FindNext(void);                          //"Finds next"
void Markings(void);                          //"Bookmarks
void MTY(void);                               //"Messages to you"
void Save2File(void);                         //"Save to file"
void SkipSubject(void);                       //"Skip subject"
void SkipName(void);                          //"Skip writer"
void ReplyMsg(void);                          //"Folowup"
void PostNewMsg(void);                        //"Post message"
void LOper(void);                             //"List operations"
void RmMsg(void);                             //"Remove message (SysOp)"
void MvMsg(void);                             //"Move Message   (SysOp)"
void MkPriv(void);                            //"Make private   (SysOp)"
void Index(void);                             //"Index"
void RHelp(void);                             //"Keys"

void ExitNow(void);                           //"Exit"
void setglobal(void);                         //"Global settings"
void setbbs(void);                            //"Settings for BBS"
void SHelp(void);                             //"Keys"

void LAbout(void);                            //Displays aboutbox.



/*****************************************************************************
* Some global functions and variables, which make life lot more easier       *
*****************************************************************************/

void MakeMenu(void);                          //Creates menubars
void DrawBackGround(int x1=1, int y1=1, int x2=80, int y2=LINES-1);//Draws bg (menu-class uses this)
typedef void(*MFP)();                         //Menues param type (function)
void strConvert(unsigned char *TTC);          //Converts incoming strings
unsigned char Convert(unsigned char);         //Converts incoming chars
void resetOT(void);                           //Clears OutText
void oaddstr(char Str[9], int position);      //Add string to OutText
void strnadd(char *addto, int addpos, char *addfrom, int addn); //Very usefull
void uitos(unsigned int INro, char *Out);     //Unsigned integer->string (3ch)
void ReadBNames(char *FileName);              //Reads BNAMESxy.BBS


/*****************************************************************************
* Symbolic names to ANSI-colors                                              *
*****************************************************************************/

#define AnsiBegin 27   //Esc character ((begin of ANSI sequence).
#define black 30        //Color constants.
#define red 31 
#define green 32 
#define yellow 33 
#define blue 34 
#define magenda 35 
#define cyan 36 
#define white 37 


/*****************************************************************************
* colors of various elments. Change these if you want diferent look.         *
* For Black and White terminals you can define reverse-video putting +1000   *
* after color name (previous definitions). You can use allso bold-attribute  *
* putting +100 after colorattribute.                                         *
*****************************************************************************/

#define MnuFgColor black        //Menubar's foreground-color
#define MnuBgColor cyan         //Menubar's background-color
#define MnuBrdColor blue        //Menubar's border's foreground-color
#define MnuBrdBgColor cyan+1000 //Menubar's border's background-color
#define AMnuFgColor white+100   //Active's menuitem's foreground-color
#define AMnuBgColor red+1000    //Active's menuitem's background-color
#define HdrFgColor black        //Color of message's header
#define HdrBgColor white+1000   //Col of message's header's background
#define MsgFgColor white        //Color of message-text
#define MsgBgColor blue         //Color of message-text's background
#define StatFgColor black        /*Statusline's foreground-color*/
#define StatBgColor cyan+1000   //Statusline's background-color
#define WinFgColor black        //Window's foreground-color
#define WinBgColor cyan         //Window's background-color
#define WinBFgColor black       //Window's border's foreground-color
#define WinBBgColor cyan+1000   //Window's border's background-color
#define TextBoxFgColor white    //TextBox's foreground-color
#define TextBoxBgColor blue     //TextBox's background-color
#define ATextBoxFgColor white+100 //Selected TextBox's foregr-color
#define ATextBoxBgColor red+1000  //Selected TextBox's backgr-color
#define SLstFgColor white         //Listbox's foreground-color
#define SLstBgColor blue          //Listbox's background-color
#define ASLstFgColor blue         //Active ListBox's foreground-color
#define ASLstBgColor white+1000   //Active ListBox's background-color
#define CBoxFgColor black         //CheckBox's foreground-color
#define CBoxBgColor cyan          //CheckBox's background-color
#define ACBoxFgColor white+100    //Active CheckBox's foreground-color
#define ACBoxBgColor red+1000     //Active CheckBox's background-color
#define VSelectFgColor white      //Vertical selection's foregr-color
#define VSelectBgColor blue       //Vertical selection's backgr-color
#define AVSelectFgColor white+100 //Active Vertical sel's fg-color
#define AVSelectBgColor red+1000  //Active Vertical sel's bg-color


/*****************************************************************************
* buffered OutPut... new screenhandling method                               *
*****************************************************************************/

class boutstream
{
private:
  int sx;
  int sy;
  int xsize;
  int ysize;
  unsigned char *colors;
  unsigned char *chars;
  unsigned char *setcattrib(unsigned char ca);
public:
  boutstream(int x1,int y1,int x2,int y2);
  ~boutstream(void);
  void setcolor(int x1,int y1,int x2,int y2,int fg,int bg);
  void writexy(int x,int y, unsigned char *atext);
  void draw(int x1, int y1, int x2, int y2);
};


/*****************************************************************************
* This class keeps track on skipped messages                                 *
*****************************************************************************/

class SkipList                //Keeps track on skipped messages
{
public:
  SkipList(void);
  SkipList (const SkipList &);
  int LastName;               //Number of skipped names (starting from 0)
  char *Names[MaxNameSkip];   //Pointers to skipped names
  int LastSubject;            //Number of skipped subjects (--||--)
  char *Subjects[MaxSubjSkip];//Pointers to skipped subjects
  void ReadFiles(void);       //Reads skipfiles
  int IsSkipped(int MsgNro);  //Test, if msg has been skipped
};

/*****************************************************************************
* Posts message (new message, folowup, move, delete pub/priv togle)          *
*****************************************************************************/

class PostMsg
{
private:
  int BrdIndex;               //Boards placement in array
  int Board;                  //Which board message will be placed
  int MoveTo;                 //Which board message will be moved
  unsigned int ReplyTo;       //Number of original message
  char Subject[74];           //Subject of message
  char WhoTo[74];             //Receirver of message
  int Security;               //Public/private
  int DestZone;               //NetMail addres
  int DestNet;
  int DestNode;
  int MsgType;                //1=new, 2=reply, 3=delete, 4=move, 5=priv.
  int AskBoard(void);         //Asks where message will be put
  int AskMsgInfo(void);       //Ask subject, reseirver, P/R
  int AskNetMail(void);       //Ask information ned by netmail
  void GetFreeNames(char *MsgFile, char *HeaderFile);
  void EditMessage(char *MsgFile);    //Loads file to editor
  void WriteHeader(char *HeaderFile); //Writes message header to file
public:
  int NewMessage(void);       //Posts new message
  int ReplyMessage(void);     //Replys to message
  int RemoveMsg(void);        //Removes message (SysOp only)
  int MoveMsg(void);          //Moves message (SysOp only)
  int MakePrivate(void);      //Makes msg private (SysOp only)
};


/*****************************************************************************
* Class to show/reedit/undo all operations create by PostMsg -class          *
*****************************************************************************/

class OperList                //Creates list of operations
{
private:
  ListBox *lst_Operations;    //List of operations
  void GetBoardName(unsigned int BrdNum, char *BrdName); //Brd number -> -name
  void MsgMnu(int Index);     //Things to do message (menu)
  void UndoMnu(int Index);    //Undo operation
public:
  ListBox (const ListBox &);
  void ReadOperations(void);  //Reads all headerfile
  int LastOperation; //Number of operations (-1=0, 0=1, ...);
  struct OStruct              //Struct to save found operations
   {
     unsigned char Command;
     unsigned int CurBoard;
     unsigned int MoveBoard;
     char WhoTo[36];
     char Subject[73];
     char Extension[4];      //Info to reconstruct filenames
     char IDchars[3];
     char FIndex[4];
   };
  OStruct *Operations;      //Pointer to array of OStuct's
  void LisOper(void);       //Lists all operatons
};


/*****************************************************************************
* Class to create return-packet (handles allso converting characters)        *
*****************************************************************************/

class RPacket
{
private:
  OperList *OList;          //OperList havesome information for RPacket.
  void OstrConvert(unsigned char *TTC); //Converts outgoing character
  unsigned char OConvert(unsigned char Text); //Converts outgoing strings
  void ClearTemp(void);     //Clears temp-directory
  void WriteHeader(void);   //Writes one header from deparate headers
  void WriteMessages(void); //Writes messagefiles 
  void WriteSkip(void);     //Copyes skipfile
  void WriteTrash(void);    //Creates trash-file (unwanted writers)
  void ZipPackets(void);    //Zips returnpacket
  int IsOld(void);          //Removes old messagepackets
public:
  RPacket (const RPacket &);
  void WriteAll(void);      //Creates returnpacket
  RPacket();                //Constructor
  ~RPacket();               //Destructor
};

/*****************************************************************************
* Class which contain all information from SYSTEMxy.BBS -file                *
*****************************************************************************/

class BBSInfo               //Contains all data from SYSTEMxy.BBS -file
{
private:
  ifstream *SystemFile;     //Stream from  SYSTEMxy.BBS -file
  int ReadSysName(void);    //Reads name of BBS-system
  int ReadBoardInfo(int Nro, unsigned char linput); //Reads boards
public:
  BBSInfo (const BBSInfo &);
  int MaxBoard;             //Number of last board (internal)
  char SystemName[42];      //Name of system
  struct BrdRecord          //Info about boards
  {
    unsigned int BrdNro;    //Number of board
    unsigned char BrdStatus;//Statusbits
    char *BrdName;          //Name of board
  };
  BrdRecord Boards[MaxBoardA];   //Aray to store board-information
  BBSInfo(char FileName[100]);   //Initial values
  ~BBSInfo();
  void ReadFile(void);      //Reads file to memory
};


/*****************************************************************************
* Class which contain all information from NEWMSGxy.TXT -file                *
*****************************************************************************/

class Messages              //Contains all data from NEWMSGxy.TXT -file
{
private:
  ifstream MsgFile;         //Stream from NEWMSGxy.TXT
  int EatWhiteSpace(void);  //Reads SkipListextra spaces
  int ReadMsgNro(int CurMsg);    //Read MessageNumber
  void ReadBrdName(int CurMsg);  //Reads board name
  void ReadMsgDate(int CurMsg);  //Reads date of message
  void ReadMsgStatus(int CurMsg);//Reads message's status
  void ReadWhoFrom(int CurMsg);  //Reads writers name
  void ReadWhoTo(int CurMsg);    //Read receiver's name
  void ReadSubject(int CurMsg);  //Reads subject
  void ReadBodyText(int CurMsg); //Reads message
public:
  Messages (const Messages &);
  struct MsgRecord          //Information about message
  {
    unsigned int MsgNum;    //Messagenumber
    unsigned int BrdNum;    //Boardnumber
    char BrdName[81];       //Name of board
    char Date[11];          //Creationg date of message
    char Time[11];          //Creationg time of message
    char Chain[64];         //Previos/nex message
    unsigned int Status;    //Private/public status
    char From[38];          //Writer of message (+ 2 chars of workspace)
    char To[36];            //Receiver of message
    char Subject[73];       //Subject of message
    char *tpointer;         //Pointer to messages bodytext
  };
  MsgRecord MBase[MaxMessages];   //Array storing all data abou of messages
  int MaxMsg;               //Number of messages (starting from 0)
  Messages(char FileName[100]);  //Constructor
  ~Messages(void);          //Destructor
  void ReadMessages(void);  //Reads messages from file
};

/*****************************************************************************
* Session selection list                                                     *
*****************************************************************************/

/* This isn't really widget, so this is not in widgets.h.  */
class MListBox              //Session selection list
{
private:
  int LastItem;             //Index of last item
  int OnSrcItem;            //Firs item on screen
  void ReadSessions(void);  //Reads list of open sessions
  void DrawSubject(void);   //Open sessions/No open sessions -line
  void DrawItem(int Index); //Draws one item
  void ScrollDown(void);    //Scrolls list down
  void ScrollUp(void);      //Scrolls list up
  void ReadMsg(void);       //Goes to reading-mode
  void StatusLine(void);    //Draws statusline
public:
  struct IStruct            //Struct to save info about open sessions
  {
    char Name[42];          //BBS name
    char Date[12];          //First openingdate of session
    char IDc[3];            //IDchars of session
    char Index[4];          //Index of session (extension)
  };
  IStruct Items[1000];      //Array to save sessions
  int CurItem;              //Index of curent item
  void Draw(void);          //Draws list and background
  MListBox(void);           //Constructor
  void Handle(void);        //User-interface
  void RmSession(void);     //Removes session
};


/*****************************************************************************
*  All LORE's configuration info                                             *
*****************************************************************************/

class Config                //All LORE's configuration info
{
private:
  int CheckPaths(void);     //Cheks that all paths are OK
  Window *SWin;             //Pointer to Globat/BBS settings window
public:
  Config (const Config &);
  char LoreHome[200];       //Full  path of "~/.LORE/"
  char DownLoad[200];       //DownLoad directory
  char UpLoad[200];         //UpLoad directory
  char Editor[200];         //Editor name (needs ful path)
  char Signature[200];      //Signature -file
  char TagLine[200];        //TagLines -file
  char UName[33];           //Name of user in selected BBS
  char UAlias[33];          //Alias of user in selected BBS
  int OutChars;             //0=latin, 1=ibm, 2=sf7
  int IBMConv;              //0=no conversion, 1=conversion
  int SF7Conv;              //0=no conversion, 1=conversion
  Config(void);             //Initial variables
  void ReadGConfig(void);   //Reads settings from file
  int ReadBBS(int IndexID); //Reads BBS-settings from file 
  void SetGlob(void);       //Modifyes globat settings
  void SetBBS(int IndexID); //Modifyes BBS settings
};

/*****************************************************************************
*  File Handler - unzips new messages                                        *
*****************************************************************************/

class FHandler              //File Handler - unzips new messages
{
private:
  FHandler (const FHandler &);
  char Down[200];           //Download directory
  char FExt[5];             //Files extension
  char DownMask[200];       //All OMEN-packets
  char TmpDir[200];         // ~/.LORE/tmp/
  char LoreDir[200];        // ~/.LORE
  char FileMask[200];       // ~/.LORE/NEWMSGxy.???
  char IDc[3];              //ID-characters (xy on filename)
  void itos(int INro);      //Converts integer to string (INro<=999)
  void ReadIDChars(char *FileName); //Reads ID-characters
  int GetFreeNro(void);     //Gets first fee number for extension
  void UnZip(char *FileName, char *ToDir); //UnZips messages
  void Move(void);          //Moves files to LoreDir
  char *CutName(char *FName);    //Separates files-name and -path
  void AddEntry(char *Ext); //Adds entry to sessions.dat
  void ReMove(char *FileName);   //Removes Zipped packet
public:
  FHandler(void);           //Initial values
  ~FHandler(void);          //Unused
  void GetNew(void);        //Gets new omenpackets
};

#endif /*_LORE_H_*/

