/*
 * ftree.h --
 *	Definitions for using functional indexes.
 *	Mostly descriptions of the FUNCINDEX pseudo-catalog relation.
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/access/RCS/ftree.h,v 1.4 1990/08/17 08:50:42 cimarron Exp $
 */

#ifndef FTreeIncluded
#define FTreeIncluded

#include "access/btree.h"

/* ----------------
 *	constants should be in a pg_xxx.h file someplace.
 * ----------------
 */
#define	FunctionIndexIndexAttributeNumber		1
#define	FunctionIndexExtractAttributeNumber		2
#define	FunctionIndexCountAttributeNumber		3
#define	FunctionIndexElementAttributeNumber		4
#define	FunctionIndexListifyAttributeNumber		5

#define	FunctionIndexRelationNumberOfAttributes		5

/* XXX Should be in: cat.h */
typedef struct {
	ObjectId	finindex;
	ObjectId	finextract;
	ObjectId	fincount;
	ObjectId	finelement;
	ObjectId	finlistify;
} FunctionIndexTupleFormData;
typedef	FunctionIndexTupleFormData	*FunctionIndexTupleForm;

/* XXX Should be in: name.[ch] */
extern Name	FunctionIndexRelationName;

#endif /* !FTreeIncluded */
