/*
 * limit.h --
 *	POSTGRES limit definitions.
 *
 * Identification:
 *	$Header: /private/postgres/src/lib/H/tmp/RCS/limit.h,v 1.5 1990/08/17 08:54:42 cimarron Exp $
 */

#ifndef	LimitIncluded	/* Include this file only once. */
#define LimitIncluded	1

#include "tmp/c.h"

#define MaxBitsPerByte	8

typedef uint32	AttributeSize;	/* XXX should be defined elsewhere */

#define MaxHeapTupleSize	0x7fffffff
#define MaxAttributeSize	0x7fffffff

#define MaxIndexAttributeNumber	7

/*
 * AttributeSizeIsValid --
 *	True iff the attribute size is valid.
 */
extern
bool
AttributeSizeIsValid ARGS((
	AttributeSize	size
));

/*
 * TupleSizeIsValid --
 *	True iff the tuple size is valid.
 */
extern
bool
TupleSizeIsValid ARGS((
	TupleSize	size
));

#endif	/* !defined(LimitIncluded) */
