# $Header: /private/postgres/newconf/RCS/inh.mk,v 1.29 1992/06/22 16:53:34 mer Exp $ 
#
# NOTE:  For portability reasons, the BSD construction 
# "$(*<F)"
# has been replaced by
# `basename $(<F)`
# which is functionally equivalent.
#

#include config.mk
#include FILES/inh.mkf

allobjs: genlinks genincs $(GOD)/inh.o genobjs
.SUFFIXES: .h .i .lex .y .c .o .gen

$(GOD)/inh.c: $(INH_SRC)
	@ echo "creating inh.c" ; \
	cd $(SD)/lib/H/nodes ; \
	TREE=$(TREE) ; export TREE; \
	OD=`basename $(OD)` ; export OD; \
	SD=`basename $(SD)` ; export SD; \
	$(GENINH) $(INH_SRC) ; \
	mv inh.c $(GOD)/inh.c

$(GOD)/inh.o: $(GOD)/inh.c

genincs: $(ACC_GEN)

genobjs: $(ACC_OBJ) 

genifiles: genlinks rmifiles $(ACC_ISRC) 

rmifiles:
	@ rm $(ACC_ISRC) 

genlinks:
	@ cd $(GOD) ; \
	rm -f *.h ; \
	echo linking headers ; \
	for x in $(ACC_SRC) ; \
	do \
		f=`echo $$x | sed -e s%.\*/%%` ; \
		rm -f $$f ; \
		ln -s $$x ; \
	done

#
# note that we do not include defaults.mk
# for this wierd set 'gen processing
#
.h.gen:
	@ rm -f $*.gen
	-@ echo generating `basename $*.gen` ;\
	trap 'rm -f $*.gen ; exit' 2 ; \
	cd $(HD) ; \
	TREE=$(TREE) ; export TREE; \
	OD=`basename $(OD)` ; export OD; \
	SD=`basename $(SD)` ; export SD; \
	$(GSD)/Gen_accessors.sh $*.h > $*.gen
	@ chmod 444 $*.gen

.h.o:
	-@ echo compiling $(<F) ;\
	trap 'rm -f `basename $(<F) .h`.c ; exit' 2 ; \
	cd $(@D) ; \
	TREE=$(TREE) ; export TREE; \
	OD=`basename $(OD)` ; export OD; \
	SD=`basename $(SD)` ; export SD; \
	$(GSD)/Gen_creator.sh $(<F) > `basename $(<F) .h`.c
	@ cd $(@D) ; \
	$(CC) $(CFLAGS) -c `basename $(<F) .h`.c ; \
	rm -f `basename $(<F) .h`.c

.h.i:
	-@ echo creating intermediate file for $(<F) ; \
	trap 'rm -f `basename $(<F) .h`.i ; exit' 2 ; \
	cd $(@D) ; \
	TREE=$(TREE) ; export TREE; \
	OD=`basename $(OD)` ; export OD; \
	SD=`basename $(SD)` ; export SD; \
	if (test -n "$$SPRITE_OS") then \
	$(GSD)/Gen_accessors.sprite.sh $(<F) > `basename $(<F) .h`.i; \
	else \
	$(GSD)/Gen_accessors.sh $(<F) > `basename $(<F) .h`.i; \
	fi; \
	$(GSD)/Gen_creator.sh $(<F) >> `basename $(<F) .h`.i
