/* ----------------------------------------------------------------
 *	assoc.h
 *
 *	$Header: /private/postgres/src/utils/fmgr/RCS/assoc.h,v 1.4 1991/11/09 01:53:55 mer Exp $
 * ----------------------------------------------------------------
 */

#ifndef ASSOC_DEFD
#define ASSOC_DEFD

#include "assoc_int.h"


/***********************************************************************
**
**  See documentation in "assoc.c"
**
***********************************************************************/

/*****/
/* A handle on an associative memory */
#define assoc_mem assoc_memory

/*****/
/* Raw memory pointers from an associative memory. Do not use free() on
** them.  See assoc_free(). */
#define mem_cell H_memory_cell

/*****/
/***** Get unique stored string associated with a memory cell which
       was returned by assoc(), assoc_lookup() or assoc_seq(). */
#define string_from_cell(cell,table)  str_from_cell(cell,table)


/*****/
/***** Get memory cell associated with a string which was returned by
**     string_from_cell  */
#define cell_from_string(string,table) cell_from_str(string,table)

/*****/
/***** returns number of entries currently in table */
#define assoc_num_entries(table) (table->entries)

#endif ASSOC_DEFD

/*
 * assoc.c  -- Function prototypes
 */
assoc_mem new_assoc_mem ARGS((int value_size ));

/***** Associates a new cell with a given string. */
mem_cell assoc ARGS((char *string , assoc_mem table ));

/* Is like assoc, except uses counted string, rather that null-terminated */
mem_cell assocn ARGS((char *string , int length , assoc_mem table ));
mem_cell assocnf ARGS((char *string , int length , assoc_mem table ));

/***** Looks for a cell previously associated with a given string */
mem_cell assoc_lookup ARGS((char *string , assoc_mem table ));

/* Like assoc_lookup, except uses counted string, rather than null-
** terminated string
*/
mem_cell assocn_lookup ARGS((char *string , int length , assoc_mem table ));
mem_cell assocnf_lookup ARGS((char *string , int length , assoc_mem table ));

/* Sequences through a table, returning the cells found there in a
** non-deterministic order.  If you put cells into the table as you
** are sequencing through, the sequencer may find the added value or
** it may not, so you probably do not want to do that.  Set the variable
** "seq" to zero before the firished when it returns NULL;
*/
mem_cell assoc_seq ARGS((assoc_mem table , int *num ));

/***** Removes a memory cell from a table */
int assoc_free ARGS((mem_cell cell , assoc_mem table ));

/* Deallocates the memory associated with an assoc_mem table and returns zero,
** if the table was empty.  Otherwize it just returns the number of entries
** remaining in the table.
*/
int assoc_mem_free ARGS((assoc_mem table ));

/***** Empties a table, then removes it. */
int assoc_mem_remove ARGS((assoc_mem table ));
