/****************************************************************************
** $Id: dclock.h,v 1.4 1995/05/20 01:13:30 eiriken Exp $
**
** Definition of DigitalClock widget
**
** Authors : Eirik Eng and Haavard Nord
** Created : 941111
**
** Copyright (C) 1994,1995 by Troll Tech AS.  All rights reserved.
**
*****************************************************************************/

#ifndef DCLOCK_H
#define DCLOCK_H

#include <qwidget.h>
#include <qlcdnum.h>


class InteractiveLCD : public QLCDNumber	// interactive LCD display
{
    Q_OBJECT
public:
    InteractiveLCD( uint ndigits=1, QWidget *parent=0, const char *name=0 );

protected:
    void	mousePressEvent( QMouseEvent * );

signals:
    void	clicked();
};


class DigitalClock : public QWidget		// digital clock widget
{
    Q_OBJECT
public:
    DigitalClock( QWidget *parent=0, const char *name=0 );

private slots:
    void	showDate();
    void	stopDate();
    void	showTime();

protected:
    void	timerEvent( QTimerEvent * );
    void	resizeEvent( QResizeEvent * );

private:
    bool	showingDate() const;

    InteractiveLCD *lcd;
    bool	showingColon;
    int		normalTimer;
    int		showDateTimer;
};


#endif // DCLOCK_H
