/****************************************************************************
** $Id: q2matrix.h,v 1.2 1995/05/19 23:12:25 eiriken Exp $
**
** Definition of Q2DMatrix class
**
** Author  : Haavard Nord
** Created : 941020
**
** Copyright (C) 1994,1995 by Troll Tech AS.  All rights reserved.
**
*****************************************************************************/

#ifndef Q2MATRIX_H
#define Q2MATRIX_H

#include "qwindefs.h"
#include "qpntarry.h"
#include "qrect.h"

class Q2DMatrix					// 2D transform matrix
{
public:
    Q2DMatrix();
    Q2DMatrix( float m11, float m12, float m21, float m22,
	       float dx,  float dy );

    void	setMatrix( float m11, float m12, float m21, float m22,
			   float dx,  float dy );

    float	m11() const { return _m11; }	// get matrix values
    float	m12() const { return _m12; }
    float	m21() const { return _m21; }
    float	m22() const { return _m22; }
    float	dx()  const { return _dx; }
    float	dy()  const { return _dy; }

    void	map( int x, int y, int *tx, int *ty ) const;
    void	map( float x, float y, float *tx, float *ty ) const;
    QPoint	map( const QPoint & ) const;
    QPointArray	map( const QPointArray & ) const;

    void	reset();			// set to default matrix

    Q2DMatrix  &translate( float dx, float dy );// translate matrix
    Q2DMatrix  &scale( float sx, float sy );	// scale matrix
    Q2DMatrix  &shear( float sh, float sv );	// set hor/ver shear
    Q2DMatrix  &rotate( float a );		// rotate 0..360 degrees

    Q2DMatrix	invert( bool * = 0 ) const;	// invert matrix

    bool	operator==( const Q2DMatrix & ) const;
    bool	operator!=( const Q2DMatrix & ) const;
    Q2DMatrix  &operator*=( const Q2DMatrix & );

    QRect       boundingRect( const QRect &r ) const;
private:
    Q2DMatrix  &bmul( const Q2DMatrix & );
    float	_m11, _m12;
    float	_m21, _m22;
    float	_dx,  _dy;
};


Q2DMatrix operator*( const Q2DMatrix &, const Q2DMatrix & );


// --------------------------------------------------------------------------
// Q2DMatrix stream functions
//

QDataStream &operator<<( QDataStream &, const Q2DMatrix & );
QDataStream &operator>>( QDataStream &, Q2DMatrix & );


#endif // Q2MATRIX_H
