/**********************************************************************
** $Id: qprtdrv.h,v 1.4 1995/02/21 16:03:29 hanord Exp $
**
** Definition of QPrinterDriver class
**
** Author  : Eirik Eng
** Created : 940927
**
** Copyright (c) 1994,1995 by Troll Tech AS.  All rights reserved.
**
***********************************************************************/

#ifndef QPRTDRV_H
#define QPRTDRV_H

#include "qiodev.h"
#include "qpainter.h"
#include "qpaintdc.h"


class QPrinterDriver
{
public:
    QPrinterDriver();
    virtual ~QPrinterDriver(){}
    
    virtual void setDevice( QIODevice * );
    virtual bool cmd( int, QPDevCmdParam * ) = 0;
    QIODevice   *device();
private:
    QIODevice *dev;
};


#define QPRINTER_DRIVER_INSTALLER(x) \
    inline QPrinterDriver * name2(qInstallPrinterDriver_,x) () \
    { \
        return new x; \
    }

#define qInstallPrinterDriver(n,x) \
    qInternalAddPrinterDriver(n,name2(qInstallPrinterDriver_,x))

inline            QPrinterDriver::QPrinterDriver()          { dev = 0; }
inline void       QPrinterDriver::setDevice( QIODevice *d ) { dev = d; }
inline QIODevice *QPrinterDriver::device()                  { return dev; }

typedef QPrinterDriver *(*QInstallPrtDrvFunc)();

void qInternalAddPrinterDriver( const char *name, QInstallPrtDrvFunc f);

#define PDC_PRT_NEWPAGE    100
#define PDC_PRT_ABORT      101
// PDC_BEGIN has 3 arguments for printer drivers:
//                    str creator, str title, ival nCopies

#endif
