/**********************************************************************
** $Id: qtablew.h,v 1.11 1995/05/16 13:25:27 agulbra Exp $
**
** Definition of QTableWidget class
**
** Author  : Eirik Eng
** Created : 941115
**
** Copyright (C) 1994,1995 by Troll Tech AS.  All rights reserved.
**
***********************************************************************/

#ifndef QTABLEW_H
#define QTABLEW_H

#include "qframe.h"


class QScrollBar;
class CornerSquare;

class QTableWidget : public QFrame
{
    Q_OBJECT
public:
    void    setBackgroundColor( const QColor & );
protected:
    QTableWidget( QWidget *parent=0, const char *name=0, WFlags f=0 );
   ~QTableWidget();

    void    setNumRows( long );
    void    setNumCols( long );
    long    numRows() const;
    long    numCols() const;

    long    topCell()  const;
    long    leftCell() const;
    long    xOffset()  const { return xOffs; }
    long    yOffset()  const { return yOffs; }

    virtual int cellHeight( long row );
    virtual int cellWidth( long col );
    int     cellHeight() const;
    int     cellWidth() const;
    void    setCellHeight( int );
    void    setCellWidth( int );
    virtual long totalHeight();
    virtual long totalWidth();

    ulong   tableFlags() const;
    void    setTableFlags( ulong f );
    void    clearTableFlags( ulong f = ~0 );
    bool    testTableFlag( ulong f ) const;

    bool    autoUpdate() const;
    void    setAutoUpdate( bool );

    void    updateCell( long row, long column, bool erase=TRUE );

    QRect   windowRect() const;

    long    lastRowVisible() const;
    long    lastColVisible() const;
    
    bool    rowIsVisible( long row ) const;
    bool    colIsVisible( long col ) const;

    void    repaint( bool erase=TRUE );		// repaint table
    void    repaint( int x, int y, int w, int h, bool erase=TRUE );
    void    repaint( const QRect &, bool erase=TRUE );

    void    setXOffset( long x );
    void    setYOffset( long y);
    void    setOffset( long x, long y, bool update = TRUE );

    void    setTopCell( long row );
    void    setLeftCell( long col );
    void    setTopLeftCell( long row, long col ); // Not implemented


private slots:
    void    horSbValue( long val );
    void    horSbSliding( long val );
    void    horSbSlidingDone();
    void    verSbValue( long val );
    void    verSbSliding( long val );
    void    verSbSlidingDone();

protected:    
    virtual void paintCell( QPainter *, long row, long col )=0;
    virtual void setupPainter( QPainter * );

    void    paintEvent( QPaintEvent * );
    void    resizeEvent( QResizeEvent * );

    long    findRow( int yPos ) const;
    long    findCol( int xPos ) const;

    bool    rowYPos( long row, int *xPos ) const;
    bool    colXPos( long col, int *yPos ) const;

    long    maxXOffset();
    long    maxYOffset();
    long    maxColOffset();
    long    maxRowOffset();

    int	    maxWindowX() const;
    int	    maxWindowY() const;
    int	    windowWidth() const;
    int	    windowHeight() const;

    void    scroll( int xPixels, int yPixels );

private:
    void    coverCornerSquare( bool );
    void    snapToGrid( bool horizontal, bool vertical );
    void    setHorScrollBar( bool on, bool update = TRUE );
    void    setVerScrollBar( bool on, bool update = TRUE );
    void    updateWindow();
    long    findRawRow( int yPos, int *cellMaxY, int *cellMinY = 0,
                        bool goOutsideWindow = FALSE ) const;
    long    findRawCol( int xPos, int *cellMaxX, int *cellMinX = 0,
                        bool goOutsideWindow = FALSE ) const;
    int	    maxColsVisible() const;


    void    updateScrollBars( uint = 0 );

    void    doAutoHorScrollBar();
    void    doAutoVerScrollBar();

    long    nRows;
    long    nCols;
    long    xOffs, yOffs;
    long    xCellOffs, yCellOffs;
    short   xCellDelta, yCellDelta;
    short   cellH,
            cellW;
    short   tMargin, bMargin, lMargin, rMargin;

    uint    doUpdate	         : 1;
    uint    eraseInPaint         : 1;
    uint    verSliding           : 1;
    uint    verSnappingOff       : 1;
    uint    horSliding           : 1;
    uint    horSnappingOff       : 1;
    uint    coveringCornerSquare : 1;
    uint    sbDirty	         : 8;
    uint    inSbUpdate		 : 1;

    ulong   tFlags;
    QRect   cellUpdateR;

    QScrollBar   *vScrollBar;
    QScrollBar   *hScrollBar;
    CornerSquare *cornerSquare;
};


const ulong Tbl_vScrollBar         = 0x00000001;
const ulong Tbl_hScrollBar         = 0x00000002;
const ulong Tbl_autoVScrollBar     = 0x00000004;
const ulong Tbl_autoHScrollBar     = 0x00000008;
const ulong Tbl_autoScrollBars     = 0x0000000C;

const ulong Tbl_clipCellPainting   = 0x00000100;
const ulong Tbl_cutCellsV          = 0x00000200;
const ulong Tbl_cutCellsH          = 0x00000400;
const ulong Tbl_cutCells           = 0x00000600;

const ulong Tbl_scrollLastHCell    = 0x00000800;
const ulong Tbl_scrollLastVCell    = 0x00001000;
const ulong Tbl_scrollLastCell     = 0x00001800;

const ulong Tbl_smoothHScrolling   = 0x00002000;
const ulong Tbl_smoothVScrolling   = 0x00004000;
const ulong Tbl_smoothScrolling    = 0x00006000;

const ulong Tbl_snapToHGrid        = 0x00008000;
const ulong Tbl_snapToVGrid        = 0x00010000;
const ulong Tbl_snapToGrid         = 0x00018000;



inline long QTableWidget::numRows() const
{
    return nRows;
}

inline long QTableWidget::numCols() const
{
    return nCols;
}

inline int QTableWidget::cellHeight() const
{
    return cellH;
}

inline int QTableWidget::cellWidth() const
{
    return cellW;
}

inline ulong QTableWidget::tableFlags() const
{
    return tFlags;
}

inline bool QTableWidget::testTableFlag( ulong f ) const
{
    return (tFlags & f) != 0;
}

inline long QTableWidget::topCell() const
{
    return yCellOffs;
}

inline long QTableWidget::leftCell() const
{
    return xCellOffs;
}

inline bool QTableWidget::autoUpdate() const
{
    return doUpdate;
}

inline void QTableWidget::setAutoUpdate( bool b )
{
    doUpdate = b;
}

inline void QTableWidget::repaint( bool erase )
{
    repaint( rect(), erase );
}

inline void QTableWidget::repaint( int x, int y, int w, int h, bool erase )
{
    repaint( QRect(x,y,w,h), erase );
}

#endif // QTABLEW_H
