/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          ninfo.cr                                           */
/*  Author:        P. D. Fox                                          */
/*  Created:       4 Apr 1991                      		      */
/*                                                                    */
/*  Copyright (c) 1990, 1991 Paul Fox                                 */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Ninfo file format display interpreter               */
/*                                                                    */
/*   This  macro  is  used  to  display help/text files in the ninfo  */
/*   format. Ninfo is an nroff version of makeinfo.		      */
/**********************************************************************/

/* SCCS ID: %Z% %M% %R%.%L% */
# include	"crisp.h"

extern list crisp_index;

void
ninfo(string name)
{	string bhelp = getenv("BHELP");

	if (bhelp == "") {
		error("BHELP environment variable not set.");
		return;
		}
	if (name == "")
		name = "user";
	load_macro(bhelp + "/obj/" + name + ".cm");
	do_ninfo(bhelp + "/obj/" + name + ".hlp", crisp_index);

}
/**********************************************************************/
/*   The  filename  parameter  is not used directly by this function  */
/*   but is used when we start recursing.			      */
/**********************************************************************/
void
do_ninfo(string filename, list index_list)
{
	int	i;
	list	lst;
	declare	var;
	string	s;
	int	llen;
	int	list_width;
	list	action_list;
	string spaces = 
"                                                                     ";

	list_width = strlen(index_list, 3);
	llen = length_of_list(index_list);
	for (i = 0; i < llen; i += 3) {
		s = index_list[i];
		var = index_list[i + 2];
		if (is_list(var)) {
			s += substr(spaces, 1, list_width - strlen(s) + 2);
			s += "=>";
			}
		lst += s;
		action_list += "nin_enter";
		}
	select_list("CRISP Help", "Press <Enter> to see information", 1, 
		lst, SEL_NORMAL, NULL, action_list);
}
/**********************************************************************/
/*   Called  when  user  selects  enter. Either go for a sub-menu or  */
/*   give the user the information at the leaf node.		      */
/**********************************************************************/
void
nin_enter()
{	int	line;
	extern list index_list;
	extern string filename;
	declare	var;
	int	buf, win;
	int	num_lines;
	int	curbuf = inq_buffer();
	int	curwin = inq_window();
		
	/***********************************************/
	/*   Found  out  what line we're on so we can  */
	/*   index directly into the list.	       */
	/***********************************************/
	inq_position(line);
	line--;
	var = index_list[line * 3 + 2];
	if (is_list(var)) {
		do_ninfo(filename, var);
		return;
		}
	var = index_list[line * 3 + 1];
	num_lines = index_list[line * 3 + 2];
	/***********************************************/
	/*   We presumably can go and edit the file.   */
	/***********************************************/
	buf = create_buffer(filename, filename, TRUE);
	win = sized_window(num_lines, 70, "<Esc> to return to previous menu.");
	select_buffer(buf, win, NULL, NULL, NULL, NULL, var);
	delete_buffer(buf);
	set_buffer(curbuf);
	set_window(curwin);
	attach_buffer(curbuf);
}
