#ifndef __TURBOC__
#ifndef LINT
static char edtutil_module[] = "@(#)edtutil.c   1.2 12/2/90";
#endif
#endif
/*{{{  includes*/
#include <stdio.h>
#include <ctype.h>
#ifdef __TURBOC__
#include <conio.h>
#endif
#include "inmos.h"
#include "globals.h"
#include "misc.h"
#include "keys.h"
#include "keyboard.h"
#include "screen.h"
#include "edtutil.h"
/*}}}  */
/*{{{  defines*/
#define MAX_FNAME		200
#ifndef __TURBOC__
#define MACRO_FILE		".origamirc"
#else
#define MACRO_FILE		"origami.rc"
#endif
#define MAX_MACRO_LENGTH	4096
#define MAX_MACROS		10
#define TAB_SIZE		8
/*}}}  */
/*{{{  statics*/
static char macros_fname[MAX_FNAME];
static int *macro_strings; /*[MAX_MACROS][MAX_MACRO_LENGTH];*/
static int *macro_lengths; /*[MAX_MACROS];*/
static int * macro_string;
static int tab_size = 0;
/*}}}  */
/*{{{F edtutil.h*/
/*:::F edtutil.h*/
/*}}}  */

/*{{{  void load_macros(void)*/
void load_macros()
{
    char fname[MAX_FNAME];
    int found = 0, i;
    FILE * f;

    /*{{{  allocate macro buffers*/
    if ((macro_strings = (int *)malloc(sizeof(int) * MAX_MACROS * MAX_MACRO_LENGTH)) == NULL) {
        message("not enough memory");
        die_a_quick_death(0,0);
    }
    if ((macro_lengths = (int *)malloc(sizeof(int) * MAX_MACROS)) == NULL) {
        message("not enough memory");
        die_a_quick_death(0,0);
    }
    /*}}}  */
    /*{{{  search in current dir*/
    if (!found) {
        strcpy(fname, ".");
        strcat(fname, FILE_SEPARATOR);
        strcat(fname, MACRO_FILE);
        if ((f = fopen(fname, "r")) != NULL)
            /* found macro file in current dir */
            found++;
    }
    /*}}}  */
    /*{{{  search in home dir*/
    if (!found) {
        strcpy(fname, getenv("HOME"));
        strcat(fname, FILE_SEPARATOR);
        strcat(fname, MACRO_FILE);
        if ((f = fopen(fname, "r")) != NULL)
            /* macro file in home dir */
            found++;
    }
    /*}}}  */
    /*{{{  search in origami home*/
    if (!found) {
        strcpy(fname, getenv("ORIGAMIHOME"));
        strcat(fname, FILE_SEPARATOR);
        strcat(fname, MACRO_FILE);
        if (!found && (f = fopen(fname, "r")) != NULL)
            /* macro file in origami home dir */
            found++;
    }
    /*}}}  */
    if (!found) {
        /* no macro file found */
        strcpy(macros_fname, "");
        return;
    }
    strcpy(macros_fname, fname);
    for (i = 0; i < MAX_MACROS; i++) {
        int j;

        fscanf(f, "%d", &macro_lengths[i]);
        for (j = 0; j < macro_lengths[i]; j++)
            fscanf(f, "%d", &(macro_strings[(i*MAX_MACRO_LENGTH) + j]));
    }
}
/*}}}  */
/*{{{  void store_macros(void)*/
void store_macros()
{
    FILE * f;
    int i, j;

    /* if found, the filename is stored in 'macros_fname' */
    if (*macros_fname && ((f = fopen(macros_fname, "w")) != NULL)) {
        for (i = 0; i < MAX_MACROS; i++) {
            fprintf(f, "%d", macro_lengths[i]);
            for (j = 0; j < macro_lengths[i]; j++)
                fprintf(f, " %d", macro_strings[(i*MAX_MACRO_LENGTH) + j]);
            fprintf(f, "\n");
        }
    }
}
/*}}}  */
/*{{{  char upper(char ch)*/
char upper(ch)
int ch;
{
        return (islower(ch)? toupper(ch) :ch);
}
/*}}}  */
/*{{{  void pad_(char *s,int ch,int l)*/
void pad_(s, ch, l)
char *s;
int ch, l;
{
int i;

        i = strlen(s);
        s[l] = '\0';
        for (; i < l; i++)
                s[i] = (char)ch;
}
/*}}}  */
/*{{{  char *spaces(char *Result,int l)*/
char *spaces(Result, l)
char *Result;
int l;
{
int i;

        Result[l] = '\0';
        for (i = 0; i < l; i++)
                Result[i] = ' ';

        return Result;
}
/*}}}  */
/*{{{  void colour(int n)*/
void colour(n)
int n;
{
#ifdef __TURBOC__
  switch (n) {
    case 0:
      textcolor(LIGHTGRAY);
      textbackground(BLACK);
      break;

    case 1:
      textcolor(YELLOW);
      textbackground(BLUE);
      break;

    case 2:
      textcolor(WHITE);
      textbackground(BLUE);
      break;

    case 3:
      textcolor(RED);
      textbackground(LIGHTGRAY);
      break;

    case 4:
      textcolor(YELLOW);
      textbackground(BLUE);
      break;
}
#endif
}
/*}}}  */
/*{{{  void press(int ch,BOOL keypad)*/
void press(ch, keypad)
int ch;
BOOL keypad;
{
        key_already_pressed = TRUE;
        already_pressed_key = (char)ch;
        already_pressed_keypad_key = keypad;
}
/*}}}  */
/*{{{  void message(char *s)*/
void message(s)
char *s;
{
int i;

        colour(3);
        Gotoxy(1, MESSAGE_LINE);
        if (screen_message) {
                Clreol();
        }
        Gotoxy(10, MESSAGE_LINE);

        printf("%s", s);
        for (i=strlen(s)+10;i<80;i++) {
                (void) printf(" ");
        }
        Gotoxy(10+strlen(s), MESSAGE_LINE);
        colour(3);
        screen_message = TRUE;
}
/*}}}  */
/*{{{  void no_message(void)*/
void no_message()
{
int i;

        if (screen_message) {
                colour(3);
                Gotoxy(10, MESSAGE_LINE);
                for (i=10;i<80;i++) {
                        (void) printf(" ");
                }
                Gotoxy(10, MESSAGE_LINE);
                colour(1);
                screen_message = FALSE;
        }
        if (defining_macro)
                message("Defining macro");
}
/*}}}  */
/*{{{  int single_key(void)*/
int single_key()
{
int ch;
static macro_count,macro_length, macro;
char line[3];

        if (executing_macro) {
                if (macro_count ==  macro_length) {
                        macro_count = 0;
                        executing_macro = FALSE;
                        ch = get_key();
                }
                else
                        ch = macro_string[macro_count++];
        }
        else {
                ch = get_key();
                /*{{{  COMMENT debug statements*/
                /*if (ch == 'e') ch = O_ENTER_FOLD;*/
                /*if (ch == 'x') ch = O_EXIT_FOLD;*/
                /*}}}  */
        }
        switch (ch) {
                case O_DEFINE_MACRO:
                        defining_macro = !defining_macro;
                        if (defining_macro) {
                                /* started defining macro */
                                *line = '\0';
                                defining_macro = 0; /* don't record keys */
                                readprompt(line, "Which macro:", 1);
                                sscanf(line, "%d", &macro);
                                defining_macro++;   /* start recording */
                                macro_string = macro_strings + (macro * MAX_MACRO_LENGTH);
                                macro_count = 0;
                                macro_length = 0;
                        }
                        else {
                                /* ended started defining macro */
                                macro_lengths[macro] = macro_length;
                        }
                        break;
                case O_EXECUTE_MACRO:
                        if (!defining_macro) {
                                *line = '\0';
                                (void)readprompt(line, "Which macro:", 1);
                                sscanf(line, "%d", &macro);
                                macro_string = macro_strings + (macro * MAX_MACRO_LENGTH);
                                macro_length = macro_lengths[macro];
                                executing_macro = TRUE;
                        }
                        break;

                default:
                        if (defining_macro) {
                                macro_string[macro_length++] = ch;
                                if (macro_length == MAX_MACRO_LENGTH) {
                                        macro_lengths[macro] = macro_length;
                                        defining_macro = FALSE;
                                }
                        }
                        break;
        }
        return ch;
}
/*}}}  */
/*{{{  int edit_key(BOOL *keypad)*/
int  edit_key(keypad)
BOOL *keypad;
{
int ch;

        if (key_already_pressed) {
                key_already_pressed = FALSE;
                *keypad = already_pressed_keypad_key;
                return already_pressed_key;
        }
/* get valid key */
        /*do {*/
                ch = single_key();
        /*} while (ch < 32 || ch == 127);*/

        if (ch > 255)
                *keypad = TRUE;
        else
                *keypad = FALSE;

        return ch;
}
/*}}}  */
/*{{{  char *readprompt(char *Result,char *prompt,int max)*/
char *readprompt(Result, prompt, max)
char *Result, *prompt;
int max;
{
char s[65];
int ch;
char STR1[MAX_FIELD_SIZE];
BOOL running;

        (void) sprintf(STR1, "%s ? ", prompt);
        message(STR1);
        colour(3);
        *s = '\0';

        running = TRUE;
        do {
                ch = single_key();
                if (ch < 127) {
                        printf("%c", ch);
                        (void) sprintf(s + strlen(s), "%c", ch);
                }
                else if (ch == O_DELETE) {
                        if (strlen(s)) {
                                s[strlen(s) - 1] = '\0';
                                Gotoxy(strlen(prompt) + strlen(s) + 13, MESSAGE_LINE);
                                printf(" ");
                                Gotoxy(strlen(prompt) + strlen(s) + 13, MESSAGE_LINE);
                        }
                }
                else
                        running = FALSE;
        } while (strlen(s) < max && running);

        switch (ch) {
                case O_UP:
                        backup = TRUE;
                        break;
                case O_DOWN:
                        backup = FALSE;
                        break;
                default:
                        break;
        }

        strcpy(Result, s);
        colour(1);
        return Result;
}
/*}}}  */
/*{{{  BOOL yes(char *q)*/
BOOL yes(q)
char *q;
{
  char temp[33];
  BOOL y, yes_or_no;

  y = FALSE;
  yes_or_no = FALSE;
  do {
    (void) readprompt(temp, q, 6);
    /* p2c: termkey.pas, line 278:
     * Note: Possible string truncation in assignment [145]
     */
    if (*temp != '\0') {
        temp[0] = upper(temp[0]);
      y = (temp[0] == 'Y');
      yes_or_no = (y || temp[0] == 'N');
    }
  } while (!yes_or_no);
  return y;
}
/*}}}  */
/*{{{  char *upper_case(char *Result,char *s_)*/
char *upper_case(Result, s_)
char *Result, *s_;
{
  char s[MAX_FIELD_SIZE + 1];
  int i, FORLIM;

  strcpy(s, s_);
  FORLIM = strlen(s);
  for (i = 0; i < FORLIM; i++)
        s[i] = upper(s[i]);
  return strcpy(Result, s);
}
/*}}}  */
/*{{{  char *tabbed_out(char *Result,char *instr)*/
char *tabbed_out(Result, instr)
char *Result, *instr;
{
  /*{{{  COMMENT*/
  /*uchar j, i;*/
  /*uchar FORLIM;*/
  /*char STR1[65];*/
  /**/
  /*j = 0;*/
  /*FORLIM = strlen(instr);*/
  /*for (i = 0; i < FORLIM; i++) {*/
    /*if (instr[i] == '\t') {*/
      /*while (tab_size <= 0)*/
        /*sscanf(readprompt(STR1, "Tab size", 10), "%d", &tab_size);*/
      /*do {*/
        /*j++;*/
        /*Result[j - 1] = ' ';*/
      /*} while (j % tab_size != 0);*/
    /*}*/
    /*else {*/
      /*j++;*/
      /*Result[j - 1] = instr[i];*/
    /*}*/
  /*}*/
  /*Result[j] = '\0';*/
  /*return Result;*/
  /*}}}  */
  return strcpy(Result, instr);
}
/*}}}  */
/*{{{  void set_tabsize(void)*/
void set_tabsize()
{
  char *s;

  tab_size = TAB_SIZE;
  if ((s = getenv("TAB")) != NULL)
    sscanf(s, "%d", &tab_size);
}
/*}}}  */
/*{{{  BOOL valid_key(BOOL *keypad,int *ch)*/
BOOL valid_key(keypad, ch)
BOOL *keypad;
int *ch;
{
BOOL valid,browse_key;

        valid = TRUE;

        browse_key = (*keypad && key_convert_list[*ch - 256][1]) && (*ch > 255);
        if (browse_mode) {
                valid = browse_key;
                if (!valid)
                        message("browse mode!");
        }

        if (valid)
                file_changed = (file_changed || !browse_key);

        return valid;
}
/*}}}  */
/*{{{  BOOL valid_field_key(BOOL *keypad,int *ch)*/
BOOL valid_field_key(keypad, ch)
BOOL *keypad;
int *ch;
{
BOOL valid;

        if (*keypad)
                valid = (key_convert_list[*ch - 256][0]);
        else
                valid = TRUE;

        return valid;
}
/*}}}  */
/*{{{  char *expand_tabs(char *out, *in)*/
char *expand_tabs(out, in)
char *out, *in;
{
    int i, j;

    for (i = 0, j = 0; i < strlen(in); i++) {
        if (in[i] != '\t')
            out[j++] = in[i];
        else {
            do {
                out[j++] = ' ';
            } while (j % tab_size);
        }
    }
    out[j++] = '\0';

    return out;
}
/*}}}  */
/*{{{  int str_length(int n, char *str)*/
int str_length(n, str)
int  n;
char *str;
{
    int i,
        str_len = strlen(str),
        len = 0;

    for (i = 0; i < n-1 && i < str_len; i++)
        len += (str[i] == '\t')? (tab_size - (len % tab_size)) : 1;
    if ((n-1) > str_len)
        len += (n-1) - str_len;

    return len+1;
}
/*}}}  */
/*{{{  int ch_length(int n)*/
int ch_length(n)
int n;
{
    return (n == '\t') ? tab_size : 1;
}
/*}}}  */
