#ifndef __TURBOC__
#ifndef LINT
static char procexit_module[] = "@(#)procexit.c 1.2 12/2/90";
#endif
#endif

/*{{{  includes*/
#include <stdio.h>
#include <ctype.h>
#include "inmos.h"
#include "globals.h"
#include "misc.h"
#include "oriedt.h"
#include "edtutil.h"
#include "filer.h"
#include "macros.h"
#include "procexit.h"
/*}}}  */
/*{{{  extern*/
extern int bfile_no;
extern buffer buff;
/*}}}  */
/*{{{  defines*/
#ifdef __TURBOC__
#  define COPY_CMD "copy %s %s.bak > nul:"
#else
#  define COPY_CMD "cp %s %s.bak > /dev/null"
#endif
/*}}}  */
/*{{{  prototypes*/
PRIVATE void write_b P((int, LOC_proc *));
PRIVATE void write_tag P((int, int, LOC_proc *));
PRIVATE void write_string P((char *, LOC_proc *));
PRIVATE void write_header P((LOC_proc *));
PRIVATE void move_on_full P((element **));
PRIVATE void write_a_list P((LOC_proc *));
PRIVATE void write_tds P((LOC_proc *));
PRIVATE void make_backup P((char *));
/*}}}  */
/*{{{F procexit.h*/
/*:::F procexit.h*/
/*}}}  */

/*{{{  PRIVATE void write_b(int b,LOC_proc *LINK)*/
PRIVATE void write_b(b, LINK)
int b;
LOC_proc *LINK;
{
  buff[bfile_no] = b;
  bfile_no++;
  if (bfile_no != 512)
    return;
  bfile_no = fwrite((char *)buff, 1, sizeof(char) * 512, LINK->tdsfile);
  P_ioresult = 0;
  bfile_no = 0;
}
/*}}}  */
/*{{{  PRIVATE void write_tag(int tag,int value,LOC_proc *LINK)*/
PRIVATE void write_tag(tag, value, LINK)
int tag, value;
LOC_proc *LINK;
{
  if (value > 63)
    write_b((char)(((unsigned)value) >> 6) + 192, LINK);
  write_b((char)((tag << 6) + (value & 63)), LINK);
}
/*}}}  */
/*{{{  PRIVATE void write_string(char *s,LOC_proc *LINK)*/
PRIVATE void write_string(s, LINK)
char *s;
LOC_proc *LINK;
{
  int i, len;
  char line[MAX_FIELD_SIZE + 1];

  expand_tabs(line, s);
  len = strlen(line);
  write_tag(0, len, LINK);
  for (i = 0; i < len; i++)
    write_b(line[i], LINK);
}
/*}}}  */
/*{{{  PRIVATE void write_header(LOC_proc *LINK)*/
PRIVATE void write_header(LINK)
LOC_proc *LINK;
{
  write_tag(2, 0, LINK);   /*startlist*/
  write_string(LINK->dsp_line, LINK);
  write_tag(1, (int)LINK->p->UU.U1.fold_type, LINK);
  if (strncmp(skip_spaces(LINK->dsp_line), COMMENT_MSG, strlen(COMMENT_MSG)) == 0)
    /* comment fold */
    write_tag(1, 0, LINK);
  else
    write_tag(1, (int)LINK->p->UU.U1.fold_contents, LINK);
  write_tag(1, (int)LINK->p->UU.U1.fold_indent, LINK);
  write_tag(2, 1, LINK);   /*endlist*/
}
/*}}}  */
/*{{{  PRIVATE void move_on_full(element **p)*/
PRIVATE void move_on_full(p)
element **p;
{
  if (filed_or_fold(*p))
    *p = (*p)->fold;
  else
    *p = (*p)->next;
}
/*}}}  */
/*{{{  PRIVATE void write_a_list(LOC_proc *LINK)*/
PRIVATE void write_a_list(LINK)
LOC_proc *LINK;
{
  char STR1[MAX_FIELD_SIZE + 1];

  write_tag(2, 0, LINK); /* start list */
  while (LINK->pn->foldline != END_FOLD) {
    LINK->p = LINK->pn;
    move_on_full(&LINK->pn);
    copy_parts_to_line(LINK->p, LINK->dsp_line);
    trailing_spaces(LINK->dsp_line);
    if (LINK->p->foldline == NOT_FOLD) write_string(LINK->dsp_line, LINK);
    if (LINK->p->foldline == START_FOLD || LINK->p->foldline == START_OPEN_FOLD) {
      write_tag(2, 2, LINK); /* start fold */
      write_header(LINK);
      write_a_list(LINK);
      write_tag(2, 3, LINK);   /*endfold*/
      continue;
    }
    if (LINK->p->foldline != START_FILED) continue;
    write_tag(2, 4, LINK);
    write_header(LINK);
    write_string((char *)line_of(STR1, LINK->p->other_end), LINK);
    write_tag(2, 5, LINK);   /*endfiled*/
    move_on_full(&LINK->pn);
  }
  write_tag(2, 1, LINK);
  if (LINK->pn->foldline == END_FOLD)
    move_on_full(&LINK->pn);
}
/*}}}  */
/*{{{  PRIVATE void write_tds(LOC_proc *LINK)*/
PRIVATE void write_tds(LINK)
LOC_proc *LINK;
{
  char STR1[MAX_FIELD_SIZE + 1];

  strcpy(LINK->tdsfile_NAME, line_of(STR1, LINK->file_ptr));
  if (LINK->tdsfile != NULL)
    LINK->tdsfile = freopen(LINK->tdsfile_NAME, "wb", LINK->tdsfile);
  else
    LINK->tdsfile = fopen(LINK->tdsfile_NAME, "wb");
  if (LINK->tdsfile == NULL) P_ioresult=FileNotFound;
  else P_ioresult=0;
  bfile_no = 0;
  write_a_list(LINK);
  if (bfile_no > 0) {
    bfile_no = fwrite((char *)buff, 1, bfile_no, LINK->tdsfile);
    P_ioresult = 0;
  }
  /* p2c: edtio.pas, line 467:
   * Note: Can't interpret size in BLOCKWRITE [174]
   */
  if (LINK->tdsfile != NULL)
    (void) fclose(LINK->tdsfile);
  LINK->tdsfile = NULL;
}
/*}}}  */
/*{{{  PRIVATE void make_backup(char * fname)*/
PRIVATE void make_backup(fname)
char * fname;
{
    char * base_name, *p;
    char cmd_line[256];
    FILE *f;

    if ((f = fopen(fname, "r")) == NULL)
        fclose(f);
    else {
        if ((base_name = (char *)malloc(strlen(fname) + 1)) == NULL) {
            fprintf(stderr, "not enough memory\n");
            die_a_quick_death(0, 0);
        }
        strcpy(base_name, fname);
        p = base_name;
        while (*p && *p != '.')
            p++;
        *p = '\0';
        sprintf(cmd_line, COPY_CMD, fname, base_name);
#ifndef __DEBUGGING__
        system(cmd_line);
#endif
    }
}
/*}}}  */
/*{{{  void proc_exit(element *file_ptr_,element *from_ptr)*/
void proc_exit(file_ptr_, from_ptr)
element *file_ptr_, *from_ptr;
{
  LOC_proc V;
  char filename[65];
  char STR1[MAX_FIELD_SIZE + 1];
  char STR2[MAX_FIELD_SIZE + 1];
  char STR3[MAX_FIELD_SIZE + 1];
  char STR6[80];
  char *full_name;
  char braces[7];
  int comment_fold = 0;

  /*{{{  initialize*/
  V.file_ptr = file_ptr_;
  V.tdsfile = NULL;
  V.pn = from_ptr;
  move_on(&V.pn);
  current_ind = 0;
  (void) line_of(filename, V.file_ptr);
  /* p2c: edtio.pas, line 476:
   * Note: Possible string truncation in assignment [145]
   */
  full_name = file_info(filename);
  /*}}}  */
  if (can_open) {
    if (! backup_file_made) {
        backup_file_made++;
        make_backup(filename);
    }
    sprintf(STR1, "Saving %s", full_name);
    message(STR1);
    if (dialect < NO_LANGUAGES) {   /*ie not tds*/
      strcpy(tstorefile_NAME, filename);
      if (tstorefile != NULL)
        tstorefile = freopen(full_name, "w", tstorefile);
      else
        tstorefile = fopen(full_name, "w");
      if (tstorefile == NULL) P_ioresult=FileNotFound;
      else P_ioresult=0;
      strcpy(braces, "{{{");
      strcat(braces, "}}}");
      if (dialect == NO_LANGUAGES - 1) {
        if (fprintf(tstorefile, "%s%s%s\n",
                       dialect_start[dialect], braces,
                       dialect_end[dialect]) < 0) P_ioresult=FileWriteError;
        else P_ioresult=0;
      }
      while (V.pn != from_ptr->other_end) {   /*tail*/
        V.p = V.pn;
        copyin(V.dsp_line, V.p, TRUE);
        trailing_spaces(V.dsp_line);
        if (current_ind > 0)
          strinsert(spaces(STR2, current_ind), V.dsp_line, 1);
        if (dialect == fortran_ && (V.p->foldline != NOT_FOLD ||
              strpos2(line_of(STR3, V.p), "C ", 1) == 1))
          V.dsp_line[0] = 'C';
        if (comment_fold && !(filed_or_fold(V.p) || V.p->foldline == END_FOLD)) {
          char *s = skip_spaces(V.dsp_line);
          int l = (int) (s - V.dsp_line);

          strncpy(STR1, V.dsp_line, l);
          strcpy(STR1 + l, dialect_start[dialect]);
          strcat(STR1, V.dsp_line + l);
          strcat(STR1, dialect_end[dialect]);
          fprintf(tstorefile, "%s\n", STR1);
        }
        else
          fprintf(tstorefile, "%s\n", V.dsp_line);
        if (filed_or_fold(V.p))
          current_ind += total_indent(V.p);
        if (filed_or_fold(V.p) || V.p->foldline == START_OPEN_FOLD) {
          char *s = skip_spaces(V.dsp_line);

          if (comment_fold ||
              strncmp(s + strlen(dialect_start[dialect]) + 5,
                      COMMENT_MSG, strlen(COMMENT_MSG)) == 0)
            comment_fold++;
          if (dialect >= 0) {
            sprintf(V.dsp_line, "%s%s:::",
                    spaces(STR2, current_ind), dialect_start[dialect]);
            if (dialect == fortran_)
              V.dsp_line[0] = 'C';
            if (!normal_att(V.p)) {
              if (fprintf(tstorefile, "%sA %2d %d%s\n",
                     V.dsp_line, V.p->UU.U1.fold_type,
                     V.p->UU.U1.fold_contents,
                     dialect_end[dialect]) < 0) P_ioresult=FileWriteError;
              else P_ioresult=0;
            }
            if (V.p->foldline == START_FILED) {
              if (fprintf(tstorefile, "%sF %s%s\n",
                     V.dsp_line, line_of(STR3, V.p->other_end),
                     dialect_end[dialect]) < 0) P_ioresult=FileWriteError;
              else P_ioresult=0;
            }
          }
          if (V.p->UU.U1.fold_type == 1 && V.p->foldline == START_FILED) {
            current_ind -= total_indent(V.p);
            V.pn = V.p->other_end;
          }
        }
        move_on_full(&V.pn);
        if (V.p->foldline == END_FOLD) {
          if (comment_fold)
            comment_fold--;
          if (filed_or_fold(V.p->other_end))
            current_ind -= total_indent(V.p->other_end);
        }
      }
      if (tstorefile != NULL)
        (void) fclose(tstorefile);
      tstorefile = NULL;
    }
    else
      write_tds(&V);
  }
  else {
    sprintf(STR6, "Error opening %s", full_name);
    message(STR6);
  }
  if (V.tdsfile != NULL)
    (void) fclose(V.tdsfile);
}
/*}}}  */
