/*
 *  user2.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <strstream.h>
#include <string.h>
#include <ctype.h>
#include <Integer.h>
#include <stdio.h>
 
#include "outtok.h"
#include "baseio.h"
#include "usercom.h"
#include "yacintfc.h"
#include "interp.h"

#include "myfloat.h"
#include "dspe_app.h"

#include "intfc.h"
#include "user.h"
#include "array.h"
#include "cgidbg.h"
#include "dspguicom.h"
#include "mkstr.h"

void Fout(OutTokens& Out, double value)
{
	char buf[BufSize];
	sprintf(buf,FloatFormat(value),value);
	Out.NextFillOut(buf);
}

void IntParam::ListValue(OneParameter& Parent, OutTokens& Out)
{
	char buf[BufSize];
	Out.NextFillOut("The value is");
	Out.NextFillOut(strcpy(buf,dec(CurrentValue)));
	Out.NextConcat(".");
	Out.NewLine();
}

void IntParam::List(OneParameter& Parent, OutTokens& Out)
{
	char buf[BufSize];
	Out.NextFillOut("The default value is");
	Out.NextFillOut(strcpy(buf,dec(Default)));
	Out.NextConcat(",");
	Out.NextFillOut("this parameter must be");
	if (CheckLower) 
		CheckLower->GetBound(CheckActionDescribe,Parent,
			CheckLower->List, &Out);
	else {
		Out.NextFillOut(">=");
		Out.NextFillOut(strcpy(buf,dec(Lower)));
		Out.NextFillOut("and");
	}
	if (CheckUpper) 
		CheckUpper->GetBound(CheckActionDescribe,Parent,
			CheckUpper->List, &Out);
	else {
		Out.NextFillOut("<=");
		Out.NextFillOut(strcpy(buf,dec(Upper)));
		Out.NextConcat(".");
	}
}

void StringParam::ListValue(OutTokens& Out)
{
	Out.NextFillOut("The value is");
	Out.NextQuoteOut(CurrentValue);
	Out.NextConcat(".");
	Out.NewLine();
}


void StringParam::List(OutTokens& Out, int NumEntitys)
{
	if (MakeString) {
		Out.NextFillOut("The default name is the class name") ;
		Out.NextFillOut(MakeString(0,0));
		Out.NextConcat(".");
	}
	Out.NextFillOut("The default value is");
	if (MakeString) {
		const char * LocalDefault = MakeString(Default,NumEntitys) ;
		Out.NextQuoteOut(LocalDefault);
		delete (char *) LocalDefault ;
	} else Out.NextQuoteOut(Default);
	Out.NextConcat(".");
	if (Legal) {
		Out.NextFillOut(
			"This string must ");
		Out.NextFillOut(Legal(0));
		Out.NextConcat(".");
	}
	Out.NewLine() ;
}

void FloatParam::ListValue(OneParameter& Parent,OutTokens& Out)
{
	Out.NextFillOut("The value is");
	Fout(Out,CurrentValue);
	Out.NextConcat(".");
	Out.NewLine();
}


void FloatParam::List(OneParameter& Parent,OutTokens& Out)
{
	Out.NextFillOut("The default value is");
	Fout(Out,Default);
	Out.NextConcat(",");
	Out.NextFillOut("this parameter must be");
	if (CheckLower) 
		CheckLower->GetBound(CheckActionDescribe,Parent,
			CheckLower->List, &Out);
	else {
		Out.NextFillOut(">=");
		Fout(Out,Lower);
		Out.NextFillOut("and");
	}
	if (CheckUpper) 
		CheckUpper->GetBound(CheckActionDescribe,Parent,
			CheckUpper->List, &Out);
	else {
		Out.NextFillOut("<=");
		Fout(Out,Upper);
		Out.NextConcat(".");
	}
}

static UserEntity * GetEntityFromName(const char * CurrentName)
{
	ValueType * Declarator = AllEntityLists->GetType(CurrentName) ;
	if (!Declarator) return 0;
	ValueType * Declared =
		Declarator->Declared.EntityClass->FindObj(CurrentName);
	if (!Declared) return 0;
	if (Declared->Type != DecEnt) return 0;
	return Declared->Value.ValEnt ;
}

static int NotNull(const char * Str)
{
	if (!Str) return 0;
	return *Str ;
}

// consider equal if only one ends in '&' 
int strobjcmp(const char * str1, const char * str2)
{
	// LogOut << "strobjcmp(" << str1 << "," << str2 << ")\n" ;
	if (!strcmp(str1,str2)) return 0 ;
	int l1 = strlen(str1);
	int l2 = strlen(str2);
	if (l2 == l1 + 1) {
		const char * temp = str1 ;
		str1 = str2;
		str2 = temp;
		l1++ ;
		l2--;
	} else if (l1 != l2 + 1) return 1;	
	if (str1[l2] != '&') return 1 ;
	return strncmp(str1,str2,l2);
}

InteractiveEntity * GetBaseType(InteractiveEntity * FoundClass,
	const char * DesiredClass)
{
	// LogOut << "GetBaseType - looking for: " << DesiredClass << "\n" ;
	for (InteractiveEntity * IntEnt = FoundClass; IntEnt;
		IntEnt = IntEnt->GetBaseEntity()) {
		// LogOut << "Checking " << IntEnt->GetClassName() << "\n" ;
		if (!strobjcmp(IntEnt->GetClassName(),DesiredClass))
			return IntEnt;
/*
 *		LogOut << "Checking " <<
 *			IntEnt->GetBaseClass()->GetBaseClassName() << "\n" ;
 */
		if (!strobjcmp(IntEnt->GetBaseClass()->GetBaseClassName(),
			DesiredClass)) return IntEnt ;
	}
	return 0 ;
}


UserEntity * EntityParam::GetParameter( const char * Name, OneParameter& Parent,
		ValueType * Val,int index, UserEntity * TheObject)
{
	// LogOut << "EntityParam::GetParameter\n" ;
	if (!State.IsInteractive() && !Val) {
		CurrentValue = 0 ;
		State.Error("missing parameter");
		return  0;
	}
	int TriedDefault = 0;
	if (!Val) {
		// LogOut << "ComputeDefault = " << (void *) ComputeDefault << "\n" ;
		if (ComputeDefault) DefaultValue = (*ComputeDefault)(TheObject);
		if (NotNull(DefaultValue)) *Output + OutputPrompt << 
			DspGuiCommon::default_prefix <<
			DefaultValue << ") or enter" ;
		else {
			*Output + OutputPrompt << "Enter RETURN to abort or" ;
			TriedDefault = 1 ;
		}
		*Output + OutputPrompt << " a `" <<  EntityClass <<
			"' for `" << Name  << "':\n" ;
		// LogOut << "did prompt, DefaultValue = " << DefaultValue << "\n" ;
	}
	int Flag = Val != 0 ;
	for (;;) {
		char Buf[BufSize] ;
		char * CurrentName = Buf ;
		int OK=1;
		char * RawBuf ;
		if (!Flag) {
			RawBuf = GetRawBufLine(InputPrompt) ;
			Buf[0] = *RawBuf ;
			if (!Buf[0]) {
				if (TriedDefault) return 0;
				if (!CurrentValue) {
					// LogOut << "!CurrentValue - GetDefaultParameter\n" ;
					GetDefaultParameter(TheObject);
					if (DefaultValue) strcpy(Buf,DefaultValue) ;
				} else return 0;
				TriedDefault = 1 ;
			} else {
				if (RawBuf[0] == '\03') {
					State.Error("user aborted input");
					return 0 ;
				}
				istrstream Temp(RawBuf,BufSize-1);
				memset(Buf,'\0',BufSize);
				Temp >> Buf;  
				if (Temp.bad()) {
					*Output + OutputPrompt <<
					"Invalid C++ string input: `" <<
						RawBuf << "'.\n" ;
					OK=0;
				}
			}
		} else {
			const char * name = Val->Value.ValEnt->GetName();
			*Buf = '\0' ;
			CurrentName = Buf ;
			if (name) strcpy(Buf, Val->Value.ValEnt->GetName()) ;
		}
		if (OK) {
 			ValueType * Declarator =
				AllEntityLists->GetType(CurrentName) ;
			if (!Declarator) {
				*Output + OutputPrompt <<
				"There is no object `" <<
				CurrentName << "' declared.\n" ;
				OK = 0;
			} else {
				int BadType = 0 ;
				if (Declarator->Class != DoDeclEntity)
					BadType = 1;

				InteractiveEntity * IntEnt = 0 ;
				if (!BadType) IntEnt = GetBaseType(
					Declarator->Declared.EntityClass,
					EntityClass) ;
				if (!IntEnt) BadType=1 ; 
				if (BadType) {
					OK=0;
					*Output + OutputPrompt << "`" <<
					CurrentName <<
					"' is not declared as a `" <<
					EntityClass << "'.\n" ;
				}
			}
			if (OK) {
				UserEntity*ret=GetEntityFromName(CurrentName) ;
				if (!ret) OK= 0 ;
				else if (Legal) if (!Legal(ret)) OK = 0;
				if (OK) return CurrentValue = ret;
				OK = 0;
			}
			if (Legal) {
				*Output + OutputPrompt << "Parameter `" <<
				Name << "' must " 
				<< Legal(0) << ". `" << CurrentName <<
				"' is not valid.\n" ;
			}
			if (!State.IsInteractive()) {
				State.Error("bad parameter");
				return 0 ;
			}
			Flag = 0 ;
		}
		if (NotNull(DefaultValue) && !TriedDefault)
			*Output + OutputPrompt << DspGuiCommon::default_prefix
				<< DefaultValue << ")\n" ;
		else *Output + OutputPrompt << "Type RETURN to abort\n" ;
		*Output + OutputPrompt << "or select a new `" << EntityClass <<
			"' for `" << Name  << "'" ;
		if (index) *Output + OutputPrompt << " parameter " <<
			dec(index) ;
		 *Output + OutputPrompt << ":\n" ;
	}
}


void EntityParam::ListValue(OutTokens& Out )
{
	Out.NextFillOut("The value is") ;
	if (!CurrentValue) Out.NextOut("NULL");
	else Out.NextQuoteOut(CurrentValue->GetName());
	Out.NextConcat(".");
}

void EntityParam::List(OutTokens& Out,int )
{
	Out.NextFillOut("The default") ;
	Out.NextQuoteOut(EntityClass) ;
	Out.NextFillOut("for") ;
	Out.NextFillOut("this parameter is");
	if (ComputeDefault) Out.NextFillOut(ComputeDefault(0));
	else if (DefaultValue) Out.NextQuoteOut(DefaultValue);
	Out.NextConcat(".");
	if (Legal) {
		Out.NextFillOut("This");
		Out.NextQuoteOut(EntityClass);
		Out.NextFillOut("must");
		Out.NextFillOut(Legal(0));
		Out.NextConcat(".");
	}
	Out.NewLine() ;
}

void IntParam::GetParameter(const char *Name, OneParameter& Parent,
	ValueType *Val,int index)
{
	if (!State.IsInteractive() && !Val) {
		CurrentValue = 0 ;
		State.Error("missing parameter");
		return ;
	}
	if (!Val) *Output + OutputPrompt << DspGuiCommon::default_prefix <<
		Default << DspGuiCommon::default_suffix << Name << "':\n" ;
/*
 *	if (!Val) *Output + OutputPrompt<<"Specify value of `"<<Name << "' ("
 *		<< Default << "):\n" ;
 */
	int Flag = Val != 0 ;
	// LogForm("IntParam::GetParameter, Flag = %d", Flag);
	for (;;) {
		double test_value = 0 ;
		int OK=1;
		if (!Flag) {
			char * RawBuf = GetRawBufLine(InputPrompt) ;
			// LogMsg("IntParam::GetParameter: RawBuf", RawBuf);
			if (!*RawBuf) test_value = Default ;
			else {
				if (RawBuf[0] == '\03') {
					State.Error("user aborted input");
					return ;
				}
				switch (DspApplication::read_variable(RawBuf,test_value)) {
case -1 : OK = 0 ;
					break ;
case 1:
					break ;
case 0:
					{

						istrstream Temp(RawBuf,BufSize-1);
						Temp >> CurrentValue ;
						test_value = CurrentValue ;
						if(!Temp.good())  {
							*Output + OutputPrompt <<
								"Invalid integer input: `" <<
							RawBuf << "'.\n" ;
							OK=0;
						}
					}
				}
			}
		} else test_value = Val->Value.ValInt ;
		if (OK) if (test_value >= TheLowerBound(Parent) &&
			test_value <= TheUpperBound(Parent)) {
			CurrentValue = (int) test_value  ;
			return ;
		} else *Output + OutputPrompt << "Value specified for parameter `"
			<< Name << "' (" << test_value
			<< ") is out of range.\n" ;
		if (!State.IsInteractive()) {
			State.Error("bad parameter");
			return ;
		}
		*Output + OutputPrompt <<
			DspGuiCommon::default_prefix <<
			Default << DspGuiCommon::default_suffix << Name ;
			if (index) *Output + OutputPrompt <<
			"', parameter " << dec(index) << "," ;
			else *Output + OutputPrompt << "'" ;
			*Output + OutputPrompt << " or\n" <<
			"specify an integer value >= " <<
			TheLowerBound(Parent) << " and <= " <<
			TheUpperBound(Parent) << ":\n" ;
		Flag = 0;
	}
}

void FloatParam::GetParameter(const char *Name, OneParameter& Parent,
	ValueType *Val,int index)
{
	if (!State.IsInteractive() && !Val) {
		CurrentValue = 0 ;
		State.Error("missing parameter");
		return ;
	}
	if (!Val) *Output + OutputPrompt << DspGuiCommon::default_prefix <<
		Default << DspGuiCommon::default_suffix << Name << "':\n" ;
/*
 *	if (!Val) *Output + OutputPrompt << "Specify value of `" << Name
 *		<< "' (" << Default << "):\n" ;
 */
	int Flag = Val != 0;
	for (;;) {
		double test_value = 0 ;
		int OK=1;
		if (!Flag) {
			char * RawBuf = GetRawBufLine(InputPrompt) ;
			if (!*RawBuf) test_value = Default ;
			else {
				if (RawBuf[0] == '\03') {
					State.Error("user aborted input");
					return ;
				}
switch (DspApplication::read_variable(RawBuf,test_value)) {
case -1 : OK = 0 ;
                    break ;
case 1:
                    break ;
case 0:
                    {
						istrstream Temp(RawBuf,BufSize-1);
						Temp >> CurrentValue ;
						test_value = CurrentValue ;
						if(!Temp.good()) {
							*Output + OutputPrompt <<
							"Invalid floating point input: `"
								<< RawBuf << "'.\n" ;
							OK=0;
						}
					}
				}
			}
		} else test_value = Val->Value.ValFloat ;
		if (OK) if (test_value >= TheLowerBound(Parent) &&
			test_value <= TheUpperBound(Parent)) {
				CurrentValue = test_value ;
				return ;
		} else {
			char buf[64] ;
			sprintf(buf,FloatFormat(test_value),test_value);
			*Output + OutputPrompt << "Value specified for parameter `"
			<< Name << "' (" << buf << ") is out of range.\n" ;
		}
		if (!State.IsInteractive()) {
			State.Error("bad parameter");
			return ;
		}
		*Output + OutputPrompt <<
			DspGuiCommon::default_prefix <<
			// "Type RETURN to select the default value (" <<
			Default << DspGuiCommon::default_suffix << Name ;
			if (index) *Output + OutputPrompt << "', parameter "
			<< dec(index) << "," ;
			else *Output + OutputPrompt << "'" ;
			*Output + OutputPrompt << " or\n" <<
			"specify a floating point value >= " <<
			TheLowerBound(Parent) << " and <= " <<
			TheUpperBound(Parent) << ":\n" ;
		Flag = 0;
	}
}

	
const char * OneParameter::GetTypeName()
{
	static char Buffer[32] ;

	if (IntP) return "integer";
	if (FloatP) return "double";
	if (StringP) return "string";
	if (EntityP) {
		strcpy(Buffer,"class ");
		strcat(Buffer,EntityP->EntityClass);
		return Buffer ;
	}
	if (ArrayP) {
		strcpy(Buffer,UserNameOfType(ArrayP->Type));
		if (ArrayP->Default->Size > 0) strcat(Buffer," *");
		return Buffer;
	}
	DbgError("OneParameter::GetTypeName","no type");
	return 0;
}
	
int OneParameter::IsNumeric()
{
	if (EntityP || StringP) return 0;
	if (!ArrayP) return 1;
	return ::IsNumeric(ArrayP->Type) ;
}

int OneParameter::IsComplex()
{
	if (!ArrayP) return 0;
	return ::IsComplex(ArrayP->Type) ;
}

int OneParameter::IsScalar()
{
	if (!ArrayP) return 1;
	return ArrayP->IsScalar();
}

int32 OneParameter::GetIntParameterValue()
{
	if(IntP) return IntP->GetParameterValue();
	else DbgError("OneParameter::GetIntParameterValue",
		"NO integer parameter");
	return 0 ;
}
	
double OneParameter::GetFloatParameterValue()
{
	if(FloatP) return FloatP->GetParameterValue();
	else DbgError("OneParameter::GetFloatParameterValue",
		"NO float parameter");
	return 0 ;
}
	
const char * OneParameter::GetStringParameterValue()
{
	if(StringP) return StringP->GetParameterValue();
	else DbgError("OneParameter::GetStringParameterValue",
		"NO string parameter");
	return 0 ;
}

UserEntity * OneParameter::GetEntityParameterValue()
{
	if (EntityP) return EntityP->GetParameterValue();
	else DbgError("OneParameter::GetEntityParameterValue",
		"No entity parameter");
	return 0 ;
}

void * OneParameter::GetArrayParameterValue()
{
	if (ArrayP) return ArrayP->GetParameterValue();
	else DbgError("OneParameter::GetArrayParameterValue",
		"No array parameter");
	return 0 ;
}

int32 OneParameter::GetLengthArrayParameterValue()
{
	if (ArrayP) return ArrayP->GetLengthParameterValue();
	else DbgError("OneParameter::GetLengthArrayParameterValue",
		"No array parameter");
	return 0 ;
}

void OneParameter::ListCommon(OutTokens& Out)
{
	Out.NextFillOut("Parameter") ;
	Out.NextQuoteOut(Name) ;
	Out.NextFillOut("is of type");
	Out.NextQuoteOut(GetTypeName());
	Out.NextConcat(".");
	Out.NewLine() ;
	Out.NextFillOut("It specifies the");
	Out.NextFillOut(Description);
	Out.NextConcat(".");
	Out.NewLine() ;
	if (FirstDefaultParameter) {
		Out.NextFillOut("This is an optional parameter.");
		Out.NewLine();
	}
	if (Check) {
		Out.NextFillOut("This parameter must satisfy the following condition: ");
		Check->DoCheck(CheckActionDescribe,this, Check->List,
			&Out);
		Out.NewLine() ;
	}

}

void OneParameter::ListValue(OutTokens& Out)
{
	ListCommon(Out) ;
	if (IntP) IntP->ListValue(*this,Out);
	else if (FloatP) FloatP->ListValue(*this,Out);
	else if (StringP) StringP->ListValue(Out) ;
	else if (EntityP) EntityP->ListValue(Out) ;
	else if (ArrayP) ArrayP->ListValue(*this,Out) ;
	else DbgError("OneParameter::ListValue","NULL Parameter pointer");
	Out.NewLine() ;
}

void OneParameter::List(OutTokens& Out,int Num)
{
	ListCommon(Out) ;
	if (IntP) IntP->List(*this,Out);
	else if (FloatP) FloatP->List(*this,Out);
	else if (StringP) StringP->List(Out,Num) ;
	else if (EntityP) EntityP->List(Out,Num) ;
	else if (ArrayP) ArrayP->List(*this,Out) ;
	else DbgError("OneParameter::List","NULL Parameter pointer");
	Out.NewLine() ;
}

void EntityParam::GetDefaultParameter(UserEntity * TheObject)
{
	// LogOut << "EntityParam::GetDefaultParameter\n" ;
	if (!TheObject) DbgError("EntityParam::GetDefaultParameter","null object");
	if (ComputeDefault) DefaultValue =
		(*ComputeDefault)(TheObject);
/*
 *	LogOut << "ComputeDefault = " << (void *) ComputeDefault << "\n" ;
 *	if (ComputeDefault && DefaultValue) LogOut << "DefaultValue = " <<
 *		DefaultValue << "\n" ;
 */
	if (DefaultValue) {
		CurrentValue = GetEntityFromName(DefaultValue) ;
		if (!CurrentValue) State.Error("invalid default value");
	} else CurrentValue = 0;
	// LogOut << "EntityParam::GetDefaultParameter exit\n" ;
}

void OneParameter::GetDefaultParameter(UserEntity * TheObject)
{
	// LogOut << "OneParameter::GetDefaultParameter\n" ;
	if (IntP) IntP->CurrentValue = IntP->Default ;
	else if (FloatP) FloatP->CurrentValue = FloatP->Default ;
	else if (StringP) StringP->CurrentValue = StringP->Default ;
	else if (EntityP) EntityP->GetDefaultParameter(TheObject);
	else if (ArrayP) ArrayP->CurrentValue = ArrayP->Default ;
	else DbgError("OneParameter::GetDefaultParameter",
		"NULL Parameter pointer");
	// LogOut << "OneParameter::GetDefaultParameter exit\n" ;
}


int OneParameter::GetParameter(int32 NextNameIndex, ValueType *Val,int index,
	UserEntity * TheObject)
{
	for (;;) {
		if (State.IsError()) return 0 ;
		if (!Val && State.IsInteractive() && State.IsVerbose()) *Output + OutputPrompt <<
			"`" << Name << "' specifies the " << Description << ".\n" ;
		// LogOut << "OneParameter::GetParameter, Name = " << Name << "\n" ;
		if (IntP) {
			IntP->GetParameter(Name,*this,Val,index);
			// LogForm("IntPValue = %d", IntP->CurrentValue);
		} else if (FloatP) {
			FloatP->GetParameter(Name,*this,Val,index);
			// LogMsg("FloatPValue = ", ConvertToString(FloatP->CurrentValue));
		} else if (StringP) {
			StringP->GetParameter(Name,NextNameIndex,Val,index);
			if (State.IsError()) return 0;
			// LogMsg("StringPValue = `",StringP->CurrentValue,"'");
		} else if (EntityP) {
			if (!EntityP->GetParameter(Name,*this,Val,index,TheObject))
				State.Error("invalid parameter for `",Name,"'") ;
			if (State.IsError()) return 0 ;
		} else if (ArrayP) {
			ArrayP->GetParameter(Name,*this,Val,index);
		} else DbgError("OneParameter::GetParameter","NULL Parameter pointer");
		if (Check) if (!Check->List) if (!Check->DoCheck(CheckActionCheck,this))
			if (State.IsInteractive()) continue ;
			else {
				State.Error("invalid parameter");
				return 0 ;
			}
		if (State.IsError()) return 0;
		return 1;
	}
}



const char * MakeNewEntityNameSuf(const char * Base,const char * Suffix)
{
	// LogOut << "MakeNewEntityNameSuf(" << Base << ", " << Suffix << ")\n" ;
	char * ret = DspApplication::force_to_legal_name_del(Concatenate(Base,Suffix));
	// LogOut << "ret = " << ret << "\n" ;
	return ret ;
}
	

const char * MakeNewEntityName(const char * Base,int32 Size)
{
	if (!Base) return "with `_X' appended to it, where `X' is the number of instances of this node" ;
	char Buf[BufSize] ;
	char * delete_name = 0 ;
	const char * base_name= delete_name=
		DspApplication::force_to_legal_name(Base,0);
	if (!base_name) base_name = Base ;
	int length = strlen(base_name) ;
	const max_digits = 5 ;
	if (strlen(base_name) > DspApplication::max_name_length - max_digits) {
		if (!delete_name) base_name = delete_name = Concatenate(base_name);
		delete_name[DspApplication::max_name_length - max_digits] = '\0' ;
	}
	for (;;) {
		sprintf(Buf,"_%d",Size);
		const char *RetVal = Concatenate(base_name,Buf);
			
		if (AllEntityLists->CheckNameInUse(RetVal)==InUseNo) {
			delete delete_name ;
			// LogOut << "Return = " << RetVal << "\n" ;
			return RetVal ;
		}
		Size++;
		delete (char *) RetVal ;
	}
}

int InteractiveEntity::GetParameters(int32 NextNameIndex)
{
	return Parameters->GetParameters(NextNameIndex);
}

int32 InteractiveEntity::GetIntParameterValue(const char * name)
{
	return Parameters->GetIntParameterValue(name) ;
}

const char * InteractiveEntity::GetStringParameterValue(
	const char * name)
{
	return Parameters->GetStringParameterValue(name);
}

double InteractiveEntity::GetFloatParameterValue(const char * name)
{
	return Parameters->GetFloatParameterValue(name) ;
}

UserEntity * InteractiveEntity::GetEntityParameterValue(const char *nm)
{
	return Parameters->GetEntityParameterValue(nm);
}

void * InteractiveEntity::GetArrayParameterValue(const char *nm)
{
	return Parameters->GetArrayParameterValue(nm);
}

int32 InteractiveEntity::GetLengthArrayParameterValue(const char *nm)
{
	return Parameters->GetLengthArrayParameterValue(nm);
}



