/*
 *  mask.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <complex.h>
#include <signal.h>
#include "ObjProDSP/portable.h"
#include "ObjProComGui/usercom.h"
#include "ObjProArith/hrdarth.h"
#include "ObjProArithGen/arthfnc.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProArithGen/artherr.h"
#include "ObjProDSPint/netlnk.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/mask.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * MaskWordNodeList = 0 ;
static InteractiveEntity * IntEntMaskWord ;
void MaskWordNodesInit();
MaskWord::MaskWord (const char * Name, int32 Mask):
	ProcessNodeStr(Name, 1, 1, 
	 new StreamStr(SizeVariable , SizeVariable , ArithType::ArithCapabilityAnyInt), 
	 new StreamStr(SizeVariable , SizeVariable , TheArithType == ArithType::ArithInt16 ? ArithType::ArithInt16 : ArithType::ArithInt32), 0, 1, 1, 0, 0, TimingTypeLinear)
,
	Mask_1(Mask)
{
	if (!MaskWordNodeList) MaskWordNodesInit() ;
	MaskWordNodeList->Append(MakeDeclaredEntity(this, IntEntMaskWord)) ;
	InitArithType(TheArithType);
	NewMenuItem("MaskWord",GetName());
#line 37 "../mask.usr"
 
	int32 Temp = GetMask();
	TheMask = *(uint32 *) &Temp ;
#line 49 "../mask.C"
} // end constructor

MaskWord::~MaskWord()
{
	TheMenuServer->DeleteMenuItem("MaskWord",GetName());
	MaskWordNodeList->Delete(GetName()) ;
} // end destructor

int MaskWord::CheckSafeDelete()
{
	int Safe_Check_Return = UserEntity::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

MaskWord * MaskWordDef;

ErrCode MaskWord::DoNode(int32 k)
{
#line 51 "../mask.usr"
 
	for (int32 i = 0 ; i < k ; i++ ) 
		for (int32 b = 0; b< GetBlockSize(); b++)
			for (int32 l = 0 ; l < GetEltSize(); l++)
				WriteBinary(ReadBinary() & TheMask);
	return OK ;
#line 76 "../mask.C"
} // end kernel code

static UserEntity * MakeMaskWord(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int MaskWord::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntMaskWord->CppList(Out,Cmd,this);
}

void MaskWord::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeMaskWord(Out,EntityReqDescribeFull,*IntEntMaskWord,TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("Mask");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetMask()));
		Out.NextFillOut(")");
		Out.NextFillOut("will be applied to each input sample to");
		Out.NextFillOut("create an output sample.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntMaskWord->GetOneParameter("Mask")->
			IntP->CurrentValue = Mask_1;
		break;
	}
} // end  list entity switch

void MaskWordNodesInit()
{
	if (MaskWordNodeList)  return ;

	static StringParam MaskWordNameParam =
		{"MaskWord", MakeNewEntityName, 0, LegalEntityName};
	static IntParam MaskWordMaskParam = {
		 0, 0, 0, -2147483647, 0, 2147483647};

	static OneParameter MaskWordParArray[] = {
		{"Name", 0, "node name", 0, 0, &MaskWordNameParam},
		{"Mask", 0, 
			"mask to be be applied to binary data stream",
			&MaskWordMaskParam},
		{0}
	};

	MaskWordNodeList = new EntityList;
	IntEntMaskWord = new InteractiveEntity("MaskWord", MaskWordNodeList,
		MakeMaskWord, InteractiveNode, "mask.h",
		0, "ProcessNodeStr");
	IntEntMaskWord->SetParameters(new UserParameters(MaskWordParArray));
	TheNodes->Append(IntEntMaskWord);
} // end initalization

static UserEntity * MakeMaskWord(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("MaskWord");
		Out.NextFillOut("copies its input to its output after applying a the");
		Out.NextFillOut("mask");
		Out.NextQuoteOut("Mask");
		Out.NextFillOut("to each sample.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		int32 Mask =
			IntNode.GetIntParameterValue("Mask");
		return new MaskWord(Name, Mask);

	}
	}
	return 0;
}

static InitObj LocalInit(MaskWordNodesInit, "MaskWord", "ProcessNodeStr");

