/*
 *  baseio2.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <string.h>
#include <ctype.h>
#include <complex.h>
#include <strstream.h>
#include "usercom.h"
#include "baseio.h"


const char * GetName (const char * Prompt, enum InputType typ) 
{
	if (!typ) typ = InputPrompt ;
	*Output + typ << "Enter " << Prompt << ":\n" ;
	char Buf[BufSize];
	char * RawBuf = GetRawBufLine(typ);
	istrstream Temp(RawBuf,BufSize-1);
	Temp >> Buf ;
	const char * RetVal = strcpy(new char[strlen(Buf)+1],Buf);
	return RetVal ;
}

NameOrNumber GetNameOrNumber(enum InputType typ)
{
	NameOrNumber Ret ;
	Ret.Name=0;
	Ret.Number=0; 
	// char Buf[BufSize];
	char * RawBuf = GetRawBufLine(typ);
	return GetNameOrNumber(RawBuf);
}

int GetStringValue(const char * Prompt, const char ** val,enum InputType typ)
{
	if (!typ) typ = InputPrompt ;
	for (;;) {
		*Output + typ << "Enter " << Prompt << " or RETURN:\n" ;
		char * RawBuf = GetRawBufLine(typ) ;
		if (!*RawBuf) return 0;
		else {
			*val = strcpy(new char[strlen(RawBuf)+1],RawBuf);
			return 1 ;
		}
	}
}

int GetIntValue(const char * Prompt, int32& val,enum InputType typ)
{
	if (!typ) typ = InputPrompt ;
	for (;;) {
		*Output + typ << "Enter " << Prompt << " or RETURN:\n" ;
		char * RawBuf = GetRawBufLine(typ) ;
		if (!*RawBuf) return 0;
		if (RawBuf[0] == '\03') return -1 ;
		else {
			istrstream Temp(RawBuf,BufSize-1);
			if(!(Temp >> val)) *Output + typ <<
				"Invalid integer input: `" << RawBuf << "'.\n" ;
			else return 1 ;
		}
	}
}

int GetComplexValue(const char * Prompt, complex * val,enum InputType typ)
{
	if (!typ) typ = InputPrompt ;
	for (;;) {
		*Output + typ << "Enter " << Prompt << " or RETURN:\n" ;
		char * RawBuf = GetRawBufLine(typ) ;
		if (!*RawBuf) return 0;
		if (RawBuf[0] == '\03') return -1 ;
		else {
			istrstream Temp(RawBuf,BufSize-1);
			if(!(Temp >> *val)) *Output + typ <<
				"Invalid integer input: `" << RawBuf << "'.\n" ;
			else return 1 ;
		}
	}
}

int GetDoubleValue(const char * Prompt, double& val,enum InputType typ)
{
	if (!typ) typ = InputPrompt ;
	for (;;) {
		if (Prompt) *Output + typ << "Enter " << Prompt << " or RETURN:\n" ;
		char * RawBuf = GetRawBufLine(typ) ;
		if (!*RawBuf) return 0;
		if (RawBuf[0] == '\03') return -1 ;
		else {
			istrstream Temp(RawBuf,BufSize-1);
			if(!(Temp >> val)) if (!Prompt) return 0;
			else *Output + OutputHelp <<
				"Invalid floating point input: `" << RawBuf <<
				"'.\n" ;
			else return 1 ;
		}
	}

}



