/*
 *  files.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <iostream.h>
#include <stdlib.h>
#include "files.h"
#include <errno.h>

void CerrSystemErrorMessage(int LastLineFeed=1)
{
	cerr << "The system error message is:\n" ;
	if (errno < sys_nerr) cerr << sys_errlist[errno] ;
	else cerr << "error number: " << errno <<
		" which is not in the system error table" ;
	cerr << "." ;
	if (LastLineFeed) cerr << "\n" ;

}

static void OpenFileBuf(const char * FileName, filebuf * ActTabFile)
{
	if (!ActTabFile->open(FileName,ios::out)) {
		cerr << "Can't create output file " << FileName
		<< ".\n" ; 
		CerrSystemErrorMessage();
		exit(1) ;
	}
}

ostream& OpenFile (const char * FileName)
{
	struct filebuf * ActTabFile = new filebuf ;
	OpenFileBuf(FileName,ActTabFile);
	ostream* Ret =  new ostream(ActTabFile) ;
	return *Ret ;
}


