/*
 *  textrans.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#include <ctype.h>
#include <string.h>
#include <iostream.h>
#include "texutil.h"
#include "textrans.h"
#include "textfrag.h"
#include "outtok.h"
#include "texspec.h"
#include "cgidbg.h"

TeXTranslate TranslateToTeX ;


static TeXMathTranslation  TheTeXMathTranslation[] = {
	{ '^', "$\\wedge$"},
	{ '<', "$<$"},
	{ '>', "$>$"},
	{ '|', "$|$"},
	{ ']', "$]$"},
	{ '[', "$[$"},
	{ '*', "$\\times$"},
	{0}
};

TeXTranslate::TeXTranslate():
	TeXMathTrans(TheTeXMathTranslation),
	Buffer(0),
	BufferCount(0),
	CheckMacroTail(0),
	Size(0)
{
}

static const char * CheckTail(const char * String)
{
	static const char * TeXMacroTail[] = {
		"{}","~",0};
	for (const char ** Check = TeXMacroTail; *Check ; Check++) {
		const char * Str = String ;
		for (const char * ptr = *Check ; *ptr ; ptr++)
			if (*(Str++) != *ptr) break ;
		if (!*ptr) {
			// LogOut << "Returning `" << *Check << "'\n" ;
			return *Check ;
		}
	}
	return 0 ;
}


const char * TeXTranslate::IsTeXMathTranslatable(char C)
{
	for (const TeXMathTranslation * Check = TeXMathTrans; Check->C;
		Check++) if (Check->C == C) return Check->Translation ;
	return 0 ;
}

void TeXTranslate::ExpandBuffer()
{
	int NewSize = 128 ;
	if (Size) NewSize = Size + (Size >> 1) ;
	char * Temp = new char[NewSize] ;
	for (int i = 0 ; i < Size; i++) Temp[i] = Buffer[i] ;
	for(;i<NewSize;i++) Temp[i] = '\0' ;
	delete Buffer ;
	Buffer = Temp ;
	Size = NewSize ;
}

void TeXTranslate::AppendChar(char C)
{
	if (BufferCount+3 > Size) ExpandBuffer();
	Buffer[BufferCount++] = C ;
}

void TeXTranslate::Append(const char * str)
{
	for (const char *Ptr = str; *Ptr; Ptr++) AppendChar(*Ptr);
}

int TeXTranslate::InList(char Check, const char * TheList)
{
	for (const char * ListChar = TheList; *ListChar ; ListChar++)
		if(*ListChar == Check) return 1;
	return 0 ;
}



int TeXTranslate::RequireTranslate(const char * Text)
{
	for (const char * Check = Text ; *Check; Check++) 
		if (IsSpecial(*Check)) return 1 ;
	return 0 ;
}


static int do_not_translate(const char * ck)
{
	static const char * forbidden[] = {
		"const char *",
		"char *",
		"int *",
		"int32 *",
		"-*",
		0
	};
	for (const char **ag =  forbidden; *ag;ag++) {
		int length = strlen(*ag);
		if (!strncmp(*ag,ck,length)) return length ;
	}
	return 0 ;
}


const char * TeXTranslate::DoTeXTranslate(const char * Fragment)
{
	if (!RequireTranslate(Fragment)) return Fragment ;
	ClearBuffer();
	char C ;
	int ExitMath = 0 ;
	const char * Temp ;
	for (const char * ToTranslate = Fragment; *ToTranslate; ToTranslate++) {
		int skip = do_not_translate(ToTranslate) ;
		for (int i = 0 ; i < skip ; i++) AppendChar(*ToTranslate++);
		if (skip) {
			ToTranslate-- ;
			continue ;
		}
		if (CheckMacroTail) {
			const char * Tail = CheckTail(ToTranslate);
			if (Tail) {
				ToTranslate+= strlen(Tail) - 1 ;
				Append(Tail);
				continue ;
			}
		}
		CheckMacroTail = 0 ;
		C = *ToTranslate ;
		if (ExitMath) if (!isalnum(C)) {
			if (ExitMath) AppendChar('$');
			ExitMath = 0 ;
		}
		if (C == '$') if (ToTranslate[1] == '$')
			if (ToTranslate[2]) if (isalpha(ToTranslate[2])) {
			Append("$$");
			ToTranslate++ ;
			continue ;
		}
		if (IsSpecial(C)) if(IsEscapable(C)) AppendChar('\\');
		else if(Temp = IsTeXMathTranslatable(C)) {
			Append(Temp);
			continue ; 
		} else {
			if (C== '\\') {
				const char * MacroWord =
					TheTeXWordTranslator.
					IsTeXMacro(ToTranslate) ;
				if (MacroWord) {
					if (TheTeXWordTranslator.
						IsMathTeXMacro(ToTranslate)) {
						ExitMath = 1 ;
						AppendChar('$');
					} 
					Append(MacroWord) ;
					ToTranslate+=strlen(MacroWord)-1;
					CheckMacroTail = 1 ;
					continue ;
				}
			}	
			cerr << "Cannot translate character `"
				<< C << "' in fragment \n`"  <<
				Fragment << "'.\n" ;
			continue ;
		}
		AppendChar(C);
	}
	if (ExitMath) AppendChar('$');
	AppendChar('\0');
	// cerr << "Translated Buffer is `" << Buffer << "'\n" ;
	return Buffer ;
}

/*
 * void TeXOutFragmentList(OutTokens& Out, TextFragmentList * TextList)
 * {
 *	TextFragment * Fragment ;
 *	TextFragmentListIterator Next(*TextList);
 *	while (Fragment = Next())  {
 *		const char * Trans = TranslateToTeX.DoTeXTranslate(
 *			Fragment->Text);
 *		if (Fragment->Line <0) Out.NextTeXttOut(Trans) ;
 *		else Out.NextFillOut(Trans);
 *	}
 * }
 */

