/*
 *  file_view.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef FILE_VIEW_DOT_H
#define FILE_VIEW_DOT_H
#include <InterViews/patch.h>
#include <InterViews/window.h>
#include <InterViews/observe.h>
#include "com_input.h"
#include "portable.h"
#include "elinlist.h"
#include "bound_val.h"

class WidgetKit ;
class LayoutKit ;
class Adjustable ;
class ScrollBox ;
class TopLevelWindow ;
class Style ;
class Event ;
class font ;
class PolyGlyph ;
class MonoGlyph ;
class CachedFile ;
class DisplayedLines ;
class MenuKeyboard ;
class TxtWindow ;


class FileView : public DspActiveHandler, public Observer {
	Style& the_style ;
	WidgetKit& the_kit ;
	const LayoutKit& the_layout ;
	const char * file_name ;
	const Font * font ;
	Glyph * the_glyph ;
	DisplayedLines * the_lines ;
	BoundedValue box ;
	Coord X_dim ;
	Coord y_size ;
	int line_count ;
	int current_line;
	int in_update ;
	int in_adjust_adjuster ;
	CachedFile * the_cache ;
	MenuKeyboard * the_menu_keyboard ;
	TxtWindow * notify_on_exit;

	double prompt_value_return;
    int got_value ;
	int clear_flag ;
	int last_not_terminated;
	void clear();

	void change_line(int32 new_line);

public:
    FileView(WidgetKit&, const LayoutKit&, Style& s, const char * nm,
		const Font *f=0, const Color * background = 0, TxtWindow *txt=0);
    virtual ~FileView();
	MenuKeyboard * build_menu(WidgetKit*, const LayoutKit&, Style * style);
    virtual Adjustable* adjustable() ;
	void adjust_adjuster();
	virtual void keystroke(const Event&);
	void update_size(int32 lines, int32 bytes) ;
	void update_size(const char * str, int extra_lines=0) ;
	int fill();
	void fill(int line_index);
	void new_page();
	virtual void resize();
    virtual void update(Observable*);
	static Coord Y_dim ;

	MenuKeyboard * menu_keyboard() const {return the_menu_keyboard;}

	void page_down();
    void page_up();
    void end();
    void begin();
    void line_down();
    void line_up();
    void to_line();
    void ahead_lines();
	void save_file(const char *);
	void save_file();
    void delete_window();

	void build(const Color * bg);

	int prompt_for_value(const char * msg) ;
    void prompt_value(const char * value) ;

	WidgetKit& kit() {return the_kit ;}
	const LayoutKit& layout() {return the_layout ;}
	int lines() const {return line_count;}
	virtual void exit_window() ;
};

class FileWindow : public ManagedWindow {
	FileView * the_view ;
public:
	FileWindow(WidgetKit&, const LayoutKit&, Style& s, const char * file_name,
		const Font *font =0, const Color * background = 0, TxtWindow * t=0,
		int deletable = 1);
	void update_size(int32 lines, int32 bytes) ;
	void update_size(const char * str,int extra_lines = 0) ;
	virtual void resize() ;
	void raise_window() {raise();}
};

#endif /* #ifdef FILE_VIEW_DOT_H */
