/*
 *  genmenu.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "com_input.h"
#include "portable.h"

#include <InterViews/enter-scope.h>
#include <InterViews/action.h>

class Glyph ;
class Style ;
class WindowMenu ;
class Menu ;
class Graph ;
class DataPlot ;
class PullDownEntry ;
class ivWidgetKit;
class ivLayoutKit;
class MenuKeyboard ;
class KeyMenu ;
class PullDownDescribe ;

class RecAction : public Action {
	MenuKeyboard * the_keyboard ;
	PullDownEntry * entry ;
protected:
public:
	RecAction(MenuKeyboard * key, PullDownEntry * desc);
	void record();
	int code_execute(uint32 code,int playback_flag);
	uint32 index();
	virtual void force_execute()=0 ;
};


struct PullDownDescribe {
	const char * str;
	uint32 key_code ;
	Action * action ;
	PullDownDescribe * submenu ;
	enum Exclude {none=0,eye_plot} exclude ;
	uint32 mouse_code ;
	const char * display_line();
};

class WindowMenu {
	KeyMenu * the_menubar ;

	int exclude_this(PullDownDescribe::Exclude check);
	virtual void clear_view_allowed() {}
	Menu* pulldown(PullDownEntry**,  ivWidgetKit&, const ivLayoutKit&);
	virtual Action * set_action(PullDownEntry * i) = 0 ;
public:
	Menu* menubar(PullDownEntry**, ivWidgetKit&, const ivLayoutKit&,
		MenuKeyboard * key=0);
	Menu * menu() const ;
	virtual int is_eye_plot() {return 0;}
	WindowMenu():the_menubar(0){}
	MenuKeyboard * keyboard() ;
	KeyMenu * make_key_menu(WidgetKit& kit);
	virtual const char * mouse_selected() {return 0;}
	virtual const char * key_selected() {return 0;}

	virtual void act_select(const char * ) {}
	virtual void act_deselect() {}
	virtual void clear_selected() = 0 ;
	virtual int direct_act_failed(int32 act, const char * select) {return 0 ;}
};
	
	


class PullDownEntry {
	PullDownDescribe& pull_down ;
	GlyphIndex the_index ;
	uint32 key_code ;
	Menu * the_menu ;
	PullDownEntry ** the_submenu ;
	RecAction * the_action ;
public:
	PullDownEntry(PullDownDescribe& descr);
	PullDownEntry();
	~PullDownEntry();
	const char * string() {return pull_down.str;}
	PullDownDescribe::Exclude exclude() {return pull_down.exclude;}
	const char * display_line() {return pull_down.display_line();}
	void menu(Menu *m) {the_menu= m;}
	Menu * menu() const {return the_menu;}
	void index(GlyphIndex ix) {the_index = ix;}
    GlyphIndex index() {return the_index;}
	RecAction * action() {return the_action;}
	void action(RecAction * a) {the_action = a;}
	Action * base_action() {return pull_down.action;}
	PullDownEntry ** submenus() const {return the_submenu;}
	PullDownEntry * find_key_code(uint32 key, int rec_call= 0);
	const RecAction ** build_mouse_table(RecAction ** table = 0);

	const char * comment_from_index(int index) const ;

	int execute(int32 code, int playback_flag=0);
	int32 get_key_code() const {return key_code;}
};

class MenuKeyboard : public DspInputHandler {
	WindowMenu * window_menu ;
	PullDownEntry * selected ;
	PullDownEntry *  the_top ;
	const RecAction ** mouse_table ;
	const char * the_name ;
	GlyphIndex the_next_action ;
public:
	MenuKeyboard(ivWidgetKit& kit, const ivLayoutKit& layout, ivStyle *style,
		WindowMenu * menu, PullDownDescribe& menu_tree);
	virtual ~MenuKeyboard();
    virtual void press (const Event&);
    virtual void release(const Event&);
	virtual void clear_selected() ;
	const char * name() {return the_name;}
    int object_press (const Event&);
    int object_release(const Event&);
    int do_keystroke(const Event&);
    virtual void keystroke(const Event&);
	virtual int accept_keystroke(const Event&);
	void check_release();
	void key_record(uint32 key);
	void key_record_act(uint32 key);
	void mouse_record(uint32 mouse);
	void action_record(uint32 action);
	GlyphIndex next_action() {return the_next_action++;}

	virtual int do_act(int32 act, const char * select);
	const char * comment_from_index(int index) const
		{return the_top->comment_from_index(index);}
	void clear();
	PullDownEntry * top() const {return the_top;}
};

#include <InterViews/leave-scope.h>

