/*
 *  infile.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef INFILE_DOT_H
#define INFILE_DOT_H
/*  infile.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "ObjProArith/hrdarth.h"
#include "ObjProDSP/portable.h"
#include "ObjProDSPcom/datfile.h"
#include "ObjProGen/errcode.h"

class TargetNode ;
class PacketHeader ;
class NodeOutChannelHeader ;
class TargetNode ;


class InputFile {
	int TheFile ;
	const char * FileName ;
	char * exp_file_name ;
	char * delete_file_name ;
	TargetNode * TheNode ;
	int16 Channels ;
	int32 WordSize ;
	int32 BlockSizeInWords ;
	int32 BlockSizeInBytes ;
	int16 Flags ;
	long FirstDataSample ;
	long * LastReadBlock ;
	long * FirstWordInBuffer ;
	long * SeekByteAfterLastRead ;
	long SeekNextRead ;
	int16 * LastReadWord ;
	int16 * ChannelBufferSize ;
	int32 * ElementSize ;
	MachWord ** Buffers ;
	NodeOutChannelHeader * TheChannelHeaders ;
	long * LastWord ;
	void * ConvertBuffer ;
	int32 ConvertBufferSizeInBytes ;
	int32 TotalConvertOverflows ;
	int InDestructor ;
	int HaveReadError ;
	const char * NodeName ;
	const char * OriginalNodeName ;
	const char * Caption ;
	DataType TheDataType ;
	ErrCode StateLastRead ;
	ErrCode * ChannelStateLastRead ;

	long SeekAtReset ;
	int IsInDestructor() {return InDestructor;}
	int ReadHeader();
	void NotBinaryFile(const char * Msg = 0) ;
	void BadPacketType() ;
	int DoRead(void * Data, int Size, int IntFlag = 0) ;
	int IncrementalRead(void * Data, int Size) ;
	int StringRead(char * Str,int Length) ;
	int PacketRead(enum DataFileElements type, void * Data, int Size) ;
	int CheckPacketType(PacketHeader& PacketHead) ;
	int NextSequentialChannel() ;
	ErrCode UpdateChannel(int Channel) ;
	int ReadChannelHeader(int Channel);
	ErrCode ReadChannel(int Channel, int32 BytesRead);
	int ConvertReadChannel(int i, int32 BytesRead);
	void FileInNode() ;
	void ReadError();
	// file_name should only be set on open in interactive mode
	int CheckDataType() ;
	int IgnoreFileHeaderWordCount ;
	ErrCode SeekAfterLastRead(int Channel) ;
	void EndOfFile();
public:
	InputFile(TargetNode * node, const char * FileName,
		const char * NodeName,int16 Flags=0);
	~InputFile();
	MachWord Read(int16 Channel);
	int32 Read(int16 Channel, int32 Size, MachWord * DataBuffer);
	int16 GetChannels() {return Channels;}
	ErrCode GetReadState() {return StateLastRead;}
	int GetTheFile() {return TheFile;}
	void DisplayHeader();
	double GetTimeFirst(int Channel);
	int32 GetElementSize(int Channel);
	DataType GetDataType() const {return TheDataType;}
#ifdef INTERACTIVE
	TimingDescription * GetInitTiming(int InChannel);
#endif
	int CheckLegalChannel(int Channel) ;
	double GetTimingRatio (int Channel) ;
	void SetIgnoreHeaderCount() {IgnoreFileHeaderWordCount =1 ;}
	const char * GetCaption() const {return Caption;}
	const NodeOutChannelHeader& GetChannelHeader(int i) const ;
	ErrCode Reset();
	int CheckIntegrity();
	const char * GetFileName() const {return FileName ;}
};

#endif /* #ifdef INFILE_DOT_H */
