/*
 *  const.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef CONST_DOT_H
#define CONST_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/sigbase.h"

class ConstantData: public Signal {
	int32  Value_1;
public:
	ConstantData (const char * Name, int32 Value);
	virtual ~ConstantData();
	int32 GetValue() const {return Value_1;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
	void SetValue(int32  Value) { Value_1 = Value; parameter_changed(); }
};

extern ConstantData * ConstantDataDef;


#endif /* #ifdef CONST_DOT_H */
