/*
 *  normal.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef NORMAL_DOT_H
#define NORMAL_DOT_H
#include "ObjProGen/genrand.h"

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/sigbase.h"

class Normal: public Signal {
#line 58 "../normal.usr"
 
	GaussRand * rand_gen ;
#line 24 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/normal.h"
	double  Sigma_1;
	double  Mean_2;
	int16  ElementSize_3;
	int32  Seed_4;
public:
	Normal (const char * Name, double Sigma, double Mean, int16 ElementSize, 
		int32 Seed);
	virtual ~Normal();
	double GetSigma() const {return Sigma_1;}
	double GetMean() const {return Mean_2;}
	int16 GetElementSize() const {return ElementSize_3;}
	int32 GetSeed() const {return Seed_4;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
	void SetSigma(double  Sigma) { Sigma_1 = Sigma; parameter_changed(); }
	void SetMean(double  Mean) { Mean_2 = Mean; parameter_changed(); }
};

extern Normal * NormalDef;


#endif /* #ifdef NORMAL_DOT_H */
