/*
 *  ramp.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef RAMP_DOT_H
#define RAMP_DOT_H
#define __DSP_PP_TARGET_CODE__

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProDSPcom/tarnod.h"
class Ramp: public TargetNode {
	int32  NextOut;
	int32  Min_1;
	int32  Max_2;
	int32  Increment_3;
public:
	Ramp (const char * Name, int32 Min, int32 Max, int32 Increment,
		DfNodeInLink* in_links, DfNodeOutLink* out_links,
		int ** exec_seq,  NodeExecuteType exec_type,
		int delay);
	virtual ~Ramp();
	int32 GetMin() const {return Min_1;}
	int32 GetMax() const {return Max_2;}
	int32 GetIncrement() const {return Increment_3;}
	int32 GetNextOut() const { return NextOut;}
	virtual ErrCode DoNode(int32);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
	void SetMin(int32  Min) { Min_1 = Min; parameter_changed(); }
	void SetMax(int32  Max) { Max_2 = Max; parameter_changed(); }
	void SetIncrement(int32  Increment) { Increment_3 = Increment; parameter_changed(); }
};

extern Ramp * RampDef;


#endif /* #ifdef RAMP_DOT_H */
