/*
 *  repackstr.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef REPACKSTR_DOT_H
#define REPACKSTR_DOT_H
#define __DSP_PP_TARGET_CODE__

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProDSPcom/tarnod.h"
class RepackStream: public TargetNode {
#line 82 "../repackstr.usr"
 
	int32 Ratio ;
	BinMachWord MaskIn ;
	BinMachWord Word ;
	int32 WordsOut ;
	int BitsLeftInWord ;
	int min_word_size ;
	ErrCode err_state ;
	BinMachWord GetNextOutWord();
	int16 sign_bit ;
    uint32 fill_ones ;
	void ctor();
	ErrCode kernel(int32 k);
#ifdef INTERACTIVE
	virtual void input_linked(int in_channel)
		{err_state = propagate_arith_type(in_channel,
			-(GetInputWordSize() > GetOutputWordSize() ?
			GetInputWordSize() : GetOutputWordSize()));}
#endif
#line 40 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPtar/ObjProUsr/repackstr.h"
	int16  OutputWordSize_1;
	int16  InputWordSize_2;
	int16  SignedOutput_3;
public:
	RepackStream (const char * Name, int16 OutputWordSize, int16 InputWordSize, 
		int16 SignedOutput,
		DfNodeInLink* in_links, DfNodeOutLink* out_links,
		int ** exec_seq,  NodeExecuteType exec_type,
		int delay);
	virtual ~RepackStream();
	int16 GetOutputWordSize() const {return OutputWordSize_1;}
	int16 GetInputWordSize() const {return InputWordSize_2;}
	int16 GetSignedOutput() const {return SignedOutput_3;}
	virtual ErrCode DoNode(int32);
};

extern RepackStream * RepackStreamDef;


#endif /* #ifdef REPACKSTR_DOT_H */
