/*
 *  trunc.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef TRUNC_DOT_H
#define TRUNC_DOT_H
#define __DSP_PP_TARGET_CODE__

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProDSPcom/tarnod.h"
class Truncate: public TargetNode {
#line 81 "../trunc.usr"
 
	uint32 mask ;
	MachWord round_offset ;
	double over_min ;
	double over_max ;
	double int_over_max;
	virtual void parameter_changed();
#ifdef INTERACTIVE
	int InitAfterLinked();
#endif
#line 31 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPtar/ObjProUsr/trunc.h"
	int binary_read_flag ;
	int16  Range_1;
	int16  Accuracy_2;
	int16  OverflowMode_3;
	int16  Round_4;
public:
	Truncate (const char * Name, int16 Range, int16 Accuracy, int16 OverflowMode, 
		int16 Round,
		DfNodeInLink* in_links, DfNodeOutLink* out_links,
		int ** exec_seq,  NodeExecuteType exec_type,
		int delay,
		int TruncateStaticInitbinary_read_flag);
	virtual ~Truncate();
	int16 GetRange() const {return Range_1;}
	int16 GetAccuracy() const {return Accuracy_2;}
	int16 GetOverflowMode() const {return OverflowMode_3;}
	int16 GetRound() const {return Round_4;}
	virtual ErrCode DoNode(int32);
	void SetRange(int16  Range) { Range_1 = Range; parameter_changed(); }
	void SetAccuracy(int16  Accuracy) { Accuracy_2 = Accuracy; parameter_changed(); }
	void SetOverflowMode(int16  OverflowMode) { OverflowMode_3 = OverflowMode; parameter_changed(); }
	void SetRound(int16  Round) { Round_4 = Round; parameter_changed(); }
};

extern Truncate * TruncateDef;


#endif /* #ifdef TRUNC_DOT_H */
