/*
 *  shrdary.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef SHRDARY_DOT_H
#define SHRDARY_DOT_H
#include "ObjProGen/slist.h"
#include "ObjProGen/outtok.h"

class ArrayData ;

class ArrayDataList:public SingleList {
	int Count ;
public:
	ErrCode Insert(ArrayData *nt) {return SingleList::Insert(nt);}
	ErrCode Append(ArrayData *nt) {return SingleList::Append(nt);}
	ArrayData * Get()   {return (ArrayData *) SingleList::Get();}
	ArrayData * Pop() {return (ArrayData *) SingleList::Pop();}
	ArrayData * GetNFromTop(int N) ;
	ArrayData * GetNthEntry(int N) ;
	ArrayDataList(){;}
	int Size(){return SingleList::Size();}
} ;

class ArrayDataListIterator:public SingleListIterator {
public:
	ArrayDataListIterator(ArrayDataList& df):SingleListIterator((SingleList&) df){}
	ArrayData * operator()()
		{return (ArrayData *) Next();}
};


class SharedArray {
	// to allow common arrays to be shared across networks
	const char * HeaderName ;
	ostream& HeaderStream ;
	OutTokens HeaderFile ;
	ostream& CodeStream ;
	OutTokens CodeFile ;
	ArrayDataList TheArrayParameters ;
public:
	SharedArray(const char * DirName, const char * HeaderFileName,
		const char * CodeFileName);
	~SharedArray();
	int IsGood() ;
	OutTokens& GetHeaderFile() {return HeaderFile;}
	OutTokens& GetCodeFile() {return CodeFile;}
	const char * GetHeaderName() const {return HeaderName;}
	ArrayDataList& GetArrayList() {return TheArrayParameters;}
	ArrayData * FindSame(ArrayData * Check);
	void Append(ArrayData *elt) {TheArrayParameters.Append(elt);}
};
#endif /* #ifdef SHRDARY_DOT_H */
