/*
 *  defined.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef DEFINED_DOT_H
#define DEFINED_DOT_H
// #include "winmgr.h"
#include "attrib.h"
#include "logdum.h"
#include "cgidbg.h"
#include "help.h"
// #include "valcon.h"
#include "gui.h"
#include "examp.h"
#include "menstat.h"
#include "xdrv.h"
#include "dsp_app.h"
#include "dspguicom.h"
#include "netplot.h"
#include "mkstr.h"
#include "cgidbg.h"
#include <strstream.h>
#include <string.h>
#include "slist.h"
#include "playback.h"

static const Coord def_gr_width = 600 ;
static const char * def_gr_width_string = "600" ;


static void set_graph_width_option(char * errmsg=0);

static void set_graph_response(const char * response, InputType,void *)
{
	Coord new_size = def_gr_width ;
	if (response) if (*response) {
		const buf_size = 128 ;
		char buf[buf_size];
		for (int i = 0 ; i < buf_size;i++) buf[i] = ' ' ;
		if (strlen(response) >= buf_size) {
			set_graph_width_option(Concatenate("Input too long."));
			return ;
		}
		strcpy(buf,response);
		istrstream Temp(buf,buf_size);
		Temp >> new_size ;
		if (!Temp.good()) {
			set_graph_width_option(Concatenate("Invalid numeric entry.\n"));
			return ;
		}
	}
	VerticalPosition::set_width_limit(new_size);
}


static void set_graph_width_option(char * errmsg)
{
	// LogOut << "set_graph_width_option\n" ;
	StringList strings ;
	if (errmsg) strings.Append(errmsg);
	strings.Append(Concatenate(
		"Specify the width of the window for network displays:\n"));
	DspApplication::prompt(strings,set_graph_response, def_gr_width_string);
/*
 *	UserPrompt prompt(0,set_graph_response,0,1,1,InputPrompt,
 *		def_gr_width_string);
 *	DspApplication::root_window()->InputPost(&prompt,0,&strings);
 */
}

static void set_graph_width()
{
	set_graph_width_option();
}

extern void ExitAndCleanUp() ;

static void SetHelpLevelNone()
{
	HelpDo.SetHelpLevel(HelpLevelNone);
}

static void SetHelpLevelConfirm()
{
	HelpDo.SetHelpLevel(HelpLevelConfirm);
}

static void PlotErr()
{
	DspApplication::plot_err_display();
}

static void SetHelpLevelAll()
{
	HelpDo.SetHelpLevel(HelpLevelAll);
}

static void ReadState()
{
	DspApplication::root_window()->read_state(0);
}

static void ReadPlot()
{
	DspApplication::read_plot();
}


static void ReadOverState()
{
	DspApplication::root_window()->read_state(1);
}

static void PlayActions()
{
	ManagedKeyboards::manager()->play_actions();
}

static void PlayPause()
{
	ManagedKeyboards::manager()->play_pause();
}


static void RecordActions()
{
	ManagedKeyboards::manager()->record_actions();
}

static void RecordOff()
{
	ManagedKeyboards::manager()->record_off();
}

static void RecordFlush()
{
	ManagedKeyboards::manager()->record_flush();
}



static void DoExit()
{
	DspState->DoExit();
}

static void DoSaveExit()
{
	DspState->DoSaveExit();
}

static void AbortDspExecution()
{
	DspState->AbortDspExecution();
}

void DescribeExample(const char * Examp)
{
	TheExamples->DescribeExample(Examp);
}

void ExecuteExample(const char * Examp, const char * Over)
{
	TheExamples->ExecuteExample(Examp, Over);
}

void ReadExample(const char * Examp)
{
	TheExamples->ReadExample(Examp);
}

void FreezeDsp()
{
	DspApplication::root_window()->hard_freeze();
}

void ThawDsp()
{
	DspApplication::root_window()->thaw();
}


#endif /* #ifndef DEFINED_DOT_H */
