/*
 *  menuprsl.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <string.h>
#include <iostream.h>
#include "menuprsl.h"
#include "mkstr.h"

void GetEmbeddedName(const char * yytext)
{
	int length = strlen(yytext);
	char * temp = new char[length-1] ;
	strncpy(temp,yytext+1,length-2);
	temp[length-2] = '\0' ;
	AddEmbeddedName(temp);
	delete temp ;
}

char * MakeOperatorCommand(const char * Base,const char * OperatorString)
{
	return Concatenate(Base," operator",OperatorString);
}
