/*
 *  mknody.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
%{
#include "mknodey.h"
%}
%union {
	const char * Name ;
	int32 Int ;
	const char * String ;
	class TextFragmentList * Text ;
	struct Double * Dbl ;
	struct MyComplex * Complex ;
	int Terminal ;
	struct Compound * Tree ;
	} 
%type <Tree> ParmV NumParmValue ParmValue Number SignedNumber
%type <Tree> Variable Constant ConstantList ValueProcedure
%type <Tree> Expression Primary ParamList DeclaredRef CheckParamList
%type <String> String Extra
%type <Tree> MenuLine Size NumberList DefaultList Parameter
%type <Text> Cpp FullDescription BaseDescription
%type <Tree> Description InstanceDescription
%type <Name> Name ObjectClassName HelpFile Operator MemberName
%type <String> IncludeString
%type <Terminal> Type ScaleName
%type <Terminal> ChangeOpt
%type <Tree> ScaledType
%type <Int> Default BaseType
%token MENU_LINE BASE_DESCRIPTION DESCRIPTION PARAMETER_VALUE EXPRESSION
%token INSTANCE TIMING CONSTRUCTOR KERNEL DESTRUCTOR HELP_FILE
%token STATIC_INIT STATIC_DECLARE ARITH_TYPE_PREAMBLE
%token ARROW DOUBLE_COLON INTERACTIVE_LIST STATE_EMIT SAFE_DELETE
%token CLASS PUBLIC OPERATOR BASE CHECK_PARAMETER PRIVATE PROTECTED
%token <Int> C_INCLUDE H_INCLUDE c_INCLUDE h_INCLUDE
%token <Int> IC_INCLUDE IH_INCLUDE Ic_INCLUDE Ih_INCLUDE
%token <Int> TC_INCLUDE TH_INCLUDE Tc_INCLUDE Th_INCLUDE
%token FIRST_DEFAULT NO_DEFAULT_INSTANCE BASE_MEMBERS
%token <Text> EMBEDDED_TEXT_LINE EMBEDDED_TEXT CPP_CODE
%token <Terminal> INT INT16 INT32 MAX MIN MAX_NEG MIN_POS
%token <Terminal> DOUBLE COMPLEX CHANGEABLE
%token <Terminal> MACH_WORD CX_MACH_WORD ACC_MACH_WORD CX_ACC_MACH_WORD
%token <Terminal> SC_MACH_WORD SC_CX_MACH_WORD
%token <Terminal> SC_ACC_MACH_WORD SC_CX_ACC_MACH_WORD
%token <Terminal> STRING NETWORK_REF NETWORK_STATE VOID
%token <Name> NAME WORD_STRING
%token <Int> INTEGER_VAL NEW
%token <Dbl> DOUBLE_VAL
%token <String> STRING_VAL ANGLE_VAL
%token <Int> TARGET_TYPE
%right <Text> '='
%left <Text> '?' ':'
%left <Text> OR
%left <Text> AND
%left <Text> '|'
%left <Text> '^'
%left <Text> '&'
%left <Text> EQU NEQ
%left <Text> '<' '>' LEQ GEQ
%left <Text> SHIFT_R SHIFT_L
%left <Text> '+' '-'
%left <Text> '*' '/' '%'
%left <Text> '.' ARROW
%%
File : TargetDesignator InteractiveClass DfNode

	| TargetDesignator DfNode

TargetDesignator : TARGET_TYPE ';' ArithStrings 	{FoundTargetType($1);} 

	| ArithStrings

ArithStrings : ArithStringList ';'

	|

ArithStringList : STRING_VAL			{FoundFirstArithType($1);}

	| ArithStringList ',' STRING_VAL	{FoundArithType($3);}


InteractiveClass : INTERACTIVE_LIST NAME ';'	{FoundInteractiveList($2);}

DfNode : Header NodeDescription Body		{NodeComplete();}

	| Header					{HeaderOnly();}

Header : DoInit Includes NodeName Parameters HeaderEnd

HeaderEnd : Declaration StaticDeclare StaticInit Ctor Dtor Safe

DoInit :						{DoNodeInit();}

Body : StateEmit Timing Kernel Instances		{CodeComplete();}

IncludeString : STRING_VAL

	| ANGLE_VAL

Includes : Includes Include			

	|

Include : C_INCLUDE IncludeString			{FoundInclude($2,$1);}

        | H_INCLUDE IncludeString			{FoundInclude($2,$1);}

        | c_INCLUDE IncludeString			{FoundInclude($2,$1);}

        | h_INCLUDE IncludeString			{FoundInclude($2,$1);}

        | IC_INCLUDE IncludeString			{FoundInclude($2,$1);}

	| IH_INCLUDE IncludeString			{FoundInclude($2,$1);}

	| Ic_INCLUDE IncludeString			{FoundInclude($2,$1);}

	| Ih_INCLUDE IncludeString			{FoundInclude($2,$1);}

	| TC_INCLUDE IncludeString			{FoundInclude($2,$1);}

	| TH_INCLUDE IncludeString			{FoundInclude($2,$1);}

	| Tc_INCLUDE IncludeString			{FoundInclude($2,$1);}

	| Th_INCLUDE IncludeString			{FoundInclude($2,$1);}

NodeName : ClassName TheNodeName

	| TheNodeName 				{FoundClassName("Node");}

TheNodeName : Name				{FoundNodeName($1);}

ClassName : NAME				{FoundClassName(MakeName($1));}

	| BASE					{SetBaseSwitch();}


Parameters : '(' ParameterList ')' DfNodeCtor ';'


ParameterList : ParameterAndCheck 
	
	| ParameterList ',' ParameterAndCheck

	| 

ParameterAndCheck : Default Parameter 		{FoundParameterCheck($1,$2,0);}

	| Default Parameter CHECK_PARAMETER Cpp {FoundParameterCheck($1,$2,$4);}

Default : FIRST_DEFAULT {$$=1;}

	| {$$=0;};

Parameter : ScaledType Name ':' ParmValue LEQ ParmValue LEQ ParmValue
			Description	{ $$=FoundParameter($1,$2,$4,$6,$8,$9);}

	| ScaledType Name ':' ParmV Description
					{$$=FoundParameter($1,$2,0,$4,0,$5);}

	| ScaledType Name 		{$$=FoundParameter($1,$2);}

	| ObjectClassName Name ':' Name Description
					{$$=FoundParameter($1,$2,$4,$5);}
	
	| ObjectClassName Name ':' Name '(' ')' Description
					{$$=FoundParameterSubDef($1,$2,$4,$7);}

	| ObjectClassName Name 			{$$=FoundParameter($1,$2,0,0);}

	
	| ScaledType '*' Name Size ':' ParmValue LEQ DefaultList LEQ ParmValue

		Description {$$=FoundPtrParameter($1,$3,$6,$8,$10,$11,$4);}

Size : '[' INTEGER_VAL ']'			{$$=MakeSize($2);}

	| '[' INTEGER_VAL '-' INTEGER_VAL ']'	{$$=MakeSize($2,$4);}

	|  					{$$=MakeSize();}

DefaultList : NumParmValue 			{$$=MakeNumParmList($1);}

	| '{' NumberList '}'			{$$=$2;}

NumberList : NumberList ',' NumParmValue	{$$=AppendNumParmList($1,$3);}

	| NumParmValue				{$$=MakeNumParmList($1);}

	
Type : INT
	| INT16
	| INT32
	| DOUBLE
	| COMPLEX
	| STRING
	| MACH_WORD
	| CX_MACH_WORD
	| ACC_MACH_WORD
	| CX_ACC_MACH_WORD
	| VOID

ObjectClassName : Name

	| Name '*'				{$$=MakeClassName($1,'*');}

	| Name '&'				{$$=MakeClassName($1,'&');}

ScaledType : ChangeOpt ScaleName DOUBLE_VAL	{$$=ScaleDeclaration($1,$2,$3);}
	| ChangeOpt ScaleName			{$$=ScaleDeclaration($1,$2,
							DoubleOne);}
	| ChangeOpt Type			{$$=ScaleDeclaration($1,$2);}

ChangeOpt : CHANGEABLE
	|					{$$=0;}

ScaleName : SC_MACH_WORD
	| SC_CX_MACH_WORD
	| SC_ACC_MACH_WORD
	| SC_CX_ACC_MACH_WORD

ParmV : String				{$$=MakeStringItem($1);}

	| INTEGER_VAL			{$$=MakeZeroIntItem($1);}

ParmValue : NumParmValue

	| ValueProcedure

NumParmValue : SignedNumber			

	| MAX				{$$=MakeTermItem($1);}

	| MIN		 		{$$=MakeTermItem($1);}

	| MAX_NEG			{$$=MakeTermItem($1);}

	| MIN_POS	 		{$$=MakeTermItem($1);}

Declaration : ReferencedNameList DeclarationCode
					{FoundDeclaration();}

	| DeclarationCode		{FoundDeclaration();}

ReferencedNameList : ReferencedNameList Member

	| Member

MemberName : Name 				{NewMember($1); $$=$1;}

	| OPERATOR Operator			{$$=MakeOperatorName($2);
						NewMember($$);}

Member :  Name '*' MemberName '(' ParameterList ')' Description ';'
			{FoundMemberName(MakeClassName($1,'*'), $3,$7);}

	| Name '&' MemberName '(' ParameterList ')' Description ';'
			{FoundMemberName(MakeClassName($1,'&'), $3,$7);}

	| Name MemberName '(' ParameterList ')' Description ';'
			{FoundMemberName($1,$2,$6);}

	| Type '*' MemberName '(' ParameterList ')' Description ';'
			{FoundMemberName(MakeClassName($1,'*'), $3,$7);}

	| Type '&' MemberName '(' ParameterList ')' Description ';'
			{FoundMemberName(MakeClassName($1,'&'), $3,$7);}

	| Type MemberName '(' ParameterList ')' Description ';'
			{FoundMemberName(MakeClassName($1),$2,$6);}

	| NETWORK_STATE '*' NETWORK_REF ';'	{FoundNetworkRef();}

	| BASE_MEMBERS 			{BaseMembers();}

	| Type Name ';'			{FoundTypedName(0,$1,$2);}

	| Type '*' Name ';'		{FoundPtrTypedName(0,$1,$3);}


DeclarationCode : CLASS  Cpp ';'	{FoundDeclarationCode($2);}

		| 			{FoundDeclarationCode();}

NodeDescription : Description 		{FoundNodeDescription($1);}

		| BaseDescription	{FoundBaseDescription($1);}


HelpFile : HELP_FILE Name		{$$=$2;}

ValueProcedure : PARAMETER_VALUE '(' CheckParamList ')' Cpp 	{

					$$=MakeParamFunc($3,$5);}

	| PARAMETER_VALUE Cpp		{$$=MakeParamFunc($2);}

CheckParamList : CheckParamList ',' Name 	{$$=MakeNameList($1,$3);}

	| Name					{$$=MakeNameList($1);}
	
DfNodeCtor : BaseDfNodeCtor ',' OtherBaseList

	| BaseDfNodeCtor

	|					{FoundDfNodeCtor();}

BaseDfNodeCtor : ':' Public BaseFunctionName '(' CtorParamList ')'	{

					FoundDfNodeCtor();}

OtherBaseList : OtherBaseList ',' OtherBase

	| OtherBase

OtherBase : BaseType NAME '(' ParamList ')'	{ FoundOtherCtor($1,$2,$4);}

	| NAME '(' ParamList ')'		{ FoundOtherCtor(0,$1,$3);}

BaseType : PUBLIC			{$$=PUBLIC ;}

	| PRIVATE			{$$=PRIVATE;}

	| PROTECTED			{$$=PROTECTED;}

Public : PUBLIC 			{MarkPublicBaseFunction();}
	|

BaseFunctionName : NAME 		{FoundBaseFunctionName($1);}

	|				{FoundBaseFunctionName(DefBaseName);}

Expression :  Expression '%' Expression		{$$=Exp($1,'%',$3);} 
	| Expression '/' Expression		{$$=Exp($1,'/',$3);}	
	| Expression '*' Expression		{$$=Exp($1,'*',$3);}	
	| Expression '+' Expression		{$$=Exp($1,'+',$3);}	
	| Expression '-' Expression		{$$=Exp($1,'-',$3);}	
	| Expression SHIFT_R Expression		{$$=Exp($1,">>",$3);}	
	| Expression SHIFT_L Expression		{$$=Exp($1,"<<",$3);}	
	| Expression LEQ Expression		{$$=Exp($1,"<=",$3);}	
	| Expression GEQ Expression		{$$=Exp($1,">=",$3);}	
	| Expression '<' Expression		{$$=Exp($1,'<',$3);} 
	| Expression '>' Expression		{$$=Exp($1,'>',$3);}	
	| Expression EQU Expression		{$$=Exp($1,"==",$3);}	
	| Expression NEQ Expression		{$$=Exp($1,"!=",$3);}	
	| Expression '&' Expression		{$$=Exp($1,'&',$3);}	
	| Expression '^' Expression		{$$=Exp($1,'^',$3);}	
	| Expression '|' Expression		{$$=Exp($1,'|',$3);}	
	| Expression AND Expression		{$$=Exp($1,"&&",$3);}	
	| Expression OR Expression		{$$=Exp($1,"||",$3);}	
	| Expression '?' Expression		{$$=Exp($1,'?',$3);}	
	| Expression ':' Expression		{$$=Exp($1,':',$3);}	
	| Expression '.' Expression		{$$=Exp($1,'.',$3);}
	| Expression ARROW Expression		{$$=Exp($1,"->",$3);}
	| '+' Primary				{$$=Unary('+',$2);}
	| '-' Primary				{$$=Unary('-',$2);}
	| '*' Primary				{$$=Unary('*',$2);}
	| '&' Primary				{$$=Unary('&',$2);}
	| Primary				

Primary : Variable	
	| Number			{$$=MakeStringNumber($1);}	
	| '(' Expression ')'		{$$=Paren($2);}
	| '(' Expression ')' Name
					{$$=Cast($2,0,$4);}
	| '(' Expression Extra ')' Name
					{$$=Cast($2,$3,$5);}
	| '(' Expression ')' '(' Expression ')'
					{$$=Cast($2,0,Paren($5));}
	| '(' Expression Extra ')' '(' Expression ')'
					{$$=Cast($2,$3,Paren($6));}
	| '(' Type ')' '(' Expression ')'
					{$$=Cast($2,0,Paren($5));}
	| '(' Type Extra ')' '(' Expression ')'
					{$$=Cast($2,$3,Paren($6));}
	| String			{$$=MakeQuoteString($1);}
	| NEW Variable			{$$=Unary(NewReserved,$2);}
	| Variable '=' Expression 	{$$=Exp($1,'=',$3);}

Variable : DeclaredRef
	| DeclaredRef '(' ParamList ')'		{$$=Func($1,$3);}
	| DeclaredRef '[' ParamList ']' 	{$$=Array($1,$3);}
	| '(' Type Extra ')' DeclaredRef 	{$$=Cast($2,$3,$5);}
	| '(' Type ')' DeclaredRef		{$$=Cast($2,0,$4);}

Extra : '*'					{$$="*";}
	| '&'					{$$="&";}
	| Extra '*'				{$$=Concatenate($1,"*");}
	| Extra '&'				{$$=Concatenate($1,"&");}


Operator : '%' 			{$$=MakeOperatorString('%');}
	| '/' 			{$$=MakeOperatorString('/');}
	| '<' 			{$$=MakeOperatorString('<');}
	| '>' 			{$$=MakeOperatorString('>');}
	| '^' 			{$$=MakeOperatorString('^');}
	| '|' 			{$$=MakeOperatorString('|');}
	| '?' 			{$$=MakeOperatorString('?');}
	| ':' 			{$$=MakeOperatorString(':');}
	| '+' 			{$$=MakeOperatorString('+');}
	| '-' 			{$$=MakeOperatorString('-');}
	| '*' 			{$$=MakeOperatorString('*');}
	| '&'			{$$=MakeOperatorString('&');}
	| SHIFT_R 		{$$=MakeOperatorString(SHIFT_R);}
	| SHIFT_L 		{$$=MakeOperatorString(SHIFT_L);}
	| LEQ 			{$$=MakeOperatorString(LEQ);}
	| GEQ 			{$$=MakeOperatorString(GEQ);}
	| EQU 			{$$=MakeOperatorString(EQU);}
	| NEQ 			{$$=MakeOperatorString(NEQ);}
	| AND 			{$$=MakeOperatorString(AND);}
	| OR 			{$$=MakeOperatorString(OR);}

CtorParamList : Name '=' Expression 		{FoundCtorParam($1,$3);}
	| CtorParamList ',' Name '=' Expression {FoundCtorParam($3,$5);}
	|

ParamList : Expression 	
	| ParamList ',' Expression		{$$=Exp($1,',',$3);}
	|					{$$=Null();}

DeclaredRef : Name				{$$=MakeTree($1);}

MenuLine : MENU_LINE WORD_STRING EMBEDDED_TEXT_LINE   {$$=FoundMenuLine($2,$3);}

MenuLine : MENU_LINE EMBEDDED_TEXT_LINE {$$=FoundMenuLine("DspNodesMenu",$2);}

Instances : Instances INSTANCE Instance ';'

	| NO_DEFAULT_INSTANCE ';'			{NoDefaultInstance();}
	
	| 

Instance : Name '(' ConstantList ')' InstanceDescription {

						FoundNodeInstance($1,$3,$5);}

ConstantList : ConstantList ',' Constant	{$$=FoundConstant($1,$3);}

	| Constant 				{$$=FoundConstant($1);}

Constant : SignedNumber
	
	| String				{$$ = MakeTree($1);}

InstanceDescription : Description
	
	|					{$$=NullDescription();}

Description : MenuLine FullDescription HelpFile	{$$=ShortLongDesc($1,$2,$3);}

	| MenuLine FullDescription		{$$=ShortLongDesc($1,$2,0);}

FullDescription : DESCRIPTION EMBEDDED_TEXT	{$$=$2;}

BaseDescription : BASE_DESCRIPTION EMBEDDED_TEXT {$$=$2;}

StaticDeclare : STATIC_DECLARE '{' StaticDeclareList '}'

	|

StaticDeclareList : StaticDeclareList StaticDeclareElement

	| StaticDeclareElement

StaticDeclareElement : Type NAME '[' Expression ']'  ';'

		{FoundStaticArray($1,$2,$4);}

	| Type NAME ';' {FoundStaticScalar($1,$2);}


StaticInit : STATIC_INIT Cpp			{FoundStaticInit($2);}

	|					{NoStaticInit();}

Ctor : CONSTRUCTOR Cpp				{FoundCtor($2);}

	|					{FoundCtor(0);}

Dtor : DESTRUCTOR Cpp				{FoundDtor($2);}

	|					{FoundDtor(0);}

Safe : SAFE_DELETE Cpp				{FoundCheckSafeDelete($2);}

	|					{FoundCheckSafeDelete(0);}

Timing : TIMING Cpp				{FoundTiming($2);}

	| TIMING '(' Name ',' Name ')' Cpp	{FoundTiming($3,$5,$7);}

	| TIMING '('  ',' Name ')' Cpp		{FoundTiming(0,$4,$6);}

	| TIMING '(' Name ',' ')' Cpp		{FoundTiming($3,0,$6);}

	|					{NoTiming();}

StateEmit : STATE_EMIT Cpp			{FoundStateEmit($2);}

	|					{FoundStateEmit(0);}

Kernel : KERNEL Cpp				{FoundKernel($2);}
	
	|

Name : NAME

	| NAME DOUBLE_COLON NAME		{$$=Concatenate($1,"::",$3);}

SignedNumber : INTEGER_VAL			{$$=MakeIntItem($1);}
	| DOUBLE_VAL				{$$=MakeDoubleItem($1);}
	| '(' SignedNumber ',' SignedNumber ')'	{$$=MakeComplexItem($2,$4);}
	| '-' INTEGER_VAL			{$$=MakeNegIntItem($2);}
	| '-' DOUBLE_VAL			{$$=MakeNegDoubleItem($2);}
	| '-' '(' SignedNumber ',' SignedNumber ')'
					{$$=MakeSignedComplexItem($3,$5);}

Number : INTEGER_VAL				{$$=MakeIntItem($1);}
	| DOUBLE_VAL				{$$=MakeDoubleItem($1);}

String : STRING_VAL

Cpp : CPP_CODE 

