/*
 *  yacintfc.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef YACINTFC_DOT_H
#define YACINTFC_DOT_H
/*  yacintfc.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <iostream.h>
#include <stdio.h>

#include "ObjProDSP/portable.h"
#include "ObjProGui/yachead.h"
#include "ObjProGen/slist.h"
#include "ObjProComGui/help.h"
#include "ObjProComGui/usercom.h"
#include "ObjProGen/usriotyp.h"
#include "ObjProGen/stdyc.h"

class ParameterList: public SingleList {
const char * Name ; 		// procedure, array or class name
public:
	ErrCode Insert(ValueType *nt) {return SingleList::Insert(nt);}
	ErrCode Append(ValueType  *nt) {return SingleList::Append(nt);}
	ValueType  * Get()   {return (ValueType  *) SingleList::Get();}
	ParameterList();
	int Size(){return SingleList::Size();}
	void SetName(const char * nm) {Name = nm;}
	const char * GetName() {return Name;}
	void Dump(OutTokens&,ValueTypeList*) ;
	void Clear() {SingleList::Clear();}
} ;

class ParameterListIterator: public SingleListIterator {
public:
	ParameterListIterator(ParameterList& df):
		SingleListIterator((SingleList&) df){}
	ValueType * operator()()
		{return (ValueType *) Next();}
};

enum OverflowAction {OverflowIgnore, OverflowWarn, OverflowAbort};

class CommandState {
	char StateSavedFlag ;
	char ExitCommandFlag ;
	char SemanticErrorFlag ;
	char PreviousErrorFlag ;
	int Period ;
	int CountForPeriod ;
	int InParse ;
	int InParseStart ;
	int InParseWaitRead ;
	int OverwriteFlag ;
	int Interactive ;
	static const int warn_limit ;
	int warn_count ;
	int X_windows ;
	int InNetEdit ;
	int Exiting ;
	const char *SaveFileName ; // file in which state is saved
	int VersionsSaved ;	   // number of versions to retain
	FILE * TheFile ;	   // file being read to the parser
	int LineCount ;		   // for TheFile
	int ReturnId ;		   // interface id for TheFile
	const char * the_log_file ;
	OverflowAction TheOverflowAction ;
public:
	CommandState () ;
	void SetFileName(const char * name) {SaveFileName = name;}
	const char *GetFileName() {return SaveFileName;}
	int GetVersions() const {return VersionsSaved;}
	void SetDoExit() {ExitCommandFlag = 0 ;}
	void ClearDoExit() {ExitCommandFlag = 1;}
	int DoNotExit() { return ExitCommandFlag;}
	int IsVerbose() {return HelpDo.Confirm();}
	int IsConfirm() {return HelpDo.Confirm();}
	int IsNoHelp() {return HelpDo.No();}
	int IsHelpAll() {return HelpDo.All();}
	void SetStateSaved() {StateSavedFlag=1;}
	void ClearStateSaved() {StateSavedFlag=0;}
	int IsStateSaved() {return StateSavedFlag;}
	void SetError() {SemanticErrorFlag = PreviousErrorFlag = 1;}
	void ClearError() {SemanticErrorFlag = 0;}
	int IsError() {return SemanticErrorFlag; }
	int IsPreviousError() {return PreviousErrorFlag;}
	int IsX() const {return X_windows;}
	void SetX() {X_windows =1;}
	void SavePeriod() ;
	void DisplaySaveFileName(OutputType=OutputHelp, const char * nm=0);
	void SetSaveFileName();
	
	void DoingThis(const char * a, const char * b =0, const char * c=0,
		const char *  d=0);
	
	void Error(const char * a, const char * b =0, const char * c=0,
		const char *  d=0, const char * e=0, const char * f =0,
		const char * g = 0, const char * h=0);

	void Warning(const char * a, const char * b =0, const char * c=0,
		const char *  d=0, const char * e=0, const char * f =0,
		const char * g = 0, const char * h=0);
	void clear_warn(int list=0);

	void Aborting() ;
	void Exit() ;
	void Save() ;
	void SaveAs();
	void ListInt();
	void ListDouble();
	void ListComplex();
	void ListMachWord();
	void ListAccMachWord();
	void ListCxMachWord();
	void ListCxAccMachWord() ;
	void ListObject();
	void ListObjects();
	void ListClasses();
	void ListBaseClasses();
	void SetInParseStart() ;
	void SetInParseRead() ;
	void SetInParse() ;
	void ClearInParse() ;
	int IsInParse() {return InParse;}
	int IsInParseContinue() ;
	int IsInParseWaitRead() {return InParseWaitRead;}
	int IsInParseBeginWaitRead() ;
	int IsInOverwrite() {return OverwriteFlag;}
	void SetOverwrite() {OverwriteFlag=1;}
	void ClearOverwrite() {OverwriteFlag=0;}
	void SetInteractive() {Interactive=1;}
	void ClearInteractive() {Interactive=0;}
	int IsInteractive() {return Interactive;}
	void ReadFile(const char * Name, int OverwriteFlag, int ReturnId);
	const char * ReadLocalFile(InputType type);
	void CloseFile() ;
	void SaveInit(const char * FileName);
	int OverWarn() {return TheOverflowAction >= OverflowWarn;}
	int OverAbort() {return TheOverflowAction >= OverflowAbort;}
	int is_exiting() {return Exiting;}
	void set_exiting() {Exiting = 1 ;}
	void log_file(const char *file) {the_log_file = file;}
	const char * log_file () const { return the_log_file;}
	void SetNetEdit() {InNetEdit=1;}
	void ClearNetEdit() {InNetEdit=0;}
	int IsNetEdit() const {return InNetEdit;}
} ;

extern CommandState State ;

extern ValueType * Declare(ValueType*,ValueType*,
	int Size=0);
extern ValueType * DeclarePtr(ValueType*,ValueType*,
	ValueType*);
extern ValueType * CommaDeclare(ValueType*,ValueType*);

extern ValueType * MakeIntValue(int32);
extern ValueType * MakeFloatValue(double);
extern ValueType * MakeStringValue(const char *);
extern ValueType * ReturnStringValue(const char *);
extern ValueType * BinOp(ValueType*,int,ValueType*);
extern ValueType * UnOp(int,ValueType*);
extern ValueType * Equal(ValueType*,ValueType*,int op=0);
extern ValueType * InsureValueExists(ValueType*);

extern ValueType * DoDeclare(ValueType*) ;
extern ValueType * DoDeclareLval(ValueType*) ;

extern ValueType * DoParameterList(ValueType*,ValueType*);
extern ValueType * DoParameter(ValueType*);
extern ValueType * DoConstructor(ValueType*,ValueType*);
extern ValueType * DoProcedure(ValueType*,ValueType*);
extern ValueType * MemberRef(ValueType*,ValueType*);
extern ValueType * CheckLegal(ValueType*);
extern ValueType * NameOfList(ValueType*,ValueType*);

void CommandMain();

enum SemanticErrors {ErrorSimpleDeclare,ErrorNoArrays} ;
extern void SemanticError(SemanticErrors) ;


#endif /* #ifdef YACINTFC_DOT_H */
