# ifndef Collection_r
# define Collection_r

# include "Object.r"

struct Collection { const struct Object _;
	const void ** buf;
	unsigned dim;
};

struct CollectionClass { const struct Class _;
	struct Method add;
	struct Method find;
	struct Method count;
	struct Method apply;
};

struct Object * super_add (const void * _class, void * _self, const void * element, va_list * app);
struct Object * super_find (const void * _class, const void * _self, const void * element);
unsigned super_count (const void * _class, const void * _self);
int super_apply (const void * _class, const void * _self, Action action, va_list * app);

#ifndef	MINDIM
#define	MINDIM	32
#endif

#define	dim(c)	(((const struct Collection *) c) -> dim)
#define	buf(c)	(((const struct Collection *) c) -> buf)

# endif
