/* --------------------------------- mouse.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Handler for the mouse as a pointing device.
*/

#include "fly.h"

#include <graphics.h>
#include <mouse.h>


#define USELOG		0x0001		/* log scale on x/y (default) */

#define PO		p->opt
#define FA1D		PO[0]
#define FA1F		PO[1]
#define FA2D		PO[2]
#define FA2F		PO[3]
#define FSPEEDX		PO[4]
#define FSPEEDY		PO[5]
#define FOPTS		PO[6]

static int	speed = 2;

static int FAR
MUcal (POINTER *p)
{
	MouseWarp (GrMaxX()/2, GrMaxY()/2);
	p->a[FA1F] = p->a[FA2F] = 0;
	p->l[FA1F] = p->l[FA2F] = 0;
	return (0);
}

static int FAR
MUinit (POINTER *p, char *options)
{
	long		l;

	MouseSetSpeed (speed);
	p->flags |= PF_INITED;

	if (get_narg (options, "sx=", &l))
		FSPEEDX = 2;
	else
		FSPEEDX = (int)l;

	if (get_narg (options, "sy=", &l))
		FSPEEDY = 2;
	else
		FSPEEDY = (int)l;

	if (get_arg (options, "linear"))
		FOPTS &= ~USELOG;
	else
		FOPTS |= USELOG;

	MUcal (p);

	return (0);
}

static void FAR
MUterm (POINTER *p)
{
	p->flags = 0;
}

static int FAR
MUread (POINTER *p, int transfer)
{
	MouseEvent	event[1];
	char		btn[2];
	int		reading;

	MouseGetEvent (M_POLL|M_NOPAINT, event);

	reading = GrMaxX();
	reading = muldiv (event->x, 200, reading) - 100;	/* x */
	reading *=  -PO[0];
	p->a[FA2F] = reading;
	if (transfer)
		p->l[FA2F] = (FOPTS & USELOG) ? lin2log (reading) : reading;

	reading = GrMaxY();
	reading = muldiv (event->y, 200, reading) - 100;	/* y */
	reading *=  PO[2];
	if (transfer)
		p->l[FA1F] = (FOPTS & USELOG) ? lin2log (reading) : reading;

	btn[0] = event->buttons & M_LEFT;		/* right button */
	btn[1] = event->buttons & M_RIGHT;		/* left button */

	do_btns (p, btn, sizeof (btn));

	return (0);
}

struct PtrDriver NEAR PtrMouse = {
	"MOUSE",
	0,
	NULL,	/* extra */
	MUinit,
	MUterm,
	MUcal,
	MUcal,			/* center */
	MUread,
	std_key
};
