.ad l
.nh
.TH segment 1 "10 April 1993" "ImageMagick"
.SH NAME
segment - segments an image with thresholding and the fuzzy c-Means
technique.
.SH SYNOPSIS
.B "segment"
[ \fIoptions\fP ... ] \fIinput_file\fP \fIoutput_file\fP
.SH DESCRIPTION
\fBsegment\fP segments an image by analyzing the histograms of the color
components and identifying units that are homogeneous with the fuzzy c-means
technique.  The scale-space filter analyzes the histograms of the three
color components of the image and identifies a set of classes.  The
extents of each class is used to coarsely segment the image with
thresholding.  The color associated with each class is determined by
the mean color of all pixels within the extents of a particular class.
Finally, any unclassified pixels are assigned to the closest class with
the fuzzy c-means technique.
.PP
The fuzzy c-Means algorithm can be summarized as follows:
.RS
.LP
o Build a histogram, one for each color component of the image.
.LP
o For each histogram, successively apply the scale-space filter and
build an interval tree of zero crossings in the second derivative at
each scale.  Analyze this scale-space ``fingerprint'' to determine
which peaks or valleys in the histogram are most predominant.
.LP
o The fingerprint defines intervals on the axis of the histogram.  Each
interval contains either a minima or a maxima in the original signal.
If each color component lies within the maxima interval, that pixel is
considered ``classified'' and is assigned an unique class number.
.LP
o Any pixel that fails to be classified in the above thresholding pass is
classified using the fuzzy c-Means technique.  It is assigned to one
of the classes discovered in the histogram analysis phase.
.RE
.PP
The fuzzy c-Means technique attempts to cluster a pixel by finding the local
minima of the generalized within group sum of squared error objective
function.  A pixel is assigned to the closest class of which the fuzzy
membership has a maximum value.

For additional information see
.IP
Young Won Lim, Sang Uk Lee, "On The Color Image Segmentation Algorithm Based
on the Thresholding and the Fuzzy c-Means Techniques", Pattern Recognition,
Volume 23, Number 9, pages 935-952, 1990.
.SH EXAMPLES
.PP
To segment an image of a cockatoo, use:
.PP
.B
     segment cockatoo.miff cockatoo.segmented
.PP
To segment a raw grayscale image, use:
.PP
.B
     segment -geometry 768x512 gray:raw image.miff
.SH OPTIONS
.TP 5
.B "-alpha"
store alpha channel if the image has one.
.TP 5
.B "-colorspace \fIvalue\fP"
the type of colorspace: \fBGRAY\fP, \fBRGB\fP, \fBXYZ\fP, \fBYCbCr\fP,
\fBYIQ\fP, or \fBYUV\fP.

Color reduction, by default, takes place in the RGB color space.
Empirical evidence suggests that distances in color spaces such as YUV
or YIQ correspond to perceptual color differences more closely
than do distances in RGB space.  These color spaces may give better
results when color reducing an image.  Refer to \fBquantize(9)\fP for
more details.
.TP 5
.B "-compress \fItype\fP"
the type of image compression: \fIQEncoded\fP or \fIRunlengthEncoded\fP.

Specify \fB\+compress\fP to store the binary image in an uncompressed format.
The default is the compression type of the specified image file.
.TP 5
.B "-density \fI<width>x<height>
vertical and horizonal density of the image.

This option specifies an image density whose interpretation changes
with the type of image.  The default is 72 dots per inch in the
horizonal and vertical direction for Postscript.  Text files default to
80 characters in width and 60 lines in height.  Use this option to
alter the default density.
.TP 5
.B "-display \fIhost:display[.screen]\fP"
specifies the X server to contact; see \fBX(1)\fP.
.TP 5
.B "-font \fIname\fP"
This option specifies the font to be used  for displaying normal text.
The default is \fBfixed\fP.
.TP 5
.B "-geometry \fI<width>x<height>\fP"
the width and height of the image.  

Use this option to specified the width and height of raw images whose
dimensions are unknown such as \fBGRAY\fP, \fBRGB\fP, and \fBCMYK\fP.
This option can also change the default 8.5 by 11 width and height of
the Postscript canvas.
.TP 5
.B "-interlace \fItype\fP"
the type of interlacing scheme: \fBNONE\fP, \fBLINE\fP, or \fBPLANE\fP.

This option is used to specify the type of interlacing scheme for raw
image formats such as \fBRGB\fP or \fBYUV\fP.  \fBNONE\fP means do not
interlace (RGBRGBRGBRGBRGBRGB...), \fBLINE\fP uses scanline
interlacing (RRR...GGG...BBB...RRR...GGG...BBB...), and \fBPLANE\fP uses
plane interlacing (RRRRRR...GGGGGG...BBBBBB...).
.TP 5
.B "-page \fI<width>x<height>{\+-}<x offset>{\+-}<y offset>\fP"
preferred size and location of the Postscript page.

Use this option to specify the dimensions of the Postscript page in picas.  The
default is to center the image on a letter page, 612 by 792 picas.
Other common sizes are:

    540x720   Note
    612x1008  Legal
    842x1190  A3
    595x842   A4
    421x595   A5
    297x421   A6
    709x1002  B4
    612x936   U.S. Foolscap
    612x936   European Foolscap
    396x612   Half Letter
    792x1224  11x17
    1224x792  Ledger

The page geometry is relative to the vertical and horizonal density of the
Postscript page.  See \fB-density\fP for details.
.TP 5
.B "-quality \fIvalue\fP"
JPEG quality setting.

Quality is 0 (worst) to 100 (best). The default is 75.
.TP 5
.B "-scene \fIvalue\fP"
image scene number.
.TP 5
.B -verbose
print detailed information about the image.

This information is printed: image scene number;  image name;  converted
image name;  image size;  the image class (\fIDirectClass\fP or 
\fIPseudoClass\fP);  the total number of unique colors;  and the number
of seconds to read and convert the image.
.PP
Change '-' to '+' in any option above to reverse its effect.  For
example, specify +alpha to store the image without its alpha channel.
.PP
By default, the image format is determined by its magic number. To
specify a particular image format, precede the filename with an image
format name and a colon (i.e. ps:image) or specify the image type as
the filename suffix (i.e. image.ps).  See \fBconvert(1)\fP for a list
of valid image formats.
.PP
When you specify \fBX\fP as your image type, the filename has special
meaning.  It specifies an X window by id, name, or \fBroot\fP.  If no
filename is specified, the window is selected by clicking the mouse in
the desired window.
.PP
Specify \fIinput_file\fP as \fI-\fP for standard input,
\fIoutput_file\fP as \fI-\fP for standard output.  If \fIinput_file\fP
has the extension \fB.Z\fP or \fB.gz\fP, the file is uncompressed with
\fBuncompress\fP or \fBgunzip\fP respectively.  If \fIoutput_file\fP
has the extension \fB.Z\fP or \fB.gz\fP, the file size is compressed
using with \fBcompress\fP or \fBgzip\fP respectively.  If
\fIoutput_file\fP already exists, you will be prompted as to whether it
should be overwritten.
.SH ENVIRONMENT
.PP
.TP 5
.B display
To get the default host, display number, and screen.
.SH SEE ALSO
.B
display(1), animate(1), mogrify(1), quantize(9), X(1), miff(5)
.SH COPYRIGHT
Copyright 1993 E. I. du Pont de Nemours & Company
.PP
Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of E. I. du Pont de Nemours
& Company not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.  E. I. du Pont de Nemours & Company makes no representations
about the suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
.PP
E. I. du Pont de Nemours & Company disclaims all warranties with regard
to this software, including all implied warranties of merchantability
and fitness, in no event shall E. I. du Pont de Nemours & Company be
liable for any special, indirect or consequential damages or any
damages whatsoever resulting from loss of use, data or profits, whether
in an action of contract, negligence or other tortious action, arising
out of or in connection with the use or performance of this software.
.SH ACKNOWLEDGEMENTS
Andy Gallo, University of Delaware.  This software is strongly based on
software Andy wrote.
.SH AUTHORS
John Cristy, E.I. du Pont De Nemours & Company Incorporated
