/*
 * seejpg.c
 *
 * Copyright (C) 1993, 1994 Evan Harris
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

#include "seejpeg.h"
#include <string.h>
#include <getopt.h>
#include <vga.h>

#define VERSION "seejpeg version 1.4.2"

int opt_greyscale = 0, opt_quantize = 0, opt_verbose = 0, opt_widthonly = 0;
int opt_onepass = 0, opt_forcemode = TEXT, opt_doublex = 0, opt_doubley = 0;
int opt_slideshow = -1, opt_cycle = 0;
double opt_fuzz = 1.0;


int
main(int argc, char **argv)
{
    int c, arg, err = 0;
    char *errstr = NULL, *forcemodestr = NULL;
    char *ch;
  
    while ((c = getopt(argc, argv, "1d:f:gqs:vwCF:")) != -1) {
	switch (c) {
	  case '1':
	    opt_onepass = 1;
	    break;
	  case 'd':
	    for (ch = optarg; *ch != '\0'; ch++) {
		switch (*ch) {
		  case 'x':
		    opt_doublex = 1;
		    break;
		  case 'y':
		    opt_doubley = 1;
		    errstr = "doubling in Y direction not yet fully implemented";
		    break;
		  default:
		    errstr = "can only double image in x or y direction";
		    break;
		}
	    }
	    break;
	  case 'f':
	    opt_fuzz = atof(optarg);
	    if (opt_fuzz < 0.5 || opt_fuzz > 1.0) {
		errstr = "fuzz factor must be in range [0.5,1.0]";
	    }
	    break;
	  case 'g':
	    opt_greyscale = 1;
	    break;
	  case 'q':
	    opt_quantize = 1;
	    break;
	  case 'v':
	    opt_verbose = 1;
	    break;
	  case 'w':
	    opt_widthonly = 1;
	    break;
	  case 'C':
	    opt_cycle = 1;
	    break;
	  case 'F':
	    forcemodestr = optarg;
	    break;
	  case 's':
	    opt_slideshow = atoi(optarg);
	    if (opt_slideshow < -1) {
		errstr = "slideshow waiting time must not be negative";
	    }
	    break;
	  case '?':
	    err++;
	    break;
	}
    }
  
    if (!opt_verbose) {
	vga_disabledriverreport();
    }

    vga_init();

    if (errstr != NULL) {
	fprintf(stderr, "Error: %s\n", errstr);
	exit(1);
    }

    if (forcemodestr != NULL) {
	opt_forcemode = vga_getmodenumber(forcemodestr);
	switch (opt_forcemode) {
	  case G1280x1024x256:
	  case G1024x768x256:
	  case G800x600x256:
	  case G640x480x256:
	  case G320x200x256:
	    opt_quantize = 1;
	    break;
	  case G1280x1024x16M:
	  case G1024x768x16M:
	  case G800x600x16M:
	  case G640x480x16M:
	  case G320x200x16M:
	  case G1280x1024x32K:
	  case G1024x768x32K:
	  case G800x600x32K:
	  case G640x480x32K:
	  case G320x200x32K:
	    break;
	  default:
	    fprintf(stderr, "Error: unknown/unsupported mode name '%s'\n",
		    forcemodestr);
	    break;
	}
    }

    if (err || argc - optind == 0) {
	fprintf(stderr, VERSION"\n");
	fprintf(stderr,
		"Usage: %s [-1gqvwC] [-dx] [-f fuzz] [-s time] [-F mode] {file} ...\n",
		argv[0]);
	fprintf(stderr, "\t-1   one pass quantization (-q implicit)\n");
	fprintf(stderr, "\t-dx  double the image in the x direction\n");
	fprintf(stderr, "\t-f   set fuzz factor to determine video mode\n");
	fprintf(stderr, "\t-g   force greyscale mode (-1 implicit)\n");
	fprintf(stderr, "\t-q   quantize picture (256 colour mode)\n");
	fprintf(stderr,
		"\t-s   slideshow, wait {time} seconds between images\n");
	fprintf(stderr, "\t-v   verbose\n");
	fprintf(stderr, "\t-w   only use width to determine video mode\n");
	fprintf(stderr, "\t-C   cycle through pictures\n");
	fprintf(stderr, "\t-F   force the use of {mode} video mode\n");
	fprintf(stderr, "File types supported: JPEG, GIF, PPM, TARGA\n");
	exit(1);
    }

    do {
	for (arg = optind; arg < argc; arg++) {
	    if (opt_verbose) {
		printf("File   : %s\n", argv[arg]);
	    }
	    err = read_image_file(argv[arg]);
	    if (opt_verbose) {
		if (err != 1) {
		    printf("Error reading image\n");
		} 
	    }
	}
    } while (opt_cycle);
    display_shutdown();

    return 0;
}
