/* ZGV v1.3 - (c) 1993 Russell Marks for improbabledesigns.
 * See README for license details.
 *
 * vgadisp.c - vga specific display routines.
 */


#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <malloc.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/file.h>
#include <vga.h>
#include "gifeng.h"
#include "usejpeg.h"
#include "readnbkey.h"
#include "handlevt.h"
#include "helppage.h"
#include "3deffects.h"



/* This 'default' is ONLY used by the 'mode sel' code when you switch from,
 * say, a 1-bit mono picture to a 256-colour one. (If you haven't got -
 * or svgalib doesn't support - a 640x480x256 mode on your card then it
 * falls back on 360x480x256. Let's not talk about laptops for now, ok? :)
 */
#define DEFAULTMODE G640x480x256
#define DEFAULTVIRT 0

int curvgamode=DEFAULTMODE;
int zoom=0,virtual=DEFAULTVIRT;
int vkludge=0,modesel=0;
static int isjpeg;

char viewerhelp[][80]={
  "Question mark \t this help page\0",
  "1 to 9 \t\t mode change\0",
#ifndef HANDS_ON_VC_CODE    /* ...then we're using the fkeys for svga modes */
  "F1 - F10  SF1 - SF10 \t SVGA mode change (try these first)\0",
#endif
  "0 \t\t\t toggle virtual mode\0",
  "v \t\t\t toggle smoothing in virtual modes\0",
  "comma / dot \t contrast down/up\0",
  "left / right chevron \t brightness down/up\0",
  "asterisk \t\t reset contrast and brightness\0",
  "z \t\t\t toggle zoomed mode\0",
  "r \t\t\t rotate clockwise 90 degs\0",
  "m \t\t\t mirror\0",
  "f \t\t\t flip\0",
#ifdef HANDS_ON_VC_CODE
  "F1 to F8 \t\t change virtual console\0",
#endif
  "Esc or x \t\t exit the viewer\0",
  " \0",
  "hjkl or qaop keys scroll around the picture\0",
  "HJKL or QAOP (also the cursor keys) scroll in bigger steps\0",
  "\0"
  };



struct {
  int rgb;
  byte col;
  } vkcache[65536];

#define MOVSTP 10    /* for q,a,o,p panning */
#define BIGSTP 100   /* for Q,A,O,P panning (i.e. with shift) */

byte *theimage;   /* quite slow if passed as parameter */
int width,height,numcols; /* same here */

double contrast=1.0;  /* note that double contrast is in fact 2 :) */
int brightness=0;
int scrnwide,scrnhigh,realscrnwide;

int palr[256],palg[256],palb[256];
byte palr64[256],palg64[256],palb64[256];
int palrgb[768];

int ttyfd;


int readgiforjpg(char *,hffunc);


int readgiforjpg(giffn,howfarfunc)
char *giffn;
hffunc howfarfunc;
{
int result;
GIFINFO ginfo;
byte *palette;

/* at this stage, we know it ends in either .gif or .jpg */
if(!strcmp(strrchr(giffn,'.'),".jpg"))
  {
  isjpeg=1;
  ginfo.numcols=256;
  theimage=NULL;
  result=read_JPEG_file(giffn,howfarfunc,&palette);
  /* if error, then palette has already been nuked */
  if(theimage==NULL)
    result=0;
  else
    if(result==0) free(theimage);
  }
else
  {
  isjpeg=0;
  result=readgif(giffn,&theimage,&palette,howfarfunc);
  if(result==_GIF_OK)
    {
    getgifinfo(&ginfo);
    height=ginfo.height; width=ginfo.width;
    }
  }

if(((isjpeg)&&(result==1))||((!isjpeg)&&(result==_GIF_OK)))
  {
  numcols=ginfo.numcols;
  if(((curvgamode<5)||(curvgamode==9))&&(ginfo.numcols>16))
    { curvgamode=DEFAULTMODE; virtual=DEFAULTVIRT; }
  if(!isjpeg) fixcurmode(&ginfo);
  showgif(palette);
  free(theimage);
  free(palette);
  }
/* when is a result not a result? */
if(isjpeg)
  {
  result=!result;
  if(result!=0) result=_GIFERR_SHOWN_ALREADY;
  }
return(result);
}


is_this_file_jpeg()
{
return(isjpeg);
}


makerealpal(palette)
byte *palette;
{
int f;

for(f=0;f<256;f++)
  {
  palrgb[f*3  ]=palr64[f]=palr[f]>>2;
  palrgb[f*3+1]=palg64[f]=palg[f]>>2;
  palrgb[f*3+2]=palb64[f]=palb[f]>>2;
  }
}


fixcurmode(ginfo)
GIFINFO *ginfo;
{
if(!modesel) return;
if(ginfo->numcols<=16)
  {
  curvgamode=4;
  virtual=0;
  }
if((ginfo->width==320)&&(ginfo->height==200))
  {
  curvgamode=5;
  virtual=0;
  }
}


filterpal(palette)
byte *palette;
{
int f;

for(f=0;f<256;f++)   /* don't *really* need to know number of colours */
  {
  palr[f]=dimmer(contrastup(palette[    f]));
  palg[f]=dimmer(contrastup(palette[256+f]));
  palb[f]=dimmer(contrastup(palette[512+f]));
  }
makerealpal();
}


int dimmer(a)
int a;
{
a+=brightness;
if(a<0) a=0;
if(a>255) a=255;
return(a);
}


int contrastup(cp)
int cp;
{
float g;

g=(float)(cp);
g=128+(g-128)*contrast;
if(g<0)g=0;
if(g>255)g=255;
return((int)g);
}


graphicson()
{
int x;
vga_modeinfo *vmi;

/* workaround for svgalib bug */
vga_setmode(TEXT);
if(vga_hasmode(curvgamode))
  vga_setmode(curvgamode);
else
  {
  /* we haven't? Aaargh!!! Ok, use 640x480 or 360x480 instead.
   * This doesn't come under 'mode select' code, because we've got to
   * do *something*...
   */
  if(vga_hasmode(G640x480x256))
    {
    vga_setmode(curvgamode=G640x480x256);
    virtual=0;
    }
  else
    {
    vga_setmode(curvgamode=G360x480x256);
    virtual=1;
    }
  }
vmi=vga_getmodeinfo(curvgamode);
scrnwide=realscrnwide=vmi->width;
scrnhigh=vmi->height;
if(virtual)
  scrnwide*=2;
vga_setpalvec(0,256,palrgb);
if(vkludge)
  {
  for(x=0;x<65536;x++) vkcache[x].rgb=-1;
  /* these are fairly likely to crop up, so index them automatically */
  for(x=0;x<numcols;x++)
    closest(palr64[x],palg64[x],palb64[x]);
  }
}


graphicsoff()
{
vga_setmode(TEXT);
}


showgif(palette)   /* global theimage,height,width implied */
byte *palette;
{
int opx,opy,px,py,quitshow,key,redraw;

/* if image has less than 256 colours, we fill in the 64 greys so that
 * using the vkludge on, say, a mono file will look much better.
 * mind you, it doesn't appear to work very well...!
 */
if(numcols<256)
  {
  int f;
  for(f=numcols;f<numcols+64;f++) palr64[f]=palg64[f]=palb64[f]=f-numcols;
  }

vga_setflipchar('#');
px=py=quitshow=0;
filterpal(palette);
graphicson();
if((ttyfd=open("/dev/tty0",O_RDONLY|O_NONBLOCK))<0)
  {graphicsoff();
  printf("Couldn't get nonblocking read access to /dev/tty0.\n");
  exit(1);}  
redrawgif(px,py);

while(!quitshow)
  {
  usleep(10000);
  key=readnbkey(ttyfd);
  opx=px; opy=py; redraw=0;

#if HANDS_ON_VC_CODE
  /* if it's from F1 to F8, we switch consoles */
  if((key>=RK_F1)&&(key<=RK_F8))
    if(handlevt(ttyfd,key-RK_F1+1))
      {
      graphicson();
      redraw=1;
      }
#else
  /* svga modes - note that F11=shift-F1 and F12=shift-F2 */
  if(((key>=RK_F1)&&(key<=RK_F12))||(key>=RK_SHIFT_F3)&&(key<=RK_SHIFT_F10))
    /* the RK_F?'s are defined such that this sort of thing is ok to do: */
    if(vga_hasmode(key-RK_F1+10))
      {
      curvgamode=key-RK_F1+10;   /* so F1 = mode 10 */
      virtual=0;
      graphicson();
      redraw=1;
      }
#endif
  if((key>='0')&&(key<='9'))
    {
    if(key=='0')
      virtual=(virtual==1)?0:1;
    else
      {
      curvgamode=key-48;
      if((curvgamode==7)||(curvgamode==8)) virtual=1; else virtual=0;
      }
    graphicson();
    redraw=1;
    }
  else
    switch(key)
      {
      case 'v': vkludge=((vkludge==1)?0:1); redraw=1; graphicson(); break;
      case ',': contrast-=0.05;
        filterpal(palette); vga_setpalvec(0,256,palrgb); break;
      case '.': contrast+=0.05;
        filterpal(palette); vga_setpalvec(0,256,palrgb); break;
      case '<': brightness-=10;
        filterpal(palette); vga_setpalvec(0,256,palrgb); break;
      case '>': brightness+=10;
        filterpal(palette); vga_setpalvec(0,256,palrgb); break;
      case '*': contrast=1.0; brightness=0;
        filterpal(palette); vga_setpalvec(0,256,palrgb); break;
      case 'q': case 'k': py-=MOVSTP; break;
      case 'a': case 'j': py+=MOVSTP; break;
      case 'o': case 'h': px-=MOVSTP; break;
      case 'p': case 'l': px+=MOVSTP; break;
      case 'Q': case 'K': case RK_CURSOR_UP:    py-=BIGSTP; break;
      case 'A': case 'J': case RK_CURSOR_DOWN:  py+=BIGSTP; break;
      case 'O': case 'H': case RK_CURSOR_LEFT:  px-=BIGSTP; break;
      case 'P': case 'L': case RK_CURSOR_RIGHT: px+=BIGSTP; break;
      case 'm': fx_mirror(); px=py=0; redraw=1; break;
      case 'f': fx_flip();   px=py=0; redraw=1; break;
      case 'r': fx_rot();    px=py=0; redraw=1; break;
      case 'z':
        zoom=(!zoom); redraw=1; px=py=0; graphicson(); break;
      case 26:   /* ^Z */
        vga_setmode(TEXT);
        raise(SIGTSTP);
        graphicson(); redraw=1;
        break;
      case '?':
        showhelp(ttyfd,"- KEYS FOR FILE DISPLAY SCREEN -",viewerhelp);
        /* falls through to 'refresh screen' */
      case 12: case 18:     /* 12,18 = Ctrl-L, Ctrl-R */
        graphicson(); redraw=1; break;
      case RK_ESC: case 'x':
        quitshow=1;
      }
  if(!zoom)
    {
    if(height<=scrnhigh)
      py=0;
    else
      if(height-py<scrnhigh) py=height-scrnhigh;
    if(width<=scrnwide)
      px=0;
    else
      if(width-px<scrnwide) px=width-scrnwide;
    if(px<0) px=0;
    if(py<0) py=0;
    }
  else
    px=py=0;
  if((redraw)||(opx!=px)||(opy!=py)) redrawgif(px,py);
  }
graphicsoff();
close(ttyfd);
}


redrawgif(px,py)
int px,py;
{
int x,y,xdim;
byte *realline;
long place;

if(zoom)
  drawzoomedgif(height,width,theimage);
else
  {
  if(width-px<scrnwide) xdim=width-px; else xdim=scrnwide;
  if((py>=height)||(px>=width)) return(0);
  /* hopefully the following is fairly quick as fewer ifs... ? */
  if(virtual)
    {
    if((realline=malloc(scrnwide))==NULL) return(0);
    if(xdim==scrnwide)
      {for(y=0;(y<height-py)&&(y<scrnhigh);y++)
        {for(x=0;(x<width-px)&&(x<scrnwide);x++)
          *(realline+(x>>1))=getvpix(px,py,x,y);
        vga_drawscanline(y,realline);}}
    else
      {for(y=0;(y<height-py)&&(y<scrnhigh);y++)
        {for(x=0;x<xdim;x++)
          *(realline+(x>>1))=getvpix(px,py,x,y);
        vga_drawscansegment(realline,0,y,xdim>>1);}}
    free(realline);
    }
  else
    {
    if(xdim==scrnwide)
      {for(y=0;(y<height-py)&&(y<scrnhigh);y++)
        vga_drawscanline(y,theimage+(py+y)*width+px);}
    else
      {for(y=0;(y<height-py)&&(y<scrnhigh);y++)
        vga_drawscansegment(theimage+(py+y)*width+px,0,y,xdim);}
    }
  }
}


int getvpix(px,py,x,y)
int px,py,x,y;
{
int p1,p2,r,g,b;

if(vkludge)
  {
  p1=*(theimage+(py+y)*width+px+x);
  if(px+x+1>=width) return(p1);
  p2=*(theimage+(py+y)*width+px+x+1);
  r=(palr64[p1]+palr64[p2])>>1;
  g=(palg64[p1]+palg64[p2])>>1;
  b=(palb64[p1]+palb64[p2])>>1;
  return(closest(r,g,b));
  }
else
  return(*(theimage+(py+y)*width+px+x));
}


/* this routine is nasty writ big, but about as quick as I can manage */
drawzoomedgif()
{
register int a,b,x,yp,yw;
long y,sw,sh,lastyp;
int xoff,yoff;
int c,pixwide,pixhigh,pr,pg,pb;
long place;
int bigimage;
byte *rline;
int tmp1,tmp2,tr,tg,tb,tn;

if((rline=malloc(scrnwide))==NULL) return(0);
for(x=0;x<scrnwide;x++)
  rline[x]=0;

/* try landscapey */
sw=scrnwide; sh=(int)((scrnwide*((long)height))/((long)width));
if(sh>scrnhigh)
  /* no, oh well portraity then */
  { sh=scrnhigh; sw=(int)((scrnhigh*((long)width))/((long)height)); }

/* so now our zoomed image will be sw x sh */
bigimage=(width>sw)?1:0;   /* 1 if image has been reduced, 0 if made bigger */
if(bigimage)
  /* it's been reduced - easy, just make 'em fit in less space */
  {
  if(virtual) sw>>=1;
  lastyp=-1;
  graphicson();
  pixhigh=(int)(((float)height)/((float)sh)+0.5);
  pixwide=(int)(((float)width)/((float)sw)+0.5);
  /*if(pixhigh==0)*/ pixhigh++;
  /*if(pixwide==0)*/ pixwide++;
  for(y=0;y<height;y++)
    {
    yp=(y*sh)/height;
    if(yp!=lastyp)
      {
      yw=y*width;
      if(vkludge) /* we try to resample a bit. get that pentium RSN :) */
        {
        for(x=0;x<width;x++,yw++)
          {
          tr=tg=tb=tn=0;
          for(b=0;(b<pixhigh)&&(y+b<height);b++)
            for(a=0;(a<pixwide)&&(x+a<width);a++)
              {
              tmp2=*(theimage+yw+a+b*width);
              tr+=palr64[tmp2];
              tg+=palg64[tmp2];
              tb+=palb64[tmp2];
              tn++;
              }
          tr/=tn; tg/=tn; tb/=tn;
          rline[(x*sw)/width]=closest(tr,tg,tb);
          }
        }
      else
        for(x=0;x<width;x++,yw++)
          rline[(x*sw)/width]=*(theimage+yw);
      vga_drawscanline(yp,rline);  
      lastyp=yp;
      }
    }
  free(rline);
  }
else
  /* well, we need to fill in the gaps because it's been made bigger. */
  {
    /* a pixel from the original is now pixwide x pixhigh */
  pixwide=(int) ( (((float)sw)/((float)width )) +1.0 );
  pixhigh=(int) ( (((float)sh)/((float)height)) +1.0 );

  free(rline);  /* get rid of that... */
    /* and get a screen's worth... hahahahahahahahaha er, sorry. */
  if((rline=malloc(scrnwide*(scrnhigh+pixhigh)))==NULL) return(0);
    /* notice that we allow for a screwy 'pixhigh' value to avoid
       any nasty old segfaults! oh, now we wipe it: */
  for(x=0;x<scrnwide*scrnhigh;x++) rline[x]=0;
  
  if(virtual)
    sw>>=1;   /* leave pixwide though as it *might* miss with >> */
  for(y=0;y<height;y++)
    {
    yoff=(y*sh)/height;
    yw=y*width;
    for(x=0;x<width;x++,yw++)
      {
      c=*(theimage+yw);
      xoff=(x*sw)/width;
      for(b=0;b<pixhigh;b++)
        for(a=0;a<pixwide;a++)
          *(rline+(yoff+b)*scrnwide+xoff+a)=c;
      }
    vga_drawscanline(y,rline+y*scrnwide); /* really pessimistic */
    }
  for(;y<scrnhigh;y++)          /* and do the rest */
    vga_drawscanline(y,rline+y*scrnwide);
  free(rline);
  }
}


putrgbpixel(x,y,c)
int x,y,c;
{
vga_setcolor(c);
vga_drawpixel(x,y);
}


fx_mirror()
{
byte *tmp;
int x,y;

tmp=malloc(width*height);
if(tmp==NULL) return(0);
for(y=0;y<height;y++)
  for(x=0;x<width;x++)
    *(tmp+y*width+(width-x-1))=*(theimage+y*width+x);

free(theimage);
theimage=tmp;
}


fx_flip()
{
byte *tmp;
int x,y;

tmp=malloc(width*height);
if(tmp==NULL) return(0);
for(y=0;y<height;y++)
  for(x=0;x<width;x++)
    *(tmp+(height-y-1)*width+x)=*(theimage+y*width+x);

free(theimage);
theimage=tmp;
}


fx_rot()
{
byte *tmp;
int x,y;

tmp=malloc(width*height);
if(tmp==NULL) return(0);
for(y=0;y<height;y++)
  for(x=0;x<width;x++)
    *(tmp+(height-y-1)+x*height)=*(theimage+y*width+x);
x=height;y=width;
width=x;height=y;

free(theimage);
theimage=tmp;
graphicson(); /* clear screen 'cos image diff. size */
}


/* rgb values must be 0..63 */
/* because of course, only 6 bits of the rgb values actually count on VGA */
int closest(r,g,b)
int r,g,b;
{
int idx,rgb;
byte *pr,*pg,*pb;
register byte distnum;
register int xr,xg,xb,dist,distquan,f,checknumcols;

rgb=((b<<12)|(g<<6)|r);
idx=rgb&0xffff;
if(vkcache[idx].rgb==rgb)
  return(vkcache[idx].col);
distnum=0;
distquan=20000; /* standard arbitrary bignum */
/* if numcols=256 we do 0-255, otherwise 0-numcols+63 */
checknumcols=((numcols==256)?256:numcols+64);
for(pr=palr64,pg=palg64,pb=palb64,f=0;f<checknumcols;f++,pr++,pg++,pb++)
  {
  xr=(r-*pr);
  xg=(g-*pg);
  xb=(b-*pb);
  if((dist=xr*xr+xg*xg+xb*xb)<distquan)
    {
    distnum=f;
    distquan=dist;
    if(dist==0) f=999;  /* premature exit if it can't get any better */
    }
  }
vkcache[idx].rgb=rgb;
return((int)(vkcache[idx].col=distnum));
}
