/* ZGV v2.0 - (c) 1993,1994 Russell Marks for improbabledesigns.
 * See README for license details.
 *
 * rcfile.c - config file handling.
 *	this will also handle cmdline args when I get around to it.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <vga.h>
#include "rc_config.h"

#define boolvalue(x) ((!strncmp(x,"on",2))?1:0)

struct zgv_config cfg;


 

getconfig()
{
FILE *in;
char cfgfile[1024];
int gotrcfile;

defaultcfg();

gotrcfile=0;
strcpy(cfgfile,getenv("HOME"));
strcat(cfgfile,"/.zgvrc");

if((in=fopen(cfgfile,"r"))!=NULL)
  gotrcfile=1;
else
  if((in=fopen("/etc/system.zgvrc","r"))!=NULL)
    gotrcfile=1;

if(gotrcfile)
  {
  parseconfig(in);
  fclose(in);
  }
}


parseconfig(in)
FILE *in;
{
char inpline[1024],*ptr;
int r,g,b,ln,f;

ln=0;
while(fgets(inpline,1024,in)!=NULL) 
  {
  ln++;
  if(inpline[strlen(inpline)-1]=='\n') inpline[strlen(inpline)-1]=0;
  if((ptr=strchr(inpline,'#'))!=NULL)
    *ptr=0;
  if(strlen(inpline)>0)
    {
    ptr=inpline;
    findtoken(&ptr);
    if(tokencompare(ptr,"zoom"))
      getbool(ptr,&cfg.zoom);
    else
    if(tokencompare(ptr,"jpeg24bit"))
      getbool(ptr,&cfg.jpeg24bit);
    else
    if(tokencompare(ptr,"vkludge"))
      getbool(ptr,&cfg.vkludge);
    else
    if(tokencompare(ptr,"black"))
      getrgbval(ptr,&cfg.black_r,&cfg.black_g,&cfg.black_b);
    else
    if(tokencompare(ptr,"dark"))
      getrgbval(ptr,&cfg.dark_r,&cfg.dark_g,&cfg.dark_b);
    else
    if(tokencompare(ptr,"medium"))
      getrgbval(ptr,&cfg.medium_r,&cfg.medium_g,&cfg.medium_b);
    else
    if(tokencompare(ptr,"light"))
      getrgbval(ptr,&cfg.light_r,&cfg.light_g,&cfg.light_b);
    else
    if(tokencompare(ptr,"contrast"))
      getdouble(ptr,&cfg.contrast);
    else
    if(tokencompare(ptr,"brightness"))
      getint(ptr,&cfg.brightness);
    else
    if(tokencompare(ptr,"allmodesbad"))
      for(f=0;f<256;f++) cfg.mode_allowed[f]=0;
    else
    if(tokencompare(ptr,"allmodesgood"))
      {
      /* we still disallow ones it hasn't got */
      for(f=0;f<31;f++)
        cfg.mode_allowed[f]=vga_hasmode(f)?1:0;
      }
    else
    if((tokencompare(ptr,"badmode"))||(tokencompare(ptr,"goodmode")))
      {
      if(getmodenumber(ptr,&f)==-1)
        {
        fprintf(stderr,"Mode not found on line #%d of rc file.\n",ln);
        exit(1);
        }
      cfg.mode_allowed[f]=tokencompare(ptr,"goodmode");
      }
    else
    if(tokencompare(ptr,"startmode"))
      {
      if(getmodenumber(ptr,&f)==-1)
        {
        fprintf(stderr,"Mode not found on line #%d of rc file.\n",ln);
        exit(1);
        }
      cfg.videomode=f;
      }
    else
      {
      fprintf(stderr,"Don't grok line #%d of rc file.\n",ln);
      exit(1);
      }
    }
  }
}


/* get mode number from something like '640 480 8' -
 * returns 0 if it can't find one that matches, else 1.
 * (the mode number is put into *mp)
 */
int getmodenumber(tptr,mp)
char *tptr;
int *mp;
{
int x,y,bpp,rtn;

/* skip past the current token */
tptr+=tokenlength(tptr);
findtoken(&tptr);
x=atoi(tptr);
tptr+=tokenlength(tptr);

findtoken(&tptr);
y=atoi(tptr);
tptr+=tokenlength(tptr);

findtoken(&tptr);
bpp=atoi(tptr);

rtn=modematch(x,y,bpp);
if(rtn>=0)
  {
  *mp=rtn;
  return(0);
  }
else
  return(-1);
}


getrgbval(tptr,rp,gp,bp)
char *tptr;
int *rp,*gp,*bp;
{
/* skip past the current token */
tptr+=tokenlength(tptr);
findtoken(&tptr);
*rp=atoi(tptr);
tptr+=tokenlength(tptr);

findtoken(&tptr);
*gp=atoi(tptr);
tptr+=tokenlength(tptr);

findtoken(&tptr);
*bp=atoi(tptr);
}


getbool(tptr,bp)
char *tptr;
int *bp;
{
/* skip past the current token */
tptr+=tokenlength(tptr);
findtoken(&tptr);
if((tokencompare(tptr,"on"))||(tokencompare(tptr,"y")))
  *bp=1;
else
  *bp=0;
}


getint(tptr,ip)
char *tptr;
int *ip;
{
/* skip past the current token */
tptr+=tokenlength(tptr);
findtoken(&tptr);
*ip=atoi(tptr);
}


getdouble(tptr,dp)
char *tptr;
double *dp;
{
/* skip past the current token */
tptr+=tokenlength(tptr);
findtoken(&tptr);
*dp=atof(tptr);
}


defaultcfg()
{
int f;

/* it'll use 360x480x256 if you haven't got 640x480x256,
 * and 320x200x256 if you've locked that out.
 */
cfg.videomode=G640x480x256;
cfg.zoom=0;
cfg.vkludge=0;
cfg.brightness=0;
cfg.jpeg24bit=1;	/* only if possible, of course */
cfg.contrast=(double)1;
cfg.black_r =cfg.black_g =cfg.black_b = 0;
cfg.dark_r  =cfg.dark_g  =cfg.dark_b  =20;
cfg.medium_r=cfg.medium_g=cfg.medium_b=30;
cfg.light_r =cfg.light_g =cfg.light_b =40;
for(f=0;f<256;f++) cfg.mode_allowed[f]=0;
for(f=0;f<31;f++)
  cfg.mode_allowed[f]=vga_hasmode(f)?1:0;
}


findtoken(ptr)
char **ptr;
{
while((*(*ptr)!=0)&&(strchr(" \t",*(*ptr))!=NULL))
  (*ptr)++;
}


int tokenlength(ptr)
char *ptr;
{
int siz;

siz=0;
while((*ptr!=0)&&(strchr(" \t",*ptr)==NULL))
  {
  ptr++;
  siz++;
  }

return(siz);
}


/* returns 1 if equal, 0 otherwise */
int tokencompare(tptr,txt)
char *tptr,*txt;
{
char *ptr;
int tlen;

tlen=tokenlength(tptr);
if(tlen!=strlen(txt))
  return(0);
else
  if(strncmp(tptr,txt,tlen))
    return(0);
  else
    return(1);
}


/* returns mode number which matches x,y,bpp or -1 if none did.
 * put '-1' in x,y or bpp to wildcard them.
 *
 * maybe this routine should be somewhere else?
 */
int modematch(x,y,bpp)
int x,y,bpp;
{
int numcols,f;
vga_modeinfo *vminfo;

if((bpp>24)||(bpp==2))
  /* they must have used numcols, not bpp. hmm, let 'em get away with it. */
  numcols=bpp;
else
  numcols=(1<<bpp);

/* we check 0 - 255 at the most */
#ifdef HARM_HANEMAAYER_FIXES_THAT_SVGALIB_BUG
for(f=0;f<256;f++)
#else
for(f=0;f<31;f++)
#endif
  {
  vminfo=vga_getmodeinfo(f);
  if(((x==-1)||(x==vminfo->width))&&
     ((y==-1)||(y==vminfo->height))&&
     ((numcols==-1)||(numcols==vminfo->colors)))
    break;
  }

#ifdef HARM_HANEMAAYER_FIXES_THAT_SVGALIB_BUG
if(f<255)
#else
if(f<30)
#endif
  return(f);
else
  return(-1);
}
