/*$Header: /a/lewis/disk/home/lfcs1/rjg/Ml/fam.src/UPTODATE/RCS/store.c,v 4.2 90/02/05 12:00:49 rjg Exp $*/
/*$Log:	store.c,v $
 * Revision 4.2  90/02/05  12:00:49  rjg
 * Exception traceback, reraise bytecode, UPRecN objects for arrays
 * 
 * Revision 4.1.1.1  90/01/29  12:36:10  rjg
 * See compiler version 1.7.1.1
 * Changes for exception tracing
 * Changed OpNewRaise to recognise the new ?\ (characterised by a NULL
 * exception pattern frame) and to chain back down Ctl Stack printing
 * closure names (stored as first literal field for all functions)
 * OpReRaise same but doesn't set Ctl Stk starting point.
 * Also removed old OpRaise and OpHandle #defines and modified
 * store.c accordingly
 * 
 * Revision 4.0  89/09/20  13:33:24  rjg
 * incorporated RCS
 * */
/* last changed by: */
/* RJG 07-Feb-89 : extended CheckEq to allow eq testing of BigVars */
/* RJG 03-Feb-89 : extended ClassifyObject for BigVar */
#include <stdio.h>
#include "globdefs.h"
#include "structs.h"
#include "globvars.h"
#include "bcodes.h"
#include "debug.h"

extern FatalError();

#ifdef DEBUGinterp
   extern TraceBack();
#else
   TraceBack() { }
#endif

int GCMsgsRequired;
int GCCount;
int HeapAllocd[NUM_TYPES];

CreateInitialHeapSpace()
{
    MidOfASpace = (BegOfASpace = (LWord *) valloc (HeapSize)) + TagSize;
    EndOfASpace = ByteAdd_(BegOfASpace, HeapSize);
    if (Immed_(BegOfASpace))
    { if (BegOfASpace==0)
	FatalError("Initial heapspace allocation failed\n");
      else FatalError("Unexpected return from alloc.  Wrongly configured?");
    }
    GCCount = 0;
}


static LWord *AttemptSecondSpace()
{
    if (BegOfBSpace == 0) {		/* Create second heapspace */
        BegOfBSpace = (LWord *) valloc (HeapSize);
        EndOfBSpace = ByteAdd_(BegOfBSpace, HeapSize);
    }
    return (BegOfBSpace);
}

static SwapSpaces()
{
    LWord *temp;
    temp = BegOfBSpace;
    BegOfBSpace = BegOfASpace;
    MidOfASpace = (BegOfASpace = temp) + TagSize;
    temp = EndOfBSpace;
    EndOfBSpace = EndOfASpace;
    EndOfASpace = temp;
}

ResetConstants()
{
    EmptyString    = CurrentState -> EmptyString;
    NullArray      = CurrentState -> EmptyArray;
    StartupClosure = CurrentState -> StartupClosure;
    FunIdClos      = CurrentState -> FunIdClosure;
    FunCompText    = CurrentState -> FunCompText;
    XConText       = CurrentState -> XConText;
}


/* RJG 03-Feb-89
 * added BigVar
 */
#define ML_RETURN(LEN,NPTRS,START) \
  { len = LEN; nptrs = NPTRS; start = START; break;}
#define ClassifyObject_(Obj, len, nptrs, start) \
  switch (Tag_(Obj)) \
  { case TagState:  ML_RETURN(SizeOfAMState_, PtrsInAMState_ , Obj) \
    case TagProcess:ML_RETURN(SizeOfAMProcess_, PtrsInAMProcess_, Obj) \
    case TagRec1: \
    case TagUpRec1: ML_RETURN(SizeOfAMRec1_, PtrsInAMRec1_, Obj) \
    case TagRec2: \
    case TagUpRec2: ML_RETURN(SizeOfAMRec2_, PtrsInAMRec2_, Obj) \
    case TagRecN: \
    case TagUpRecN: ML_RETURN(SizeOfAMRecN_(Obj), PtrsInAMRecN_(Obj), Obj) \
    case TagString: \
    case TagReal:   ML_RETURN(SizeOfAMString_(Obj), PtrsInAMString_, Obj) \
    case TagVariant:ML_RETURN(SizeOfAMVariant_, PtrsInAMVariant_, Obj) \
    case TagBigVar:ML_RETURN(SizeOfAMBigVar_, PtrsInAMBigVar_, Obj) \
    case TagText:   ML_RETURN(SizeOfAMText_(Obj), PtrsInAMText_, Obj) \
    case TagStack:  ML_RETURN(SizeOfAMStack_(Obj), PtrsInAMStack_(Obj,len), \
			   ByteAdd_(Obj, *Obj)) \
    default:  InvalidTag(Obj,len); \
  }

static InvalidTag(Obj,Len)
LWord *Obj, Len;
{ LWord *Start;
  printf("Invalid tag word encountered (0x%x) at 0x%x\n",
         PreLWord_(Obj),(LWord)Obj);
  for (Start = Obj-Len-1; Start <= Obj+3; Start++)
    printf("%08x: %08x\n", Start, *Start);
  TraceBack();
  exit(1);
}

wsexchange(addr)
Byte *addr;
{  LWord tmp; tmp = addr[0]; addr[0] = addr[1]; addr[1] = tmp; }

lsexchange(addr)
Byte *addr;
{  LWord tmp; tmp = addr[0]; addr[0] = addr[3]; addr[3] = tmp;
   tmp = addr[1]; addr[1] = addr[2]; addr[2] = tmp; }

ConvertText(txt, OrigByteSexOK)
Text *txt; int OrigByteSexOK;
{
   Byte *pc; int i, len, ci, cl;
   lsexchange((Byte *)&(txt -> literals));
#ifdef NOSHORTS
   i = txt -> ArgSpaceReq; wsexchange(&i); txt -> ArgSpaceReq = i;
   i = txt -> CtlSpaceReq; wsexchange(&i); txt -> CtlSpaceReq = i;
#else
   wsexchange((Byte *)&(txt -> ArgSpaceReq));
   wsexchange((Byte *)&(txt -> CtlSpaceReq));
#endif
   pc = bytecode_(txt);   len = bytecodelength_(txt) - (sizeof(LWord));

   for (i = 0; i < len;)
      switch (pc[i++]) {
      default: break;

      case OpBind: case OpReturn: case OpTailApply_n1: case OpSqueezeB:
      case OpByteNum: case OpGetLocalB: case OpGetFreeB: case OpGetLiteralB:
      case OpJumpB: case OpTrueJumpB: case OpFalseJumpB: case OpDestTailApply:
           i++; break;

      case OpTailApplyB: case OpSlideB: i += 2; break;

      case OpGetLocalW: case OpGetFreeW: case OpGetLiteralW: case OpVariant:
      case OpQuaIs: case OpQuaAs: case OpJumpW: case OpTrueJumpW:
      case OpFalseJumpW: case OpClosure: case OpDumClosure: case OpPop:
      case OpSqueezeW: case OpDestInt: case OpDestNil: case OpDestQCons:
      case OpTuple: case OpQuaDot: case OpDestTuple_n0: case OpUnTrap:
      case OpTailApply_n0: 
      case OpDestBigVar:
           wsexchange(&(pc[i])); i += 2; break;

      case OpDestVariant: case OpRecClosure: case OpSlideW:
      case OpTailApplyW: case OpDestTuple:
           wsexchange(&(pc[i])); wsexchange(&(pc[i+2])); i += 4; break;

      case OpInt:
           lsexchange((Byte *)&(pc[i])); i += 4; break;

      case OpCase: case OpNewHandle: /*rjg 26-Jun*/
           if (!OrigByteSexOK) wsexchange(&(pc[i]));
           /* This next bit needs tidying up ! */
#ifdef oddsex
           cl = (pc[i]<<8) | pc[i+1];
#else
           cl = (pc[i+1]<<8) | pc[i];
#endif
           if (OrigByteSexOK) wsexchange(&(pc[i]));
           i += 2;
           for (ci = 0; ci<cl; ci++) {
               wsexchange(&(pc[i])); i += 2;}
           break;
      }
}

ChangeHeapSex(OrigByteSexOK)
int OrigByteSexOK;
{
   register    LWord *HeapPtr, *start, *finish;
   LWord       len, nptrs;

   for (HeapPtr=BegOfASpace+TagSize;HeapPtr<MidOfASpace; HeapPtr+=len) {
      if (!OrigByteSexOK) lsexchange((Byte *)&(HeapPtr[-1]));
      ClassifyObject_(HeapPtr, len, nptrs, start);
      if (Tag_(HeapPtr) == TagText)
         ConvertText((Text *)HeapPtr, OrigByteSexOK);
      else {
         if (Tag_(HeapPtr) == TagStack) {
            lsexchange((Byte *)&(((Stack *)HeapPtr) -> StkPos));
            lsexchange((Byte *)&(((Stack *)HeapPtr) -> TrapPos));
            if (!OrigByteSexOK)
              ClassifyObject_(HeapPtr, len, nptrs, start);
          }
         else if (Tag_(HeapPtr) == TagProcess) nptrs += 3;
         for(finish = start+nptrs; start<finish; start++) lsexchange((Byte *)start);
         }
      if (OrigByteSexOK) lsexchange((Byte *)&(HeapPtr[-1]));
      };
}

Reconfigure(OldOrigin)
LWord *OldOrigin;
{   int ByteSexOK = 1;
    char inbuf[80], arg[80], fname[80]; LWord loc, val;
    printf("]\nHeap reconfiguration phase\n");
    printf("Heap loaded at %x, with %x as the old origin.\n",
           (LWord)BegOfASpace, (LWord)OldOrigin);
    printf("MidOfASpace = 0x%x (size %d)\n", MidOfASpace,
           PtrDiff_(MidOfASpace, BegOfASpace));
    inbuf[0] = 0;
    do {
       if (sscanf(inbuf, "%1s", arg) == 0) arg[0] = '?';
       switch (arg[0]) {
       case 'c': if (ByteSexOK) return;
                 else printf("Byte sex wrong !\n"); break;
       case 'x': exit(0);
       case 'r': Relocate(BegOfASpace, OldOrigin, 0/* !!! */, 0); break;
       case 'b': ChangeHeapSex(ByteSexOK); ByteSexOK = !ByteSexOK; break;
       case 'g': InitCollect(); break;
       case 'w': if (sscanf(inbuf, "%1s %s ", arg, fname) == 2)
                    ExportState(fname, !ByteSexOK, NIL);
                 else printf("Syntax error\n");
                 break;
       case 's': if (sscanf(inbuf, "%1s %x %x", arg, &loc, &val) == 3)
                    *((LWord *)loc) = val;
                 else printf("Syntax error\n");
                 break;
       case 'e': if (sscanf(inbuf, "%1s %x ", arg, &loc) == 2)
                    printf("%x: %x\n", (LWord)loc, *((LWord *)loc));
                 else printf("Syntax error\n");
                 break;
       case 'f': { int i,n,count; LWord *p,a[10];
                   n = sscanf(inbuf, "%1s %x %x %x %x %x %x %x %x %x %x %x ",
                              arg, a,a+1,a+2,a+3,a+4,a+5,a+6,a+7,a+8,a+9)-1;
                   count = 0;
                   if (n >= 1)
                   { for (p=BegOfASpace; p<=MidOfASpace-n; p++) /* beware */
                     { for (i=0; i<n; i++) if (p[i]!=a[i]) goto tough;
                       if ((++count)>20) { printf("(more)\n"); break; }
                       printf("%x\n", p);
                tough: ;
                     }
                   }
                   else printf("Syntax error\n");
                 }
                 break;
       default:  printf("c - continue,\t x - exit,\t r - relocate heap,\t \
b - swap byte sex,\n");
                 printf("f <val 1> ... <val n> - find n consecutive \
values in heap,\n");
                 printf("s <loc> <value> - set loc to value,\t \
e <loc> - examine contents of loc\n");
                 printf("w <file> - write out heap to file,\n"); }
       }
    while ((fputs("> ",stdout),fflush(stdout),fgets(inbuf,80,stdin)) != NULL);
}


/* Relocate(ObjStart,OldOrigin, heapHasWordPtrs, noisy):
 *    This routine is called immediately after a raw heap has been loaded
 *    into the A space.  OldOrigin was the origin of the heap in its previous
 *    life.  This routine patches up all pointers in the heap so they are
 *    correct relative to the heap's current position.
 */

Relocate(ObjStart, OldOrigin, heapHasWordPtrs, noisy)
LWord *OldOrigin, *ObjStart; int heapHasWordPtrs; int noisy;
{
    register    LWord *HeapPtr, *start, *finish;
    LWord	len, nptrs;
    int         Offset, i;

#ifndef WORDPTRS
    if (heapHasWordPtrs)
       FatalError("Cannot relocate heap from a word-pointer machine");
   /* Well, we probably can with a bit of work, but I can't be bothered
      thinking about it right now.
    */
#endif

    if ((Offset = PtrDiff_(ObjStart, OldOrigin)) == 0)
       /* Old and New origins are the same. Return if the pointer sense
	  (word vs. byte) is also the same. */
#ifdef WORDPTRS
       if (heapHasWordPtrs)  return;
#else
       if (!heapHasWordPtrs)  return;
#endif

   /* Offset is a difference between byte pointers, so will need shifting
      for word-pointer machines. */

/*
    if (noisy) {printf("...relocating by %x (bytes)", Offset); fflush(stdout);}
 */

/* AM: the next conditional should also test whether WORDPTRS
   is the same as in the file header (for orion etc heaps) and
   if not take the first (slower) case.
   General need of tidying up, especially removing the acorn32016
   includes to hack round bug for next acorn C version.
*/
#ifdef NEGPTRS
#   define OldPtr_(x)  (signed_(x)>0)
#else
#   define OldPtr_(x)  (signed_(x)<0)
#endif

    i = 0;
    if (Immed_(OldOrigin))
       { /* oh dear, -ve heap for +ve ptrs or v.v. */
	  for (HeapPtr=ByteAdd_(ObjStart,4);HeapPtr<MidOfASpace; HeapPtr+=len)
	     {
		ClassifyObject_(HeapPtr, len, nptrs, start);
		finish = start + nptrs;
		for(;start<finish;start++)
		   if (OldPtr_(*start))
		      {
			 i++;
#ifdef WORDPTRS
			 if (!heapHasWordPtrs)
			    (*start) = (*start + Offset) >> 2;
			 else
			    (*start) += (Offset >> 2);
#else
                         (*start) += Offset;
#endif
		      }
		   else if (*start != 0) *start ^= 0x80000000;
	     }
       }
    else
       { /* pointers are pointers */
	  for (HeapPtr=ByteAdd_(ObjStart,4);HeapPtr<MidOfASpace; HeapPtr+=len)
	     {
		ClassifyObject_(HeapPtr, len, nptrs, start);
		finish = start + nptrs;
		for(;start<finish;start++)
		   if (Ptr_(*start))
		      {
			 i++;
#ifdef WORDPTRS
			 if (!heapHasWordPtrs)
			    (*start) = (*start + Offset) >> 2;
			 else
			    (*start) += (Offset >> 2);
#else
                         (*start) += Offset;
#endif
		      }
	     }
       }

/*
    if (noisy)
       {
	  printf(" (%d pointers relocated)", i);
	  fflush(stdout);
       }
 */
 }

LWord nptrs;

LWord *Copy(Object)
register LWord *Object;
{   register int i;
    /*register*/ LWord *start, *finish, *newobj; int len;

/* NICK: Sun4 compiler bug? */
    i = (LWord) (Object[-1]);
    if (i & MARKBIT)
        return((LWord *)(i ^ MARKBIT));
    else {
        ClassifyObject_(Object, len, nptrs, start);
        HeapAllocd[Tag_(Object)] += len*4;
#ifdef ALIGNREALS
        if ((Tag_(Object) == TagReal) && (((LWord)MidOfASpace & 0x7))) {
           *MidOfASpace = ((0xC000 + TagRecN) << TAGSHIFT); MidOfASpace += 1; }
#endif
        newobj = MidOfASpace;
#ifdef acorn32016
        MidOfASpace = newobj+len;
#else
        MidOfASpace += len;
#endif
        newobj[-1] = Object[-1];
        Object[-1] = ((LWord)newobj | MARKBIT);
        for(finish = start + nptrs; start<finish; start++)
            if (Ptr_(*start))
	       {
		  if (*start == 0xFFFFFFFF)
		     printf("Ptr_ %X\n", *start);
		  
		  (*start) = (LWord)Copy((LWord *)(*start));
	       }
        for(i=len-2; i>=0; i--) newobj[i] = Object[i];
        return(newobj);
        }
}

/* AM: Compacting collector (Copyright (c) IST Cambridge Ltd.)
   with pointer reversing marking phase.  Note that we rely that
   all objects have two 2 bits (C0000000) set in their prefield.
   Code is like a previous (buggy) implementation by Kevin
   (but has pointer reversal, works for +ve and -ve pointers
   and works) attributed to Foster and is structured:
    1) mark using pointer reversal, chaining all references
       via object prefield.
    2) fix up all references to point to address where object will
       eventually reside.
    3) move objects.
*/


#ifdef NEGPTRS
#  define Mark_(p)   (p[-1] |= MARKBIT)
#else
#  define Mark_(p)   (p[-1] = ((p[-1] & ~0x80000000) | MARKBIT))
#endif
#define MARK2BIT   0x40000000    /* see comment above */
#define Marked_(p) (p[-1] & MARKBIT)
#define Home_(p)   (Ptr_(p[-1]) && Marked_(p))

#define DEBUGheapimage
#ifdef DEBUGheapimage
Check()
{ register LWord *p,*start;
  register int nptrs, len;
  p = BegOfASpace+TagSize;
  while (p < MidOfASpace)
  { if ((p[-1] & 0xFF000000) != (LWord)0xC0000000)
      printf("Curious heap header word %x at %x\n", p[-1], p);
    ClassifyObject_(p, len, nptrs, start);
    p += len;
  }
  if (p != MidOfASpace)
    printf("Curious heap end %x - should be %x\n", p, MidOfASpace);
}
#endif

Mark(p)
register LWord *p;
{ register LWord *q,t,*start;
  register int len,nptrs;
  q = 0;
  while (Ptr_(p) && !Marked_(p))
  {
    ClassifyObject_(p, len, nptrs, start);
    HeapAllocd[Tag_(p)] += len*4;
    if (start != p) /* stack only - pack unmistakable pseudo header */
      { start[-1] = (LWord)(start-1) | MARKBIT; start[-2] = (LWord)p; }
    Mark_(p);
    if (nptrs == 0) break;
    p = start+nptrs;
next:
    p -= 1;
    t = *p; *p = (LWord)q; q = p; p = (LWord *)t;
  }
  while (q != 0)
  { if (Ptr_(p))  /* chain all references via header word */
      { t = p[-1] ^ MARKBIT; p[-1] = (LWord)q | MARKBIT; p = (LWord *)t; }
    t = *q; *q = (LWord)p; p = q; q = (LWord *)t;
    if (!Home_(p)) goto next;  /* just try and write this 'structuredly' */
    if (p[-1] == ((LWord)(p-1) | MARKBIT))  /* deal with pseudo header */
      p = (LWord *)p[-2];
  }
}

Fixup()
{ register LWord *p,*q,t,tt,*start;
  register int len,nptrs;
  p = q = BegOfASpace+TagSize;
  while (p < MidOfASpace)
  { if ((t = p[-1]) & MARKBIT)   /* fixup reference chain to new address */
    { /* the next line could be improved on some machines by using
         &CurrentState appropriately, but not all machines give
         nearby addresses for calloc and static variables */
      if (p == (LWord *)CurrentState) CurrentState = (State *)q;
      while (!(t & MARK2BIT))
      {    /* NB: this loop always goes at least once - except possibly for
                  CurrentState object.  */
           tt = *(LWord *)(t & ~MARKBIT);
           *(LWord **)(t & ~MARKBIT) = q;
           t = tt;
      }
      p[-1] = t | (MARKBIT | 0xC0000000);   /* restore original header
                                               word, still marked.  */
    }
    ClassifyObject_(p, len, nptrs, start);
    if (Marked_(p)) q += len;
    p += len;
  }
}

Move()
{ register LWord *p,*q,*start;
  register int i,len,nptrs;
  p = q = BegOfASpace+TagSize;
  while (p < MidOfASpace)
  {
    ClassifyObject_(p, len, nptrs, start);
    if Marked_(p)
    { q[-1] = p[-1] ^ MARKBIT;
      for (i = 0; i<len-1; i++) q[i]=p[i];
      q += len;
    }
    p += len;
  }
  MidOfASpace = q;
}

CompactionGC()
{
#ifdef DEBUGheapimage
  if (GCMsgsRequired) { printf("Checking..."); fflush(stdout); }
  Check();
#endif
  if (GCMsgsRequired) { printf("Marking..."); fflush(stdout); }
  Mark((LWord *)CurrentState);
  if (GCMsgsRequired) { printf("relocating..."); fflush(stdout); }
  Fixup();
  if (GCMsgsRequired) { printf("moving..."); fflush(stdout); }
  Move();
}


LWord *CopyingGC(obj)
LWord *obj;
{   LWord *pos;
    SwapSpaces();
    if (GCMsgsRequired) { printf(" Copying... "); fflush(stdout); }
    if (obj != NIL) {
        obj = (LWord *)(Copy(obj)); pos = MidOfASpace;
        }
    else pos = NIL;
    CurrentState = (State *)Copy((LWord *) CurrentState);
    /* At this point set space B to demand page zero if possible */
    return(pos);
}

LWord *CommonCollect(len,obj)
int len; LWord *obj;
{
    int i; register LWord *newobj, *pos;

#ifdef DEBUGinterp
    Byte savednextbyte;
    savednextbyte = nextbyte; nextbyte = 0;
#endif

#ifdef acorn32016
    newobj = MidOfASpace; MidOfASpace = ByteAdd_(newobj, -len);
#else
    MidOfASpace = ByteAdd_(MidOfASpace, -len);  /* AM: see AllocObject_ */
#endif

    pos = NIL;

    pagerand();

    if (GCMsgsRequired = cbool_(CurrentState -> GCMsgs -> at))
        printf("\n[GC: ");

    SaveProcessState();

    for (i=NUM_TYPES-1; i>=0; HeapAllocd[i] = 0, i--);

#ifdef transputer
   /* NICK: The transputer implementation uses the on-chip cache for its stack,
      of which there isn't very much. Don't try to use the (recursive!)
      copying collector. */
    CompactionGC();
#else
    if (cbool_(CurrentState -> CompactGC -> at))
        CompactionGC();
    else
        if (AttemptSecondSpace()) pos = CopyingGC(obj);
        else { (CurrentState -> CompactGC -> at) = TRUE_;
               printf("[Using compacting GC] ");
               CompactionGC();
             }
#endif		/* transputer */

    if (GCMsgsRequired) {
        printf("%d%% (%d/%d Kbytes) used.\n",
            (PtrDiff_(MidOfASpace-TagSize,BegOfASpace) * 100) / HeapSize,
            PtrDiff_(MidOfASpace-TagSize,BegOfASpace)/1024,
            HeapSize/1024);
        printf("Space used (in bytes)\n\
States %d, Processes %d, Rec(1) %d, Rec(2) %d, Rec(N) %d,\n\
UpRec(1) %d, UPRec(2) %d, UPRec(N) %d,\n\
Strings/Numbers %d, Variants %d, Bytecodes %d, Stacks %d,\n\
BigVariants %d]\n",
            HeapAllocd[0],HeapAllocd[1],HeapAllocd[2],HeapAllocd[3],
            HeapAllocd[4],HeapAllocd[9],HeapAllocd[10],HeapAllocd[11],
            HeapAllocd[5]+HeapAllocd[12]+HeapAllocd[13],
            HeapAllocd[6],HeapAllocd[7],HeapAllocd[8],HeapAllocd[14]);
        }

    ResetConstants();  SetTopProcess();  RestoreProcessState();
    pagenorm(); GCCount++;

#ifdef DEBUGinterp
    nextbyte = savednextbyte;
#endif

    if (len > 0) {
        if ((MidOfASpace = ByteAdd_(newobj=MidOfASpace,len)) > EndOfASpace)
            { printf("Heap space exhausted.\n"); exit(0); }
        return(newobj);  }
    else return(pos);
}

LWord *Collect(len)
int len;
{   LWord *res; res = CommonCollect(len,NIL);
    return res; }

LWord *ObjCollect(obj)
LWord *obj;
{   LWord *res; res = CommonCollect(0,obj);
    return res; }

InitCollect() { CurrentProcess=CurrentState->WaitingProcesses;
                RestoreProcessState(); Collect(0); SaveProcessState(); }

SaveProcessState()
{ register Stack *tempstack;
  tempstack = CurrentProcess -> ArgStk;
  (tempstack -> StkPos) = PtrDiff_(FAM_AP, tempstack);
  (CurrentProcess -> Frame) = FAM_FP;
  (CurrentProcess -> PC) = PtrDiff_(FAM_PC, (FAM_FP-> text));
  tempstack = CurrentProcess -> CtlStk;
  (tempstack -> StkPos) = PtrDiff_(FAM_CP, tempstack);
  (tempstack -> TrapPos) = PtrDiff_(FAM_TrapTop, tempstack);
}

RestoreProcessState()
{ register Stack *tempstack;
  tempstack = CurrentProcess -> ArgStk;
  FAM_AP = ByteAdd_(tempstack, (tempstack -> StkPos));
  FAM_FP = CurrentProcess -> Frame;
  FAM_PC = (Byte *)ByteAdd_((FAM_FP -> text), (CurrentProcess -> PC));
  tempstack = CurrentProcess -> CtlStk;
  FAM_CP = ByteAdd_(tempstack, (tempstack -> StkPos));
  FAM_TrapTop = ByteAdd_(tempstack, (tempstack -> TrapPos));
}

int CheckEq(arg1, arg2)
LWord *arg1, *arg2;
{ register int i;  int nptrs, len; LWord *start;
check:
  if ((LWord)arg1 == (LWord)arg2) return(1);
  if (Immed_(arg1) || Immed_(arg2) ||
      (arg1[-1] != arg2[-1])) return(0);

  switch (Tag_(arg1)) {
  case TagText:
  case TagStack:
  case TagState:
  case TagUpRec1:
  case TagUpRec2:
  case TagUpRecN:
  case TagProcess: return(0);

  case TagString:
  case TagReal:
     return(memcmp(stringchar_(arg1),stringchar_(arg2),stringlength_(arg1))
            == 0);

  case TagBigVar: {  /* RJG 07-Feb-89 */
     if (arg1[1] != arg2[1]) return(0); /* same tag */
     arg1 = (LWord *)arg1[2]; arg2 = (LWord *)arg2[2];
     goto check; }
    
  default: {
     ClassifyObject_(arg1, len, nptrs, start);
     if (nptrs == 0) return(1);
     for (i=nptrs-1; i>0; i--) {
       if (!CheckEq((LWord *)arg1[i], (LWord *)arg2[i])) return(0); }
     arg1 = (LWord *)arg1[0]; arg2 = (LWord *)arg2[0];
     goto check; }
  }
}
