#include <ncurses.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "color.h"
#include "dialog.h"
#include "util.h"
#include "win.h"

#define MAXLINKNAME 80

static char rcsid [] = "$Header: /usr/users/miguel/c/CVS/nc/help.c,v 1.2 1994/05/10 20:49:00 miguel Exp $";
char *data;
static int help_lines = 18;
WINDOW *whelp;

char *search_string (char *start, char *text)
{
    char *d = text;
    char *e = start;
    
    for (;e; e++){
	if (*d == *e)
	    d++;
	else
	    d = text;
	if (!*d)
	    return e+1;
    }
    return 0;
}

static char *search_string_node (char *start, char *text)
{
    char *d = text;
    char *e = start;
    
    for (;e && *e != '%'; e++){
	if (*d == *e)
	    d++;
	else
	    d = text;
	if (!*d)
	    return e+1;
    }
    return 0;
}

static char *move_forward (char *current, int lines)
{
    char *p;
    int  line;

    for (line = 0, p = current; *p && *p != '%'; p++){
	if (*p == '\n')
	    line++;
	if (line == lines)
	    return p;
    }
    return current;
}

static char *move_backward (char *current, int lines)
{
    char *p;
    int line;

    for (line = 0, p = current; *p && *p != '%' && p > data; p--){
	if (*p == '\n')
	    line++;
	if (line == lines)
	    return p;
    }
    return current;
}

static char *follow_link (char *selected_item)
{
    char link_name [MAXLINKNAME];
    char *p;
    int  i = 0;

    if (!selected_item)
	return;
    for (p = selected_item; *p && *p != '%' && *p != '\002'; p++)
	;
    if (*p = '\002'){
	link_name [0] = '[';
	for (i = 1; *p != '\003' && *p && *p != '%' && i < MAXLINKNAME-3; )
	    link_name [i++] = *++p;
	link_name [i-1] = ']';
	link_name [i] = 0;
	p = search_string (data, link_name);
	if (p)
	    return p;
    }
    return "Help file format error\n%";	/*  */
}

static char *select_next_link (char *start, char *current_link)
{
    char *p;

    p = search_string_node (current_link, "\003");
    if (!p)
	return "Help file format error\n%";
    p = search_string_node (p, "\001");
    if (p)
	return p - 1;
    p = search_string_node (start, "\001");
    if (p)
	return p - 1;
    return 0;
}

static show (char *paint_start, char *selected_start)
{
    char *p;
    int  col, line;
    int  painting = 1;
    
    line = col = 0;
    werase (whelp);
    wclr (whelp);
    for (p = paint_start; *p != '%' && line < help_lines; p++){
	if (*p == 1){
	    if (p == selected_start)
		wattrset (whelp, MARKED_COLOR | A_BOLD);
	    else
		wattrset (whelp, SELECTED_COLOR);
	    
	} else if (*p == 2){
	    painting = 0;
	} else if (*p == 3){
	    painting = 1;
	    wattrset (whelp, REVERSE_COLOR);
	} else if (*p == '\n'){
	    line++;
	    col = 0;
	} else {
	    if (!painting)
		continue;
	    mvwaddch (whelp, line, col, *p);
	    col++;
	}
    }
    wrefresh (whelp);
}

void interactive_display (char *filename)
{
    int quit = 0;
    char *current, *start, *main, *selected_item;
    
    if ((data = load_file (filename)) == 0)
	return;
    create_dialog (60, help_lines, " Main ", "", 0);
    whelp = get_top_text ();
    if (!(main = search_string (data, "[main]"))){
	message (1, " Error ", " Can't find main node in help file ");
	return;
    }
    selected_item = search_string_node (main, "\001") - 1;
    current = start = main;
    do {
	show (current, selected_item);
	switch (mi_getch ()){
	case ' ':
	    current = move_forward (current, help_lines-1);
	    break;

	case KEY_BACKSPACE:
	case 0177:
	case 8:
	    current = move_backward (current, help_lines-1);
	    break;

	case 22:		/* C-v like emacs */
	case 6:			/* C-f */
	case KEY_DOWN:
	    current = move_forward (current, 2);
	    break;

	case 2:			/* C-b */
	case KEY_UP:
	    current = move_backward (current, 2);
	    break;
	    
	case '\n':
	    if (!selected_item)
		current = start = main;
	    else
		current = start = follow_link (selected_item);
	    selected_item = search_string_node (current, "\001");
	    if (selected_item)
		selected_item--;
	    break;

	case '\t':
	    selected_item = select_next_link (start, selected_item);
	    break;

	case '\e':
	    quit = 1;
	}
    } while (!quit);
    free (data);
    refresh_screen ();
}
