
enum { view_brief, view_full, view_info };
enum { show_dates, show_perm };
enum { brief_mode, full_mode, long_mode };

typedef struct {
    dir_list dir;		/* Directory contents */
    int      view_type;		/* type of view */
    int      active;		/* If panel is currently selected */
    char     cwd [MAXPATHLEN];	/* Current Working Directory */
    int      count;		/* Number of files in dir structure */
    int      lines;		/* Panel Lines */
    int      cols;		/* Panel columns */
    int      marked;		/* Count of marked file */
    long int total;		/* Bytes in marked files */
    int      top_file;		/* The file showed on the top of the panel */
    int      selected;		/* Index to the selected file */
    int      is_status;		/* Is the panel a status display? */
    sortfn   *sort_type;	/* Sort type */
    WINDOW   *win_file;		/* Where the files are listed */
    WINDOW   *win_mini;		/* The mini-info */
} Panel;

int init_panel (Panel *panel, int x1, int y1, int x2, int y2);
int paint_panel (Panel *panel);
void panel_refresh (Panel *panel);
int set_attr (Panel *panel, int hilight, int marked);
void try_to_select (Panel *panel, char *name);

extern int show_mini_info;

extern file_entry *selection;

/*#define ITEMS(p) ((p)->view_type == view_brief ? (p)->lines *2 : (p)->lines)
*/
/* The return value of panel_reload */
#define CHANGED 1
