/* Windows utilities.
   Copyright (C) 1994 Miguel de Icaza, Mauricio Plaza
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#include <ncurses.h>
#include "win.h"
#include "color.h"

static char rcsid [] = "$Header: /usr/users/miguel/c/CVS/nc/win.c,v 1.1.1.1 1994/05/06 19:14:27 miguel Exp $";

wclr (WINDOW *w)
{
    int x, y;
    
    for (x = 0; x <= w->_maxx; x++){
	for (y = 0; y <= w->_maxy; y++){
	    mvwaddch (w, y, x, ' ');
	}
    }
}

void define_label (WINDOW *fkeys, int index, char *text)
{
    wprintw (fkeys, "%d", index);
    wattron (fkeys, SELECTED_COLOR);
    wprintw (fkeys, "%-6s", text);
    wstandend (fkeys);
    waddch (fkeys, ' ');
}

WINDOW *new_fkey ()
{
    WINDOW *w;
    
    w = newwin (1, COLS, LINES-1, 0);
    leaveok (w, TRUE);
    
    return w;
}
