/*
    Simple window management header file
    Copyright (c) Tudor Hulubei & Andrei Pitis, May 1994

This file is part of UIT (UNIX Interactive Tools)

UIT is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2, or (at your option) any later version.

UIT is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details .

You should have received a copy of the GNU General Public License along with
UIT; see the file COPYING.  If not, write to the Free Software Foundation,
675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __WINDOW_H
#define __WINDOW_H


typedef struct
{
    int startx, starty;
    int rows, columns;
    int cursorx, cursory;
} window;


window *window_init(int startx, int starty, int rows, int columns);
int  window_write(char *str, int length);
int  window_putch(char c);
void window_cursormove(window *this, int y, int x);


#endif
