/*
** finger.h  - used in finger, ttyloc, and watson.
**
** Written by Keith Gabryelski
** Released into public domain September 1, 1988.
** Please keep this header.
**
*/

#include "ttyloc.h"
#include "dbase.h"

#define KMEM_FILE	"/dev/kmem"
#define MEM_FILE	"/dev/mem"
#define SWAP_FILE	"/dev/swap"

#define DEFAULT_IDLE_TIME (30 * 60)

/*
** whatarewe - A variable with oodles of info about how this finger should
**	       look.  Ie, are we a whois?  Should we show a plan?  Should
**	       we show mail box info.
*/

#define LONG		0x00000001	/* Pertinent info about this user. */
#define	PLAN		0x00000002	/* Show a plan if has one. */
#define MAILBOX		0x00000004	/* Show mailbox info if any. */
#define HIDABLE		0x00000008	/* Unames hidden if repeated? */

#define SORT_BY_NAME	0x00000000	/* Sort list by name. */
#define SORT_BY_IDLE	0x00000010	/* Sort list by Idle time. */
#define SORT_BY_TTY	0x00000020	/* Sort list by ttyname. */
#define SORT_MASK	0x00000030	/* Sort mask for above. */

#define DIALOUT		0x00000040	/* Show DIALOUT lines. (for SCO only)*/

#define WHOIS	(LONG|PLAN|MAILBOX)	/* whois. */
#define FINGER	(HIDABLE)		/* default. */

extern void get_dbase_info();
extern char *puterr(), *mymalloc(), *myrealloc();

/*
** Some defines for easy access to nlist struct.
*/
#define	v_addr		nl[0].n_value
#define	proc_addr	nl[1].n_value

/*
** Below are machine dependent macros and definitions.  On XENIX
** p_addr[0].te_frameno has the page number of the user structure in
** /dev/mem.  On the 3B1 it's just p_addr[0].  No sweat.
*/

#ifdef SCO_XENIX_386
/*
** Tested on SCO XENIX 2.2.1. on a Zenith 386.
**
*/

/*
** Define for all types of SCO systems.
*/

#define SCO_XENIX

#define IN_CORE_USER_STRUCT_ADDRESS  ctob(proc[i].p_addr[0].te_frameno)
#define SWAPPED_USER_STRUCT_ADDRESS  ctob(proc[i].p_addr[0].te_frameno)

#endif /* SCO_XENIX_386 */

#ifdef SCO_XENIX_286
/*
** NOT TESTED.  THIS SHOULDN'T WORK!!!
**
*/

/*
** Define for all types of SCO systems.
*/

#define SCO_XENIX

/*
** Couldn't find this in the headers.  Is it somewhere?
** dbtob == disk blocks to bytes.
*/

#define dbtob(blocks) ((blocks) * NBPC * NDPC)

#define IN_CORE_USER_STRUCT_ADDRESS  ctob(proc[i].p_uaddr)
#define SWAPPED_USER_STRUCT_ADDRESS  dbtob(proc[i].p_addr.p_daddr)

#endif /* SCO_XENIX_286 */

/*
** SCO_XENIX defined for all sco machines.  Hardware unrelated.
*/

#ifdef SCO_XENIX
/*
** Stuff that is the same for all SCO systems.
*/

#define KERNEL_FILE	"/xenix"
#endif /* SCO_XENIX */

#ifdef UNIX_PC
/*
** Tested on an AT&T 3b1 (unix pc) SysV.2 machine.
*/

#define KERNEL_FILE	"/unix"

#define IN_CORE_USER_STRUCT_ADDRESS (ctob(proc[i].p_addr[0]) + U_OFFSET)
#define SWAPPED_USER_STRUCT_ADDRESS dbtob(proc[i].p_swaddr)

/*
** If proc is a pointer to an array of struct proc then we must do
** indirection.  It is on the 3b1.
*/
#define DO_INDIRECTION_ON_PROC

/*
** Symbols on the Unix PC do not have prefixed underlines.
*/
#define NO_PREFIXED_UNDERLINES_IN_SYMBOLS
#define NEED_NLIST.H
#endif /* UNIX_PC */

#ifdef SYSV_3B5
/*
** Not Tested yet, for I didn't have root privileges on
** the machine.  I'm not real sure about SWAPPED_USER_STRUCT_ADDRESS.
*/

#define KERNEL_FILE	"/unix"

#define IN_CORE_USER_STRUCT_ADDRESS ctob(proc[i].p_addr)
#define SWAPPED_USER_STRUCT_ADDRESS proc[i].p_swaddr

/*
** Symbols on the 3B5 do not have prefixed underlines.
*/
#define NO_PREFIXED_UNDERLINES_IN_SYMBOLS
#define NEED_NLIST.H
#endif /* SYSV_3B5 */

/*
** nlist structure.
*/

#ifdef NO_PREFIX_UNDERLINES_IN_SYMBOLS
struct nlist nl[] =
{
    { "v", },
    { "proc", },
    { "", },
};
#else /* !NO_PREFIX_UNDERLINES_IN_SYMBOLS */
struct nlist nl[] =
{
    { "_v", },
    { "_proc", },
    { "", },
};
#endif /* NO_PREFIX_UNDERLINES_IN_SYMBOLS */
