/*
 * $XConsortium: UtkasciiSrc.h,v 1.13 91/07/22 19:02:47 converse Exp $
 *
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 */


/*
 * UtkasciiSrc.h - Public Header file for Utkascii Text Source.
 *
 * This is the public header file for the Utkascii Text Source.
 * It is intended to be used with the Text widget, the simplest way to use
 * this text source is to use the UtkasciiText Object.
 *
 * Date:    June 29, 1989
 *
 * By:      Chris D. Peterson
 *          MIT X Consortium 
 *          kit@expo.lcs.mit.edu
 */


/*
 * 
$Log: UtkasciiSrc.h,v $
 * Revision 1.2  1992/12/05  17:27:42  larose
 * added rcs logging
 *
 *
 */

#ifndef _UtkasciiSrc_h
#define _UtkasciiSrc_h

#include <X11/Xaw/TextSrc.h>
#include "Xfuncproto.h"

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 callback	     Callback		Callback	(none)
 dataCompression     DataCompression	Boolean		True
 length		     Length		int		(internal)
 pieceSize	     PieceSize		int		BUFSIZ
 string		     String		String		NULL
 type		     Type		XawUtkasciiType	XawUtkasciiString
 useStringInPlace    UseStringInPlace	Boolean		False

*/
 
/* Class record constants */

extern WidgetClass utkasciiSrcObjectClass;

typedef struct _UtkasciiSrcClassRec *UtkasciiSrcObjectClass;
typedef struct _UtkasciiSrcRec      *UtkasciiSrcObject;

/*
 * Just to make people's lives a bit easier.
 */

#define UtkasciiSourceObjectClass UtkasciiSrcObjectClass
#define UtkasciiSourceObject      UtkasciiSrcObject

/*
 * Resource Definitions.
 */

#define XtCDataCompression "DataCompression"
#define XtCPieceSize "PieceSize"
#define XtCType "Type"
#define XtCUseStringInPlace "UseStringInPlace"

#define XtNdataCompression "dataCompression"
#define XtNpieceSize "pieceSize"
#define XtNtype "type"
#define XtNuseStringInPlace "useStringInPlace"

#define XtRUtkasciiType "UtkasciiType"

#define XtEstring "string"
#define XtEfile "file"

typedef enum {XawUtkasciiFile, XawUtkasciiString} XawUtkasciiType;

/************************************************************
 *
 * Public routines 
 *
 ************************************************************/


String XawUtkGetText();

_XFUNCPROTOBEGIN

/*	Function Name: XawUtkasciiSourceFreeString
 *	Description: Frees the string returned by a get values call
 *                   on the string when the source is of type string.
 *	Arguments: w - the UtkasciiSrc object.
 *	Returns: none.
 */

extern void XawUtkasciiSourceFreeString(
#if NeedFunctionPrototypes
    Widget		/* w */
#endif
);

/*	Function Name: XawUtkasciiSave
 *	Description: Saves all the pieces into a file or string as required.
 *	Arguments: w - the utkasciiSrc Object.
 *	Returns: TRUE if the save was successful.
 */

extern Boolean XawUtkasciiSave(
#if NeedFunctionPrototypes
    Widget		/* w */
#endif
);

/*	Function Name: XawUtkasciiSaveAsFile
 *	Description: Save the current buffer as a file.
 *	Arguments: w - the utkasciiSrc object.
 *                 name - name of the file to save this file into.
 *	Returns: True if the save was successful.
 */

extern Boolean XawUtkasciiSaveAsFile(
#if NeedFunctionPrototypes
    Widget		/* w */,
    _Xconst char*	/* name */
#endif 
);

/*	Function Name: XawUtkasciiSourceChanged
 *	Description: Returns true if the source has changed since last saved.
 *	Arguments: w - the utkasciiSource object.
 *	Returns: a Boolean (see description).
 */

extern Boolean XawUtkasciiSourceChanged(
#if NeedFunctionPrototypes
    Widget		/* w */
#endif
);

_XFUNCPROTOEND

#endif /* _UtkasciiSrc_h  - Don't add anything after this line. */

