/* database_utils.c */

#include "database.h"

int
readline (fd, ptr, maxlen)
register int   fd;
register char  *ptr;
register int   maxlen;
{
    int n, rc;
    char c;
    char *ptr_save;

    ptr_save = ptr;
#ifdef DDEBUG
    printf("in readline, returning: \n");
#endif
    for (n = 1; n < maxlen; n++) {
        if ( (rc = read(fd, &c, 1)) == 1) {
            *ptr++ = c;
            if (c == '\n')
                break;
        } else if (rc == 0) {
            if (n == 1)
                return(0);    /* EOF, no data read */
            else
                break;        /* EOF, some data was read */
        } else
            return(-1);       /* error */
    }
    *ptr = 0;
#ifdef DDEBUG
    printf("%d : %s\n", n, ptr_save);
#endif

    return(n);
}

int
readline2 (fd, ptr, maxlen)
register int   fd;
register char  *ptr;
register int   maxlen;
{
    int n, rc;
    char c;
    char *ptr_save;

    ptr_save = ptr;
#ifdef DDEBUG
    printf("in readline2, returning: \n");
#endif
    for (n = 1; n < maxlen-1; n++) {
        if ( (rc = read(fd, &c, 1)) == 1) {
            *ptr++ = c;
            if (c == '\n') {
                *ptr = 0;
#ifdef DDEBUG
    printf("%d : %s\n", n, ptr_save);
#endif
                return(1);

            } else if (c == '\t') {
               *(ptr-1) = 0;
#ifdef DDEBUG
    printf("%d : %s\n", n, ptr_save);
#endif
               return(2);
            } else if (c == '\\') {
              if ( (rc = read(fd, &c, 1)) == 1) {
                if (c == 'n') {
                  *(ptr-1) = '\n';
                  *ptr = 0;
#ifdef DDEBUG
    printf("%d : %s\n", n, ptr_save);
#endif
                  return(2);
                } else if (c == 't') {
                  *(ptr-1) = '\t';
                } else if (c == '"') {
                  *(ptr-1) = '"';
                } else
                  *ptr++ = c;
              } else if (rc == 0)
                  if (n == 1)
                    return(0);    /* EOF, no data read */
                  else
                    break;        /* EOF, some data was read */
                else
                  return(-1);       /* error */
            }

        } else if (rc == 0) {
            if (n == 1)
                return(0);    /* EOF, no data read */
            else
                break;        /* EOF, some data was read */
        } else
            return(-1);       /* error */
    }
    *ptr = 0;
#ifdef DDEBUG
    printf("%d : %s\n", n, ptr_save);
#endif

    return(1);
}

int get_next_word(pextra, listword)
char **pextra;
char *listword;
{
    int pos;

#ifdef DDEBUG
    printf("in get_next_word\n");
#endif
    pos = 0;
    listword[0] = '\0';
    while ((**pextra != '\t') && (**pextra != '\n') && (**pextra != '\0')) {
        listword[pos] = **pextra;
        pos++;
        (*pextra)++;
    }
    listword[pos] = '\0';
    (*pextra)++;
#ifdef DDEBUG
    printf("get_next_word returning %s\n", listword);
#endif
    return(0);
}

int nwrite(fd, ptr, nbytes)
int fd;
char *ptr;
unsigned int nbytes;
{
    unsigned int nleft;
    int n, nwritten;
    char c;

    nleft = nbytes;
    while (nleft > 0) {
        if (nleft > 8192)
            n = 8192;
        else
            n = nleft;
        nwritten = write(fd, ptr, n);
        if (nwritten <= 0)
            return(nwritten);       /* error */
        nleft -= nwritten;
        ptr += nwritten;
    }
    return(nbytes-nleft);
}

