.TH XWPL 1 "19 July 1993"
.SH NAME
\fIxwpl\fR \- X-Window Wavelet Packet Laboratory
.SH SYNOPSIS
.B xwpl
[\-\fItoolkitoption\fR\ ...]
.SH DESCRIPTION
The \fIxwpl\fR program provides an X11 interface to the \fIlibawa.a\fR library
of M. Victor Wickerhauser. The program can read one\-dimensional files, zoom
in on portions of the input signal. The user can choose among a number of
quadrature mirror filters (QMFs) to do a wavelet-packet transform. There is a
graphical representation of the signal in the time-frequency space using
Phase's Heisenberg box representation.

.SH CONTROLS
The \fBopen\fR button paps up the
.I File Browser
to select an input file.
See OPENING A FILE below for details.

The \fBquit\fR button exits \fBxwpl\fR.

The \fBinfo\fR button displays the copyright notice. Press it again to make
the notice disappear.

.SH QMF LIST
The
.B QMF list
allows the user to choose a QMF family for the transforms. The waveform of
the mother wavelet for the selected filter is displayed in the QMF plot
widget.

.SH WIDTHS LIST
The
.B widths list
allows the user to select a window size for the current window.

.SH BASIS TYPE LIST
The
.B basis type list
allows the user to select the kind of basis desired. At the moment, the
following are available: best\-basis (basis of minimum entropy), best level
(basis from the level in the wavelet packet expansion with minimum entropy)
and wavelet basis.

.SH FUNCTION PANES
There are 4 function panes in the \fIxwpl\fR window. The mouse buttons behave
as in a text widget in each of these panes: the first mouse button starts the
selection, and the third mouse button extends the selection.
.SS Window Pane
All the wavelet packet transforms apply to a window of the input signal. This
window is displayed inside the window pane. Selecting a smaller portion of the
window will zoom to the selection.
.SS Original Pane
The original signal pane shows the entire input signal. The currently active
window is highlighted. Selecting a portion of the signal will change the
currently active window to the nearest window of width a power of two.
.SS Coefficients Pane
The coefficient pane show the amplitude of the wavelet packet coefficients,
sorted in decreasing order of magnitude. The steeper the fall, the more
efficiently the wavelet packet selected approximates the input signal.
.SS Reconstruction Pane
The reconstruction pane show the signal reconstructed from the coefficients
selected in the coefficient pane. The selection is automatically adjusted to
an heuristically computed threshold, but can be changed by the user. To
restore the default selection, simply click on the QMF list again.

.SH FILE FORMAT
The input files to \fIxwpl\fR are ASCII text files of floating-point numbers
separated by newlines or other whitespace. This representation is inefficient,
but lends itself easily to manipulation using the standard Unix utilities such
as
.I awk(1).

.SH OPENING A FILE
The
.I File Browser
allows an X11 user to select a file by typing the path or by browsing in
directory listings and selecting entries with the mouse.
.PP
It is inspired by the Macintosh(tm) SFGetFile dialog box.
All the usual key bindings can be used in the text widget, except for Return
and Control\-M, which are equivalent to pressing the OK button.
.PP
Each filename is preceded by an icon that describes the type of the file.
.PP
The
.I File Browser
is in total control until is pops down. No other controls will be active.

.SH XWPL SUBWIDGET RESOURCES
The subwidgets of Xwpl can be customized. Here are the reources that can be
used:
.SS Function Plot widget (\fPclass\fB Funplot)
.IP "\fBcontour (\fPclass\fB Contour)\fP" 1i
The color with which to draw the function itself and the title. Default is red.
.IP "\fBaxis (\fPclass\fB Axis)\fP" 1i
The color with which to draw the horizontal axis (if visible). Default is
black.
.IP "\fBselection (\fPclass\fB Selection)\fP" 1i
The color with which to highlight a selection. Default is pink.
.IP "\fBpad (\fPclass\fB Pad)\fP" 1i
The number of pixels with which to "pad' the function plot. Default is 5.
.IP "\fBpenWidth (\fPclass\fB PenWidth)\fP" 1i
The width of the strokes to use when plotting the function. Default is 3.
.IP "\fBtitleFont (\fPclass\fB TitleFont)\fP" 1i
The font to use for the function title. Default is the fixed font.

.SH XWPL SUBWIDGET ACTIONS

.SH OPTIONS
All the standard X Toolkit options are supported.

.SH WIDGET HIERARCHY
.nf
\fIThe hierarchy of the xwpl application:\fR
.sp
.DT
Xwpl  xwpl
	Form  topBox
		Command  open
		Command  quit
		Command  info
		List  qmfList
		List  widthList
		List  basisList
		Funplot  qmfBox
		Phase   phase
		Funplot  window
		Funplot  original
		Funplot  cost
		Funplot  reconstruct
	TopLevelShell infoPopup
		Text  infoText
.sp
\fIThe hierarchy of the File Browser:\fR
.sp
TopLevelShell  fileBrowserShell
	Browser  file
	Scrollbar  fileListScrollbar
	Ilist  fileList
	Command  ok
	Command  cancel
	Text  text
.fi
.SH ENVIRONMENT
No environment variables are used yet.

.SH LIMITATIONS
Too many to mention.

.SH BUGS
If you find a bug, please send a bug report to majid@math.yale.edu.

.SH AUTHOR
Copyright (C) 1993  Fazal Majid
.PP
Copyright (c) 1989-1993 Yale University,
Fast Mathematical Algorithms & Hardware Inc.
Fazal Majid, R.R. Coifman, Y. Meyer, M.V. Wickerhauser

