/* BBRotator.h				 
 *
 * Rotates the world. Moves the camera. Will change a lot!!
 *
 * Usage: later...expect more to come
 *
 * Written by: 		Thomas Engel
 * Created:    		22.12.1993 (Copyleft)
 * Last modified: 	17.11.1994
 */

#import "appkit/appkit.h"
#import "3Dkit/3Dkit.h"
#import "Misc3DMouseDriver.h"

@interface BBRotator:Object <Misc3DMouseTarget>
{
	id	target;
	id	camera;
	id	deviceServer;
	id	deviceServerName;
	id	mouse3D;
	id  ourPort;
	
	id	panel;
	id	benchTime;
	
	id	aSlider;
	id	bSlider;
	id	cSlider;
	id	rotValue;
	id	xSlider;
	id	ySlider;
	id	zSlider;
	id	transValue;
	
	float	lastSliderValue;
}

- makeKeyAndOrderFront:sender;
- setTarget:anObject;
- setCamera:anObject;
- check3DMouse:sender;
- _connectTo3DServer:thePortName;
- _disconnectFrom3DServer;

- xRotation:sender;
- yRotation:sender;
- zRotation:sender;
- xTranslation:sender;
- yTranslation:sender;
- zTranslation:sender;

- benchMark:sender;

- fastStyle:sender;
- niceStyle:sender;

@end

/*
 * History: 17.11.94 Moved the 3DMosue support right here where it belongs.
 *
 *			07.05.94 Switched to BB..., and moved the PDO part to the main
 *					 AppManager.
 *
 *			12.04.94 Included 3DDeviceServer support.
 *
 *			26.03.94 Included the jump back slider and improved the slider
 *					 handling. Removed zoom.
 *
 *			15.01.94 Added the zoom mode.
 *
 *			22.12.93 First code written.
 *
 *
 * Bugs: yes
 */